/////////////////////////////////////////////////////////////////////////////
// Name:        dvdstyler.cpp
// Purpose:     DVD Authoring Application
// Author:      Alex Thuering
// Created:	10.10.2003
// RCS-ID:      $Id: dvdstyler.cpp,v 1.30 2008/02/25 19:16:55 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "MainWin.h"
#include "About.h"
#include "Config.h"
#include "Languages.h"
#include "MPEG.h"
#include <wx/config.h>
#include <wxVillaLib/imagjpg.h>
#include <wxVillaLib/utils.h>
#include <wxVillaLib/ThumbnailFactory.h>
#include <wxSVG/SVGCanvas.h>
#include <wxSVG/mediadec_ffmpeg.h>

#ifndef __WXWINCE__
#include <locale.h>
#endif

#include "rc/dvdstyler.png.h"

#define LOCALE_DIR wxFindDataDirectory(_T("..") + wxString(wxFILE_SEP_PATH) + _T("locale"))

class DVDStyler: public wxApp
{
  public:
    bool OnInit();

  protected:
    wxLocale m_locale;
};

IMPLEMENT_APP(DVDStyler)

bool DVDStyler::OnInit()
{
  //wxLog::SetActiveTarget(new wxLogStderr);
  
  // fix config
  s_config.Init();
  wxString version = s_config.GetVersion();
  if (version.length() < 3 || version.Mid(0,3) != APP_VERSION.Mid(0,3))
  {
    wxLogNull log;
    s_config.SetVersion(APP_VERSION);
    if (version.length() >= 3 && version.Mid(0,3) == wxT("1.5")) {
      s_config.DeleteGroup(_T("Generate"));
    } else {
      s_config.DeleteGroup(_T("Generate"));
      s_config.DeleteGroup(_T("Preview"));
      s_config.DeleteGroup(_T("Iso"));
      s_config.DeleteGroup(_T("Burn"));
    }
    s_config.Flush();
  }
  
  wxInitAllImageHandlers();
  // load new jpeg handler (with scale option)
  if (!wxImage::RemoveHandler(_T("JPEG file")))
    wxMessageBox(_T("Error: Can't remove old JPEG handler"));
  wxImage::InsertHandler(new wxJPGHandler);
  
  wxThumbnailFactory::InitGnome(APP_NAME.mb_str(), APP_VERSION.mb_str(),
	wxTheApp->argc, (char**)wxTheApp->argv);
	
  // locale
  int lang = s_config.GetLanguage();
  s_config.SetLanguage(wxLANGUAGE_ENGLISH); // save choosed languages only if all ok
  if (lang == -1)
    lang = ChooseLanguage();

  if (lang != wxLANGUAGE_ENGLISH)
  {
    m_locale.Init(lang);
    m_locale.AddCatalogLookupPathPrefix(LOCALE_DIR);
    m_locale.AddCatalog(wxT("dvdstyler"));
  }
  
#ifndef __WXWINCE__
  setlocale(LC_NUMERIC, "C");
#endif

  wxFfmpegMediaDecoder::Init();

  MainWin* mainWin = new MainWin();
  mainWin->SetIcon(wxICON_FROM_MEMORY(dvdstyler));
  if (argc > 1)
  {
	wxString filename = argv[1];
	if (filename.Right(4).Lower() == _T(".xml"))
	  mainWin->Open(filename);
	else
	{
	  for (int i=1; i<argc; i++)
	  {
	    wxString filename = argv[i];
		if (wxThumbnails::IsVideo(filename))
		{
		  if (!MPEG::IsValid(filename))
			wxLogError(filename + _(": not valid mpeg-file"));
		  else
			mainWin->AddTitle(filename);
		}
	  }
	}
  }
  mainWin->Show();
  SetTopWindow(mainWin);
  
  s_config.SetLanguage(lang); // save choosed languages if all ok
  
  return true;
}
