/////////////////////////////////////////////////////////////////////////////
// Name:        TitlePropDlg.h
// Purpose:     DVD title properties dialog
// Author:      Alex Thuering
// Created:     31.01.2004
// RCS-ID:      $Id: TitlePropDlg.h,v 1.5 2005/10/18 08:12:04 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef TITLE_PROP_DLG_H
#define TITLE_PROP_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>
#include "DVD.h"

class TitlePropDlg: public wxPropDlg
{
  public:
    TitlePropDlg(wxWindow *parent, DVD* dvd, Audio* audio, Video* video,
	  Pgc* pgc, Vob* vob);
	virtual ~TitlePropDlg() {}

  protected:
	DVD* m_dvd;
	Audio* m_audio;
	Video* m_video;
    Pgc* m_pgc;
	Vob* m_vob;
	void CreatePropPanel(wxSizer* sizer);
	bool SetValues();
	void CreateButtonPane(wxSizer* sizer, bool resetButton = false);
	void OnAV(wxCommandEvent& event);
	
  private:
    DECLARE_EVENT_TABLE()
};

#endif // TITLE_PROP_DLG_H
