/////////////////////////////////////////////////////////////////////////////
// Name:        DVDPropDlg.cpp
// Purpose:     DVD properties dialog
// Author:      Alex Thuering
// Created:     7.03.2005
// RCS-ID:      $Id: DVDPropDlg.cpp,v 1.10 2008/02/25 19:16:36 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#include "DVDPropDlg.h"
#include "Config.h"

DVDPropDlg::DVDPropDlg(wxWindow *parent, DVD* dvd):
 wxPropDlg(parent), m_dvd(dvd)
{
  Create(true);
  SetSize(400,-1);
}

void DVDPropDlg::CreatePropPanel(wxSizer* sizer)
{
  wxFlexGridSizer* grid = sizer ? new wxFlexGridSizer(2, 1, 16) : NULL;
  if (grid)
  {
    grid->AddGrowableCol(1);
    sizer->Add(grid, 0, wxEXPAND|wxALL, 6);
  }
  AddTextProp(grid, _("Volume name:"),
    grid ? m_dvd->GetName() : s_config.GetDefVolumeName());
  
  // Video and audio format
  wxFlexGridSizer* fSizer = sizer ? new wxFlexGridSizer(2, 1, 16) : NULL;
  if (sizer) {
  	fSizer->AddGrowableCol(0);
  	fSizer->AddGrowableCol(1);
  	sizer->Add(fSizer, 0, wxEXPAND|wxALL, 6);
  }
  wxSizer* grp = sizer ? BeginGroup(fSizer, _("Video Format")) : NULL;
  if (grp)
  	grp->Add(4,4);
  wxArrayString formats = DVD::GetVideoFormatStrings();
  AddRadioGroupProp(grp, formats, m_dvd->GetVideoFormat() - 1);
  if (grp)
    grp->Add(4,4);
  grp = BeginGroup(fSizer, _("Audio Format"));
  if (grp)
    grp->Add(4,4);
  formats = DVD::GetAudioFormatStrings();
  AddRadioGroupProp(grp, formats, m_dvd->GetAudioFormat() - 1);
  if (grp)
    grp->Add(4,4);
  
  grid = sizer ? new wxFlexGridSizer(2, 1, 16) : NULL;
  if (grid)
  {
    grid->AddGrowableCol(1);
    sizer->Add(grid, 0, wxEXPAND|wxALL, 6);
  }
  AddTextProp(grid, _("First Play Commands:"), m_dvd->GetVmgm().GetFpc());
  
  AddCheckProp(sizer, _("Create jumppads"),
	sizer ? m_dvd->IsJumppadsEnabled() : true);
  AddCheckProp(sizer, _("Create empty menu/vmMenu if it doesn't exist"),
	sizer ? m_dvd->IsEmptyMenuEnabled() : true);
}

bool DVDPropDlg::SetValues()
{
  int n = 0;
  m_dvd->SetName(GetString(n++));
  m_dvd->SetVideoFormat((VideoFormat) (GetInt(n++) + 1));
  m_dvd->SetAudioFormat((AudioFormat) (GetInt(n++) + 1));
  for (int tsi=-1; tsi<(int)m_dvd->GetTitlesets().GetCount(); tsi++) {
  	PgcArray& pgcs = m_dvd->GetPgcArray(tsi, true);
  	for (int pgci=0; pgci<(int)pgcs.GetCount(); pgci++) {
  	  Menu* menu = m_dvd->GetMenu(tsi, pgci);
  	  if (menu != NULL)
 		menu->SetVideoFormat(m_dvd->GetVideoFormat());
  	}
  }
  m_dvd->GetVmgm().SetFpc(GetString(n++));
  m_dvd->EnableJumppads(GetBool(n++));
  m_dvd->EnableEmptyMenu(GetBool(n++));
  return true;
}
