/////////////////////////////////////////////////////////////////////////////
// Name:        About.cpp
// Purpose:     About dialog
// Author:      Alex Thuering
// Created:     6.11.2003
// RCS-ID:      $Id: About.cpp,v 1.35 2008/02/24 09:50:51 ntalex Exp $
// Copyright:  (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "About.h"
#include "hyperlink.h"
#include <wxVillaLib/utils.h>
#include <wx/statline.h>
#include <wx/notebook.h>
#include <wx/html/htmlwin.h>

#include "rc/logo.png.h"

About::About(wxWindow* parent): wxDialog(parent, -1, wxEmptyString,
  wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE | wxRESIZE_BORDER)
{
    // sets the application icon
    SetTitle(_("About ..."));
	
	wxNotebook* notebook = new wxNotebook(this, -1);
	wxPanel* aboutPanel = new wxPanel(notebook, -1);
	notebook->AddPage(aboutPanel, _("About"));
	wxBoxSizer* aboutSizer = new wxBoxSizer(wxVERTICAL);
	aboutPanel->SetAutoLayout(true);
	aboutPanel->SetSizer(aboutSizer);
	
    // about info
    wxGridSizer* aboutinfo = new wxFlexGridSizer(2, 3, 3);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Written by: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_MAINT), 1, wxEXPAND | wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Version: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_VERSION), 1, wxEXPAND | wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Licence type: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_LICENCE), 1, wxEXPAND | wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, _("Copyright: ")), 0, wxALIGN_LEFT);
    aboutinfo->Add(new wxStaticText(aboutPanel, -1, APP_COPYRIGTH), 1, wxEXPAND | wxALIGN_LEFT);

    // about title/info
    wxBoxSizer* abouttext = new wxBoxSizer(wxVERTICAL);
    wxStaticText* appname = new wxStaticText(aboutPanel, -1, APP_NAME);
    appname->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD));
    abouttext->Add(appname, 0, wxALIGN_LEFT);
    abouttext->Add(0, 10);
    abouttext->Add(aboutinfo, 1, wxEXPAND);

    // about icontitle//info
    wxBoxSizer* aboutpane = new wxBoxSizer(wxHORIZONTAL);
    wxBitmap bitmap = wxBITMAP_FROM_MEMORY(logo);
    aboutpane->Add(new wxStaticBitmap(aboutPanel, -1, bitmap), 0, wxALIGN_LEFT);
    aboutpane->Add(10, 0);
    aboutpane->Add(abouttext, 1, wxEXPAND);
	
    // about description
    aboutSizer->Add(aboutpane, 0, wxEXPAND | wxALL, 10);
    aboutSizer->Add(new wxStaticText(aboutPanel, -1,
	  _("DVDStyler is a crossplatform authoring system for Video DVD production.")),
	  0, wxALIGN_CENTER | wxLEFT | wxRIGHT, 10);
    aboutSizer->Add(0, 6);
    myHyperLink* website = new myHyperLink(aboutPanel, -1, APP_WEBSITE);
    wxString url = APP_WEBSITE;
    website->SetURL(url);
    aboutSizer->Add(website, 0, wxALIGN_CENTER);
	
	// authors
	wxHtmlWindow* authorsPanel = new wxHtmlWindow(notebook, -1,
	  wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxHW_SCROLLBAR_AUTO);
	wxString page = _T("<html><body>");
	page += _T("<font face='Verdana,Arial,Helvetica,sans-serif' size='1'>");
	page += _T("<table width='100%' cellspacing='1' cellpadding='0' border='0'>");
	
	page += _T("<tr><td colspan=3><b>");
	page += _("Author and Maintainer");
	page += _T("</b></td></tr>");
	page += _T("<tr><td width='16'>&nbsp;</td><td colspan=2>");
	page += _T("Alex Th&uuml;ring &lt;alex.thuering at web.de&gt;");
	page += _T("</td></tr>");
	
	page += _T("<tr><td colspan=3>&nbsp;</td></tr>");
	
	page += _T("<tr><td colspan=3><b>");
	page += _("Doc Writer");
	page += _T("</b></td></tr>");
	page += _T("<tr><td width='16'>&nbsp;</td><td colspan=2>");
	page += _T("Don Brett &lt;dlbrett at zoominternet.net&gt;");
	page += _T("</td></tr>");
	
	page += _T("<tr><td colspan=3>&nbsp;</td></tr>");
	
	page += _T("<tr><td colspan=3><b>");
	page += _("Packager (.deb)");
	page += _T("</b></td></tr>");
	page += _T("<tr><td width='16'>&nbsp;</td><td colspan=2>");
	page += _T("J&uuml;rgen Braun &lt;jaybe at users.sourceforge.net&gt;");
	page += _T("</td></tr>");
	page += _T("<tr><td width='16'>&nbsp;</td><td colspan=2>");
	page += _T("Uwe Bugla &lt;uwe.bugla at gmx.de&gt;");
	page += _T("</td></tr>");
	
	page += _T("<tr><td colspan=3>&nbsp;</td></tr>");
	
	page += _T("<tr><td colspan=3><b>");
	page += _("Translations");
	page += _T("</b></td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Basque</td><td width='100%'>Piarres Beobide &lt;pi at beobide.net&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Catalan</td><td width='100%'>Miguel Canteras &lt;ca at openlang.net&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Czech</td><td width='100%'>Vlastimil Skácel &lt;vlastiks at gmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Danish</td><td width='100%'>Patrick Fust &lt;patrick_fust at hotmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Dutch</td><td width='100%'>Patrick Vijgeboom &lt;patrick.vijgeboom at wanadoo.nl&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>French</td><td width='100%'>Philippe Martin &lt;phil.martins at laposte.net&gt;, Uwe Bugla</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>German</td><td>Alex Thuering &lt;alex.thuering at web.de&gt;, Uwe Bugla</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Hungarian</td><td>Faczan Laszlo &lt;faczan at freemail.hu&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Italian</td><td>Roberto Minotti &lt;khazad-dum at mail.orson.it&gt;, Paolo Rampino &lt;akir4d at gmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Japanese</td><td>Montty &lt;montty_jp at yahoo.co.jp&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Polish</td><td>Michal Jusyk &lt;drewnozlasu at o2.pl&gt;</td></tr>"); 
	page += _T("<tr><td>&nbsp;</td><td>Portuguese</td><td>Henrique Lopes Barone &lt;barone_henrique at yahoo.com.br&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Portuguese (Brazilian)</td><td>Henrique Lopes Barone &lt;barone_henrique at yahoo.com.br&gt;, Marco de Freitas &lt;marcodefreitas at gmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Russian</td><td>Alex Thuering &lt;alex.thuering at web.de&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Serbian</td><td>CICIC Ivana &lt;ozzii23 at gmail.com&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Slovak</td><td>Michal Kovac &lt;deadsock at deadsock.co.uk&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Spanish</td><td>Redy Rodriguez &lt;redy at telefonica.net&gt;</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>Swedish</td><td>Daniel Nylander &lt;po at danielnylander.se&gt;</td></tr>");
	
	page += _T("<tr><td colspan=3>&nbsp;</td></tr>");
	
	page += _T("<tr><td colspan=3><b>");
	page += _("Libraries and Tools");
	page += _T("</b></td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>wxWidgets</td><td>Julian Smart, Robert Roebling and other</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>dvdauthor</td><td>Scott Smith</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>mjpeg tools</td><td>Rainer Johanni, Gernot Ziegler and other</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>mpgtx</td><td>Laurent Alacoque</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>cdrtools</td><td>Joerg Schilling</td></tr>");
	page += _T("<tr><td>&nbsp;</td><td>dvd+rw-tools</td><td>Andy Polyakov</td></tr>");
	
	page += _T("</table>");
	page += _T("</font>");
	page += _T("</body></html>");
	authorsPanel->SetPage(page); 
	notebook->AddPage(authorsPanel, _("Authors"));
	
	// licence
	wxHtmlWindow* licencePanel = new wxHtmlWindow(notebook, -1,
	  wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxHW_SCROLLBAR_AUTO);
	page = _T("<html><body>");
	page += _T("<font face='Verdana,Arial,Helvetica,sans-serif' size='1'>");
	page += _T("<p>");
	page += _("DVDStyler is <a href='http://www.gnu.org/philosophy/free-sw.html'>free software</a> \
distributed under <a href='http://www.gnu.org/copyleft/gpl.html'>GNU General Public License (GPL)</a>. \
Please visit those sites for details of each agreement.");
	page += _T("</p>");
	page += _T("<p>");
	page += _("THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, \
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, \
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS \
OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, \
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR \
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.");
	page += _T("</p>");
	page += _T("</font>");
	page += _T("</body></html>");
	licencePanel->SetPage(page); 
	notebook->AddPage(licencePanel, _("Licence"));
	
	// buttons
	wxBoxSizer* totalpane = new wxBoxSizer(wxVERTICAL);
#if wxCHECK_VERSION(2,6,0)
	totalpane->Add(notebook, 1, wxEXPAND|wxALL, 6);
#else
    totalpane->Add(new wxNotebookSizer(notebook), 1, wxEXPAND|wxALL, 6);
#endif
    wxButton* okButton = new wxButton(this, wxID_OK, _("OK"));
    okButton->SetDefault();
#if defined(__WXGTK__) && wxCHECK_VERSION(2,5,2) && !wxCHECK_VERSION(2,5,4)
	okButton->SetSizeHints(-1, okButton->GetSize().GetY()+8);
#endif
    totalpane->Add(okButton, 0, wxALIGN_CENTER|wxLEFT|wxRIGHT|wxBOTTOM, 10);
	
    SetSizerAndFit(totalpane);
	Center();

    ShowModal();
}
