#ifndef INCLUDE_WINSYSTEM_H
#define INCLUDE_WINSYSTEM_H
#include <iostream>
#include <string>
#include "../src-common/cfdg.h"
#include "resource.h"

class CChildFrame;

class WinSystem : public System 
{
public:
    WinSystem();
    ~WinSystem();
    virtual void message(const char* fmt, ...);
    virtual void syntaxError(const std::string& filepath, int line);
    
    virtual std::istream* openFileForRead(const std::string& path);
    virtual std::istream* tempFileForRead(const std::string& path);
    virtual std::ostream* tempFileForWrite(std::string& prefixInNameOut);
    // caller must delete returned streams when done
    
    virtual std::string relativeFilePath(
        const std::string& base, const std::string& rel);

    virtual void stats(const Stats&);

    static const char* GetExample(LPCTSTR name, int& length);
    static const char* GetExample(UINT nID, int& length);
    static LPCTSTR GetExampleName(UINT nID);
    CChildFrame*    mFrame;
    std::string  mErrorPath;
};

#endif  // INCLUDE_WINSYSTEM_H