#include "stdafx.h"
#include "WinSystem.h"
#include "../src-common/cfdg.h"
#include "ContextFree.h"
#include "ContextFreeView.h"
#include "ContextFreeDoc.h"
#include "ChildFrm.h"
#include "stdafx.h"
#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <shlwapi.h>
#include <stdio.h>
#include <string.h>
#include "CRenderView.h"
#include "resource.h"

using namespace std;

extern CContextFreeApp theApp;


LPCTSTR WinSystem::GetExampleName(UINT nID)
{
    static LPTSTR exampleNames[IDS_EX_I_PIX - IDS_EX_CILIASUN + 1];
    static bool initialized = false;

    if (nID == 0) {
        if (!initialized) return _T("");
        for(UINT j = IDS_EX_CILIASUN; j <= IDS_EX_I_POLYS; j++) 
            delete[] exampleNames[j - IDS_EX_CILIASUN];
        return _T("");
    }

    ASSERT(nID >= IDS_EX_CILIASUN && nID <= IDS_EX_I_POLYS);
    if (!initialized) {
        initialized = true;
        // Load the names of the embedded rules files from the string table
        // This code assumes that the strings are all less than 100 chars
        for(UINT i = IDS_EX_CILIASUN; i <= IDS_EX_I_POLYS; i++) {
            TCHAR buf[100];
            int res = LoadString(GetModuleHandle(NULL), i, buf, 100);
            ASSERT(res);
            exampleNames[i - IDS_EX_CILIASUN] = new TCHAR[_tcslen(buf) + 1];
            _tcscpy(exampleNames[i - IDS_EX_CILIASUN], buf);
        }
    }
    return exampleNames[nID - IDS_EX_CILIASUN];
}

WinSystem::WinSystem()
:   mFrame(0),
    mErrorPath("")
{
}

WinSystem::~WinSystem()
{
}

void WinSystem::message(const char* fmt, ...)
{
    va_list args;
    va_start(args, fmt);
    char cbuf[256];
    _vsnprintf(cbuf, 256, fmt, args);
    cbuf[255] = '\0';
    va_end(args);
    
    if (!mErrorPath.empty()) {
        strcat(cbuf, " - ");
        strcat(cbuf, ::PathFindFileNameA(mErrorPath.c_str()));
        mErrorPath = "";
    }

    LPTSTR buf = new TCHAR[strlen(cbuf) + 1];
#ifdef _UNICODE
    ::mbstowcs(buf, cbuf, strlen(cbuf) + 1);
#else
    strcpy(buf, cbuf);
#endif

    if (!mFrame->PostMessage(WM_USER_MESSAGE_UPDATE,(WPARAM)buf, NULL))
        delete[] buf;
}

void WinSystem::syntaxError(const std::string& filepath, int line)
{
    mErrorPath = filepath;
    LPTSTR buf = new TCHAR[MAX_PATH + 1];
#ifdef _UNICODE
    ::mbstowcs(buf, filepath.c_str(), MAX_PATH + 1);
#else
    strcpy(buf, filepath.c_str());
#endif
    if (!mFrame->PostMessage(WM_USER_SYNTAX_ERROR,(WPARAM)buf, line))
        delete[] buf;
}

const char* WinSystem::GetExample(LPCTSTR name, int& size) 
{
    for(UINT i = IDS_EX_CILIASUN; i <= IDS_EX_I_POLYS; i++) {
        if (!_tcscmp(GetExampleName(i), name)) 
            return GetExample(i, size);
    }
    return NULL;
}

const char* WinSystem::GetExample(UINT nID, int& size) 
{
    HRSRC src = FindResource(NULL, (LPCTSTR)nID, RT_RCDATA);
    if (!src) return NULL;
    size = SizeofResource(NULL, src);
    if (!size) return NULL;
    HGLOBAL glob = LoadResource(NULL, src);
    if (!glob) return NULL;
    char* cfdg = (char*)LockResource(glob);
    if (!cfdg) return NULL;
    return cfdg;
}

std::istream* WinSystem::openFileForRead(const std::string& path)
{
#ifdef _UNICODE
    TCHAR tpath[MAX_PATH + 1];
    ::mbstowcs(tpath, path.c_str(), MAX_PATH + 1);
#else
    const TCHAR* tpath = path.c_str();
#endif

    CContextFreeDoc* doc = theApp.GetDocFromName(tpath);
    if (doc) {
        return new stringstream(doc->GetContents());
    } else {
        int len;
        const char* cfdg = GetExample(tpath, len);
        if (cfdg) {
            basic_stringstream<char>* s = new stringstream;
            s->write(cfdg, len);
            s->seekp(0, ios::beg);
            return s;
        }
        
        return new ifstream(path.c_str(), ios::binary);
    }
}

std::istream* WinSystem::tempFileForRead(const std::string& path)
{
    return new ifstream(path.c_str(), ios::binary);
}

std::ostream* WinSystem::tempFileForWrite(std::string& prefixInNameOut)
{
    char* path = _tempnam(0, prefixInNameOut.c_str());
    prefixInNameOut = path;
    ofstream* f = new ofstream(path, ios::binary | ios::out | ios::trunc);
    free((void*)path);
    return f;
}

std::string WinSystem::relativeFilePath(const std::string& base, const std::string& rel)
{
    char buf[MAX_PATH+1];
    strcpy(buf, base.c_str());
    PathRemoveFileSpecA(buf);
    PathAppendA(buf, rel.c_str());
	if (PathFileExistsA(buf))
	    return string(buf);
	else
		return rel;
}

void WinSystem::stats(const Stats& s)
{
    Stats* stat = new Stats(s);
    if (!mFrame->PostMessage(WM_USER_STATUS_UPDATE,(WPARAM)stat, NULL))
        delete stat;
}

