#pragma once

#include "resource.h"
#include "StatusIcon.h"
#include "variation.h"
#include <afxinet.h>
#include <afxhtml.h>
#include "HTMLCtrl.h"

class CUploadWiz;

// CUploadAcct dialog

class CUploadAcct : public CPropertyPage
{
	DECLARE_DYNAMIC(CUploadAcct)

public:
	CUploadAcct();
	virtual ~CUploadAcct();

// Dialog Data
	enum { IDD = IDD_UPLOAD_ACCT };
    virtual BOOL OnSetActive();
    virtual BOOL OnKillActive();
    CUploadWiz* mWiz;


protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    afx_msg void OnRegisterButton();
    CToolTipCtrl* mToolTip;
    virtual BOOL PreTranslateMessage(MSG* pMsg);

	DECLARE_MESSAGE_MAP()
};

// CUploadDesign dialog

class CUploadDesign : public CPropertyPage
{
	DECLARE_DYNAMIC(CUploadDesign)

public:
	CUploadDesign();
	virtual ~CUploadDesign();

// Dialog Data
	enum { IDD = IDD_UPLOAD_DESIGN };
    virtual BOOL OnSetActive();
    virtual BOOL OnKillActive();
    CUploadWiz* mWiz;


protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    CString mVariationString;
    CToolTipCtrl* mToolTip;
    virtual BOOL PreTranslateMessage(MSG* pMsg);

	DECLARE_MESSAGE_MAP()
};

// CUploadStatus dialog

class CUploadStatus : public CPropertyPage
{
	DECLARE_DYNAMIC(CUploadStatus)

public:
	CUploadStatus();
	virtual ~CUploadStatus();

// Dialog Data
	enum { IDD = IDD_UPLOAD_STATUS };
    virtual BOOL OnSetActive();
    virtual BOOL OnKillActive();
    CUploadWiz* mWiz;
    void UploadIt();
    void OnStatusCallback(DWORD, DWORD, LPVOID, DWORD);


protected:
    afx_msg void OnTimer( UINT nIDEvent );
	CStatusIcon	mStatusIcon;
    bool mReqSent;
    bool mHTMLinitialized;
    CHTMLCtrl       mHTMLStatus; 
	CWinThread*		mUploadThread;
    UINT          mTimerID;
    void AddStatusText(LPCSTR text, bool mustDelete = false);
    LRESULT OnUploadOver(WPARAM ,LPARAM);
    LRESULT OnStatusUpdate(WPARAM ,LPARAM);
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
};

class CMyInternetSession : public CInternetSession
{
public:
	/* explicit */ CMyInternetSession(LPCTSTR pstrAgent = NULL,
		DWORD_PTR dwContext = 1,
		DWORD dwAccessType = PRE_CONFIG_INTERNET_ACCESS,
		LPCTSTR pstrProxyName = NULL,
		LPCTSTR pstrProxyBypass = NULL,
		DWORD dwFlags = 0);
    void OnStatusCallback(DWORD, DWORD, LPVOID, DWORD);
    CUploadStatus* mUploadPage;
};


