// src-win\UploadPages.cpp : implementation file
//

#include "stdafx.h"
#include "ContextFree.h"
#include "UploadPages.h"
#include "UploadWiz.h"
#include "ContextFree.h"
#include "ChildFrm.h"
#include "gdiplus.h"
#include "upload.h"
#include "ChildFrm.h"
#include <sstream>
#include <afxinet.h>
#include <afxhtml.h>
#include "HTMLCtrl.h"

extern CContextFreeApp theApp;

using namespace Gdiplus;

static UINT UploadThreadProc(LPVOID frame);

// CUploadAcct dialog

IMPLEMENT_DYNAMIC(CUploadAcct, CPropertyPage)

CUploadAcct::CUploadAcct()
	: CPropertyPage(CUploadAcct::IDD)
{
}

CUploadAcct::~CUploadAcct()
{
}

void CUploadAcct::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
    DDX_Text(pDX, IDC_USERNAME, mWiz->mUserName);
    DDX_Text(pDX, IDC_PASSWORD, mWiz->mPassword);
    DDX_Check(pDX, IDC_SKIP_ACCT, mWiz->mSkipAcct);
}


BEGIN_MESSAGE_MAP(CUploadAcct, CPropertyPage)
    ON_BN_CLICKED(IDC_UPLOAD_REGISTER, OnRegisterButton)
END_MESSAGE_MAP()


// CUploadAcct message handlers
BOOL CUploadAcct::OnKillActive()
{
    UpdateData(TRUE);
    if (mWiz->mUserName.GetLength() == 0) {
        AfxMessageBox(_T("You must specify a username."));
        CEdit* edit = (CEdit*) GetDlgItem(IDC_USERNAME);
        edit->SetFocus();
        edit->SetSel(0, -1);
        return 0;
    }
    if (mWiz->mPassword.GetLength() == 0) {
        AfxMessageBox(_T("You must specify a password."));
        CEdit* edit = (CEdit*) GetDlgItem(IDC_PASSWORD);
        edit->SetFocus();
        edit->SetSel(0, -1);
        return 0;
    }

    delete mToolTip;
    mToolTip = 0;

    theApp.setPrefUsername(mWiz->mUserName);
    theApp.setPrefPassword(mWiz->mPassword);
    theApp.setPrefSkipAcct(mWiz->mSkipAcct);
    return CPropertyPage::OnKillActive();
}

BOOL CUploadAcct::OnSetActive()
{
    //Set up the tooltip
    mToolTip = new CToolTipCtrl();
    if(!mToolTip->Create(this)) {
       TRACE("Unable To create ToolTip\n");
       return TRUE;
    }
    mToolTip->Activate(TRUE);

    CWnd* pWnd = GetWindow(GW_CHILD);
    while (pWnd) {
        int nID = pWnd->GetDlgCtrlID();
        if (nID == IDC_UPLOAD_REGISTER) {
            mToolTip->AddTool(pWnd, _T("Opens browser on registration page"));
        }
        pWnd = pWnd->GetWindow(GW_HWNDNEXT);
    }

    mWiz->SetWizardButtons(PSWIZB_NEXT);

    return CPropertyPage::OnSetActive();
}

void CUploadAcct::OnRegisterButton()
{
    ShellExecute(NULL, _T("open"), 
        _T("http://www.contextfreeart.org/phpbb/profile.php?mode=register"), 
        NULL, NULL, SW_SHOWNORMAL);
}

// Override PreTranslateMessage() so RelayEvent() can be 
// called to pass a mouse message to the page's 
// tooltip control for processing.
BOOL CUploadAcct::PreTranslateMessage(MSG* pMsg) 
{
   if (NULL != mToolTip)            
      mToolTip->RelayEvent(pMsg);
   
   return CPropertyPage::PreTranslateMessage(pMsg);
}

// CUploadDesign dialog

IMPLEMENT_DYNAMIC(CUploadDesign, CPropertyPage)

CUploadDesign::CUploadDesign()
	: CPropertyPage(CUploadDesign::IDD)
{

}

CUploadDesign::~CUploadDesign()
{
}

void CUploadDesign::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
    DDX_Text(pDX, IDC_UPLOAD_TITLE, mWiz->mTitle);
    DDX_Text(pDX, IDC_UPLOAD_FILENAME, mWiz->mCFDGFileName);
    DDX_Text(pDX, IDC_UPLOAD_VARIATION, mVariationString);
    DDX_Radio(pDX, IDC_ENCODE_JPEG, mWiz->mImageCompression);
    DDX_Check(pDX, IDC_UPLOAD_CROP, mWiz->mCropped);
    DDX_Text(pDX, IDC_UPLOAD_NOTE, mWiz->mAuthorNote);
}


BEGIN_MESSAGE_MAP(CUploadDesign, CPropertyPage)
END_MESSAGE_MAP()


// CUploadAcct message handlers
BOOL CUploadDesign::OnKillActive()
{
    UpdateData(TRUE);
    if (mWiz->mTitle.GetLength() < 3 || mWiz->mTitle.GetLength() > 20) {
        AfxMessageBox(_T("You must specify a title between 3 and 20 characters."));
        CEdit* edit = (CEdit*) GetDlgItem(IDC_UPLOAD_TITLE);
        edit->SetFocus();
        edit->SetSel(0, -1);
        return 0;
    }
    if (mWiz->mCFDGFileName.GetLength() == 0) {
        AfxMessageBox(_T("You must specify a filename."));
        CEdit* edit = (CEdit*) GetDlgItem(IDC_UPLOAD_FILENAME);
        edit->SetFocus();
        edit->SetSel(0, -1);
        return 0;
    }

    delete mToolTip;
    mToolTip = 0;

    theApp.setPrefCrop(mWiz->mCropped);
    return CPropertyPage::OnKillActive();
}

BOOL CUploadDesign::OnSetActive()
{
    //Set up the tooltip
    mToolTip = new CToolTipCtrl();
    if(!mToolTip->Create(this)) {
       TRACE("Unable To create ToolTip\n");
       return TRUE;
    }
    mToolTip->Activate(TRUE);

    CWnd* pWnd = GetWindow(GW_CHILD);
    while (pWnd) {
        int nID = pWnd->GetDlgCtrlID();
        switch (nID) {
        case IDC_UPLOAD_FILENAME:
            mToolTip->AddTool(pWnd, _T("File name other people will get when they download"));
            break;
        case IDC_ENCODE_JPEG:
        case IDC_ENCODE_PNG8:
            mToolTip->AddTool(pWnd, _T("Default setting is probably best"));
            break;
        case IDC_UPLOAD_TITLE:
            mToolTip->AddTool(pWnd, _T("Required field"));
            break;
        }
        pWnd = pWnd->GetWindow(GW_HWNDNEXT);
    }

    TCHAR code[Variation::maxStringLength + 1];
    Variation::toString(mWiz->mVariation, code, false);
    mVariationString = code;

    mWiz->SetWizardButtons(PSWIZB_NEXT | PSWIZB_BACK);
    return CPropertyPage::OnSetActive();
}

// Override PreTranslateMessage() so RelayEvent() can be 
// called to pass a mouse message to the page's 
// tooltip control for processing.
BOOL CUploadDesign::PreTranslateMessage(MSG* pMsg) 
{
   if (NULL != mToolTip)            
      mToolTip->RelayEvent(pMsg);
   
   return CPropertyPage::PreTranslateMessage(pMsg);
}

void CMyInternetSession::OnStatusCallback(DWORD context, DWORD internetStatus,
    LPVOID statusInfo, DWORD statusInfoLength )
{
    AFX_MANAGE_STATE(AfxGetAppModuleState());
    mUploadPage->OnStatusCallback(context, internetStatus, statusInfo, statusInfoLength);
}

CMyInternetSession::CMyInternetSession(LPCTSTR agent, DWORD_PTR context,
	DWORD accessType, LPCTSTR proxyName, LPCTSTR proxyBypass, DWORD flags)
  : CInternetSession(agent, context, accessType, proxyName, proxyBypass, flags)
{ }

// CUploadStatus dialog

IMPLEMENT_DYNAMIC(CUploadStatus, CPropertyPage)

CUploadStatus::CUploadStatus()
	: CPropertyPage(CUploadStatus::IDD),
    mHTMLinitialized(false),
    mUploadThread(0),
    mTimerID(0)
{

}

CUploadStatus::~CUploadStatus()
{
}

void CUploadStatus::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATUS_ICON, mStatusIcon);
}


BEGIN_MESSAGE_MAP(CUploadStatus, CPropertyPage)
    ON_WM_TIMER()
    ON_MESSAGE(WM_USER_STATUS_UPDATE, OnStatusUpdate)
    ON_MESSAGE(WM_USER_RENDER_OVER, OnUploadOver)
END_MESSAGE_MAP()


// CUploadStatus message handlers
BOOL CUploadStatus::OnKillActive()
{
    if (mTimerID) {
        KillTimer(mTimerID);
        mTimerID = 0;
    }
    return CPropertyPage::OnKillActive();
}

BOOL CUploadStatus::OnSetActive()
{
    mWiz->SetWizardButtons(0);
    mTimerID = SetTimer(1, 100, 0);
    UpdateData(FALSE);
    AddStatusText("Initiating upload.");

    if (!mHTMLinitialized) 
        mHTMLStatus.CreateFromStatic(IDC_HTML_STATUS, this);
    mHTMLinitialized = true;

    // Create stream with 0 size
    IStream* pIStream    = NULL;
    if(CreateStreamOnHGlobal(NULL, TRUE, (LPSTREAM*)&pIStream) != S_OK)
    {
        AddStatusText("Failed to create stream on global memory!");
        return CPropertyPage::OnSetActive();
    }

    Status SaveStatus = mWiz->mFrame->SaveToPNGorJPEG(pIStream, false, true);

    if(SaveStatus != Ok)
    {
        // this should free global memory used by the stream
        // according to MSDN
        pIStream->Release();
        AddStatusText("Failed to save to stream!");
        return CPropertyPage::OnSetActive();
    }

    // get the size of the stream
    ULARGE_INTEGER ulnSize;
    LARGE_INTEGER lnOffset;
    lnOffset.QuadPart = 0;
    if(pIStream->Seek(lnOffset, STREAM_SEEK_END, &ulnSize) != S_OK)
    {
        pIStream->Release();
        AddStatusText("Failed to get the size of the stream!");
        return CPropertyPage::OnSetActive();
    }

    // now move the pointer to the beginning of the file
    if(pIStream->Seek(lnOffset, STREAM_SEEK_SET, NULL) != S_OK) {
        pIStream->Release();
        AddStatusText("Failed to move the file pointer to the beginning of the stream!");
        return CPropertyPage::OnSetActive();
    }

    HGLOBAL pngGlob;
    char* pngdata;
    if ((GetHGlobalFromStream(pIStream, &pngGlob) != S_OK) ||
        ((pngdata = (char*)GlobalLock(pngGlob)) == NULL)) {
        pIStream->Release();
        AddStatusText("Failed to access stream data!");
        return CPropertyPage::OnSetActive();
    }

#ifdef _UNICODE
    char buf[65536];
#else
    const char* buf;
#endif
    Upload u;

#ifdef _UNICODE
    ::wcstombs(buf, mWiz->mUserName, 65535);
#else
    buf = mWiz->mUserName;
#endif
    u.mUserName = buf;

#ifdef _UNICODE
    ::wcstombs(buf, mWiz->mPassword, 65535);
#else
    buf = mWiz->mPassword;
#endif
    u.mPassword = buf;

#ifdef _UNICODE
    ::wcstombs(buf, mWiz->mTitle, 65535);
#else
    buf = mWiz->mTitle;
#endif
    u.mTitle = buf;

#ifdef _UNICODE
    ::wcstombs(buf, mWiz->mAuthorNote, 65535);
#else
    buf = mWiz->mAuthorNote;
#endif
    u.mNotes = buf;

#ifdef _UNICODE
    ::wcstombs(buf, mWiz->mCFDGFileName, 65535);
#else
    buf = mWiz->mCFDGFileName;
#endif
    u.mFileName = buf;

    u.mFileName += ".cfdg";
    u.mVariation = mWiz->mVariation;
    u.mCompression = mWiz->mImageCompression ? Upload::CompressPNG8 : Upload::CompressJPEG;
    u.mTiled = mWiz->mTiled;

    u.mText = mWiz->mCFDG.c_str();
    u.mTextLen = strlen(u.mText);
    u.mImage = pngdata;
    u.mImageLen = (size_t)(ulnSize.QuadPart);

    std::ostringstream payload;
    u.generatePayload(payload);
    mWiz->mPayload = payload.str();


    GlobalUnlock(pngGlob);
    pIStream->Release();

    mUploadThread = AfxBeginThread(UploadThreadProc, (LPVOID)this); // kick off render thread
    mUploadThread->m_bAutoDelete = TRUE;

    return CPropertyPage::OnSetActive();
}

void CUploadStatus::OnTimer(UINT nIDEvent)
{
    if (nIDEvent == mTimerID) 
        mStatusIcon.Update(1);
}

LRESULT CUploadStatus::OnStatusUpdate(WPARAM c, LPARAM del)
{
    char* cstr = (char*)c;
    if (del) {
        CString html(cstr);
        mHTMLStatus.SetNewHTMLContent(html);
        delete[] cstr;
    } else {
        CString html(_T("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n\n<html xmlns=\"http://www.w3.org/1999/xhtml\"\n	lang=\"en\"\n	xml:lang=\"en\">\n\n<head>\n<title>Context Free Uploader</title>\n<meta http-equiv=\"Content-Type\"\n	content=\"text/html;	charset=utf-8\" />\n</head>\n<body style=\"font: 10pt verdana, arial, Helvetica, sans-serif;\">\n<p>"));
        html += cstr;
        html += _T("</p></body></html>");
        mHTMLStatus.SetNewHTMLContent(html);
    }
    return 0;
}

LRESULT CUploadStatus::OnUploadOver(WPARAM status,LPARAM)
{
    if (mTimerID) {
        KillTimer(mTimerID);
        mTimerID = 0;
    }

    mStatusIcon.Update(0);

    if (status == 409) {
        mWiz->SetWizardButtons(PSWIZB_BACK);
    } else {
        mWiz->SetWizardButtons(PSWIZB_FINISH);
        mWiz->SetFinishText(_T("Close"));
        CancelToClose();
    }

    return 0;
}

void CUploadStatus::AddStatusText(LPCSTR text, bool mustDelete)
{
    if (::IsWindow(m_hWnd)) {
        ::PostMessage(m_hWnd, WM_USER_STATUS_UPDATE, (WPARAM)text, (LPARAM)mustDelete);
    } else {
        if (mustDelete)
            delete[] text;
    }
}

static char tempBuf[256];

void CUploadStatus::UploadIt()
{
    mReqSent = false;
    char* response = 0;
    DWORD status;
    UINT len;
    CMyInternetSession* theNet = 0;
    CHttpConnection* theConnection = 0;
    CHttpFile* theRequest = 0;

    try {
        theNet = new CMyInternetSession(NULL, 1, INTERNET_OPEN_TYPE_DIRECT, 
            NULL, NULL, INTERNET_FLAG_DONT_CACHE);
        theNet->mUploadPage = this;
        theNet->EnableStatusCallback(TRUE);
        theConnection = theNet->GetHttpConnection(_T("www.contextfreeart.org"));
        theRequest = theConnection->OpenRequest(CHttpConnection::HTTP_VERB_POST, 
            _T("gallery/upload.php"), NULL, 1, NULL, _T("HTTP/1.0"), 
            INTERNET_FLAG_DONT_CACHE);

        CString header = Upload::generateHeader().c_str();
        theRequest->SendRequest(header, (LPVOID)(mWiz->mPayload.c_str()), mWiz->mPayload.length());
        theRequest->QueryInfoStatusCode(status);
        mWiz->mPayload = "";

        len = (UINT)theRequest->GetLength();
        response = new char[len + 1];
        theRequest->Read((void*)response, len + 1);
        response[len] = '\0';

        theRequest->Close();
        delete theRequest;
        theConnection->Close();
        delete theConnection;
        theNet->EnableStatusCallback(FALSE);
        theNet->Close();
        delete theNet;
    } catch (CInternetException *ie) {
        if (theNet) theNet->EnableStatusCallback(FALSE);
        AddStatusText("Failed to connect to the gallery site.");
        ::MessageBeep(MB_OK);
        if (::IsWindow(m_hWnd))
            ::PostMessage(m_hWnd, WM_USER_RENDER_OVER, (WPARAM)200, NULL);

        mUploadThread = 0;
        ie->Delete();
        delete theRequest;
        delete theConnection;
        delete response;
        if (theNet) theNet->Close();
        delete theNet;
        return;
    }

    if (status == 200 || status == 409) {
        AddStatusText(response, true);
    } else if (status == 404) {
        delete[] response;
        AddStatusText("The gallery upload service is currently unavailable.");
    } else {
        delete[] response;
        wsprintfA(tempBuf, "HTTP error %d returned", status);
        AddStatusText(tempBuf);
    }
    ::MessageBeep(MB_OK);
    if (::IsWindow(m_hWnd))
        ::PostMessage(m_hWnd, WM_USER_RENDER_OVER, (WPARAM)status, NULL);
}

void CUploadStatus::OnStatusCallback(DWORD , DWORD internetStatus,
    LPVOID statusInfo, DWORD  )
{
#ifdef _UNICODE
    char name[512];
#else
    char* name;
#endif
	switch (internetStatus) {
	    case INTERNET_STATUS_RESOLVING_NAME:
#ifdef _UNICODE
            ::wcstombs(name, (TCHAR*)statusInfo, 511);
#else
            name = (char*)statusInfo;
#endif
		    wsprintfA(tempBuf, "Resolving name %s... ", name);
            AddStatusText(tempBuf);
		    break;

	    case INTERNET_STATUS_CONNECTING_TO_SERVER:
		    AddStatusText("Connecting to server... ");
		    break;

	    case INTERNET_STATUS_SENDING_REQUEST:
            if (mReqSent) return;
		    AddStatusText("Sending request... ");
		    break;

	    case INTERNET_STATUS_RECEIVING_RESPONSE:
		    AddStatusText("Receiving response... ");
		    break;

	    default:
            return;
	}
}

static UINT UploadThreadProc(LPVOID frame)
{
    CUploadStatus* f = (CUploadStatus*)frame; 
    f->UploadIt();
    return 0;
}

