// RenderSize.cpp : implementation file
//

#include "stdafx.h"
#include "ContextFree.h"
#include "RenderSize.h"
#include "RenderOptions.h"

extern CContextFreeApp theApp;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRenderSize dialog


CRenderSize::CRenderSize(CWnd* pParent /*=NULL*/)
	: CDialog(CRenderSize::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRenderSize)
	mHeight = 1000;
	mWidth = 1000;
	mDontDisplay = FALSE;
	mMinSize = 0.3;
	mBorderSize = 0;
	//}}AFX_DATA_INIT
    getProfile();
}


void CRenderSize::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRenderSize)
	DDX_Control(pDX, IDC_BORDER_SLIDER, mBorderSliderCtrl);
	DDX_Text(pDX, IDC_EDIT_HEIGHT, mHeight);
	DDV_MinMaxUInt(pDX, mHeight, 1, 32768);
	DDX_Text(pDX, IDC_EDIT_WIDTH, mWidth);
	DDV_MinMaxUInt(pDX, mWidth, 1, 32768);
	DDX_Check(pDX, IDC_NODISPLAY, mDontDisplay);
	DDX_Text(pDX, IDC_EDIT_MINSIZE, mMinSize);
	DDV_MinMaxDouble(pDX, mMinSize, 0., 1000.);
	DDX_Slider(pDX, IDC_BORDER_SLIDER, mBorderSize);
	//}}AFX_DATA_MAP
}

void CRenderSize::OnOK()
{
    CDialog::OnOK();
    theApp.setPrefHeight(mHeight);
    theApp.setPrefWidth(mWidth);
    theApp.setPrefNoDisplay(mDontDisplay);
    TCHAR buf[100];
    _stprintf(buf, _T("%.4f"), mMinSize);
    theApp.setPrefMinSize(buf);
    theApp.setPrefBorderWidth(mBorderSize);
}


BOOL CRenderSize::OnInitDialog() 
{
    getProfile();

    CDialog::OnInitDialog();

    mBorderSliderCtrl.SetTic(33);
    mBorderSliderCtrl.SetTic(66);

    return TRUE;
}

void CRenderSize::getProfile()
{
    mHeight = theApp.getPrefHeight();
    mWidth = theApp.getPrefWidth();
	mDontDisplay = theApp.getPrefNoDisplay();
    mMinSize = theApp.getPrefMinSize();
    mBorderSize = theApp.getPrefBorderWidth();
}

BEGIN_MESSAGE_MAP(CRenderSize, CDialog)
	//{{AFX_MSG_MAP(CRenderSize)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRenderSize message handlers
