#pragma once
#include <gdiplus.h>

#define C_CCOLORDROPPERCTRL_CLASSNAME _T("MFCColorDropperCtrl")

// CColorDropperCtrl

class CColorDropperCtrl : public CWnd
{
	DECLARE_DYNAMIC(CColorDropperCtrl)

public:
	CColorDropperCtrl();
	virtual ~CColorDropperCtrl();
    void GetColor(Gdiplus::Color& c) const;
    enum {DROPPER_CHANGE = 5678};

protected:
    bool mInitialized;
    HCURSOR mDropperCursor;
    HCURSOR mPrevCursor;
    Gdiplus::Rect mDropperRect;
    static Gdiplus::Bitmap* DropperBitmap;
    Gdiplus::Color mColor;
    NMHDR mNotify;
    void Init();
    void TrackPoint();
    BOOL RegisterWindowClass();
    afx_msg void OnPaint();
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);

	DECLARE_MESSAGE_MAP()
};


