// ChildFrm.cpp : implementation of the CChildFrame class
//

#include "stdafx.h"
#include "ContextFree.h"
#include "ContextFreeView.h"
#include "ContextFreeDoc.h"

#include "ChildFrm.h"
#include "cfdg.h"
#include "variation.h"
#include "RenderSize.h"
#include "shlwapi.h"
#include "GdiPlus.h"
#include <mbstring.h>

#include "SVGCanvas.h"
#include "qtCanvas.h"
#include "tiledCanvas.h"
#include "CFString.h"
#include "FileDialogEx.h"
#include "UploadWiz.h"
#include "upload.h"
#include <sstream>

using namespace Gdiplus;

#pragma warning( disable : 4800 )

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static UINT RenderThreadProc(LPVOID frame);
/////////////////////////////////////////////////////////////////////////////
// CChildFrame

int CChildFrame::ChildCount = 0;

IMPLEMENT_DYNCREATE(CChildFrame, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CChildFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CChildFrame)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_DESTROY()
    ON_WM_SIZE()
    ON_BN_CLICKED(IDC_RENDER, OnRenderButton)
    ON_BN_CLICKED(IDC_SAVE_IMAGE, OnSaveImage)
    ON_EN_CHANGE(IDC_RANDOM, OnRandomText)
    ON_WM_TIMER()
    ON_MESSAGE(WM_USER_STATUS_UPDATE, OnStatusUpdate)
    ON_MESSAGE(WM_USER_MESSAGE_UPDATE, OnMessageUpdate)
    ON_MESSAGE(WM_USER_SYNTAX_ERROR, CFDGError)
    ON_MESSAGE(WM_USER_RENDER_OVER, OnRenderOver)
    ON_MESSAGE(WM_USER_MAXIMIZE_ME, OnMax)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChildFrame construction/destruction

CChildFrame::CChildFrame()
:mCFDG(0),
mRenderer(0),
mRenderThread(0),
mRenderAgain(false),
mRenderSizeAgain(false),
mRepeatRenderAgain(false),
mClose(false),
mAnimationCanvas(0),
mSVGCanvas(0),
mDescription(0),
mLastRenderWasToSize(false),
mThreadRunning(false),
mUsesAlpha(false),
mOwnCanvas(FALSE),
mCanvas(0),
mTiledCanvas(0),
mTimerID(0),
mBusyCount(0)
{
    mSystem.mFrame = this;
    mCtrlBar.mFrame = this;
}

CChildFrame::~CChildFrame()
{
    delete mCanvas;
    delete mRenderer;
    delete mCFDG;
    delete[] mDescription;
}

BOOL CChildFrame::OnCreateClient( LPCREATESTRUCT , CCreateContext* context)
{
    // If the user wants the tab windows maximized then we have to maximize them
    // explicitly every time the child window count goes from 0 to >0. You can't
    // use PreCreateClient because WS_MAXIMIZE style always gets masked off.
    // We can't maximize here because it confuses the framework and causes the
    // system menu to temporarily disappear, so we send ourselves a message to do 
    // it after the child window is fully instantiated.
    if (!ChildCount++ && theApp.getPrefMaxTab()) {
        PostMessage(WM_USER_MAXIMIZE_ME, 0, 0);
    }

    WinCanvas::StartUp();

    mDoc = (CContextFreeDoc*)context->m_pCurrentDoc;
    ASSERT(mDoc->IsKindOf(RUNTIME_CLASS(CContextFreeDoc)));
    if (mSplit.CreateStatic(this, 1, 2)) {
	    // split the frame and insert the text and graphics views
        // CRenderView does not have a CDocument, but MFC doesn't seem to complain
        mSplit.CreateView(0,0,RUNTIME_CLASS(CContextFreeView), CSize(250, 500), context);
        mSplit.CreateView(0,1,RUNTIME_CLASS(CRenderView), CSize(500, 500), context);

        CContextFreeView* docView = (CContextFreeView*)mSplit.GetPane(0,0);
        mRenderView = (CRenderView*)mSplit.GetPane(0,1);

        mRenderView->mFrame = this;
		mRenderView->mCanvas = mCanvas;

	    SetActiveView(docView);
	    RecalcLayout();
        SetMode(mDoc->mEmpty ? New : Idle);
        return TRUE;
    }
    return FALSE;
}

int CChildFrame::OnCreate(LPCREATESTRUCT cs)
{
    if (CMDIChildWnd::OnCreate(cs) == -1)
        return -1;

    if (!mCtrlBar.Create(this, IDD_CONTROL_BAR, CBRS_TOP, IDD_CONTROL_BAR)) {
        TRACE0("Failed to create DlgBar\n");
        return -1;      // Fail to create.
    }

    // We are keeping a list of child windows ourselves because the MDI does not seem
    // to do this for us.
    theApp.mChildList.push_back(this);
    return 0;
}

void CChildFrame::OnClose()
{
    // All hell will break lose if we close the window while the render thread is running.
    // So tell the thread to stop and defer the close until the thread ends.
    if (mThreadRunning) {
        mClose = true;
        StopNow();
    } else {
        CMDIChildWnd::OnClose();
    }
}

void CChildFrame::OnDestroy()
{
    // We are keeping a list of child windows ourselves because the MDI does not seem
    // to do this for us. But now it is time to remove this window.
    theApp.mChildList.remove(this);
    ChildCount--;
    CMDIChildWnd::OnDestroy();
}

void CChildFrame::OnSize(UINT type, int width, int height)
{
    // Calculate the size and position of the output window. This is used to position the window
    // when drawing and to size a canvas when it is created.
    CMDIChildWnd::OnSize(type, width, height);
    mCtrlBar.newSize(width);
}

void CChildFrame::UpdateIcon(int busycount)
{
    if (mBusyCount == 0 && busycount == 1) {
        mTimerID = SetTimer(1, 100, 0);
    }
    if (mBusyCount == 1 && busycount == -1) {
        SetMode(Idle);
        if (mTimerID) {
            KillTimer(mTimerID);
            mTimerID = 0;
        }
    }
    mBusyCount += busycount;

    mCtrlBar.mStatusIcon.Update(mBusyCount);
}

void CChildFrame::SetMode(RenderMode mode)
{
    mRenderMode = mode;
    if (!::IsWindow(mCtrlBar.mRender.GetSafeHwnd()))
        return;
    switch (mRenderMode) {
    case New:
        mCtrlBar.mRender.EnableWindow(FALSE);
        mCtrlBar.mRender.SetWindowText(_T("Render"));
        break;
    case Idle:
        mCtrlBar.mRender.EnableWindow(TRUE);
        mCtrlBar.mRender.SetWindowText(_T("Render"));
        break;
    case Rendering:
        mCtrlBar.mRender.EnableWindow(TRUE);
        mCtrlBar.mRender.SetWindowText(_T("Stop"));
        break;
    case Stopping:
        mCtrlBar.mRender.EnableWindow(TRUE);
        mCtrlBar.mRender.SetWindowText(_T("Stopping"));
        break;
    }
}

LRESULT CChildFrame::OnStatusUpdate(WPARAM stats, LPARAM lParam)
{
    // Receive status info from the render thread
    if (stats) {
        // if a status object was sent then update the status line, icon, and 
        // render progress bar. We are responsible for deleting the stats object
        System::Stats*  s = (System::Stats*)stats;
        bool    show = (bool)lParam;
        noteStats(show, s);
        delete s;
    } else {
        // If no status object was sent then this is either the end of a partial/final
        // render or rendering is done altogether
        mRenderView->Invalidate(false);
        mCtrlBar.mBar.ShowWindow(SW_HIDE);
    }
    return 0;
}

LRESULT CChildFrame::OnMessageUpdate(WPARAM wParam,LPARAM)
{
    // receive a message from the render thread and splat it into the status text window
    // We are responsible for freeing the buffer
    LPTSTR txt = (LPTSTR)wParam;
    alert(txt, false);
    delete[] txt;
    return 0;
}

LRESULT CChildFrame::CFDGError(WPARAM path,LPARAM line)
{
    // Get this message from our system object and bounce it up to the App object.
    // The app object will look in all the windows for the syntax error and highlight
    // it.
    return theApp.CFDGError(path, line);
}

LRESULT CChildFrame::OnMax(WPARAM ,LPARAM)
{
    // Receive a message to do a deferred maximize of the child window.
    MDIMaximize();
    return TRUE;
}

void CChildFrame::noteStats(bool showScaling, System::Stats* s)
{
    TCHAR msg[500];
    TCHAR* end = _T("");
    
    // Create a message for the status text window and send it
    if (s->toDoCount > 0 || !mCanvas) {
        wsprintf(msg, _T("%s%d shapes and %d expansions to do"), 
        showScaling ? _T("rescaling - ") : _T(""), s->shapeCount, s->toDoCount);
    } else {
        if (mTiled && mTiledCanvas) {
            end = mTiledCanvas->isRectangular() ? 
                _T(", tiled rectangular") : _T(", tiled");
        }
        wsprintf(msg, _T("%s%d shapes, %d x %d pixels%s"), 
        showScaling ? _T("rescaling - ") : _T(""), s->shapeCount,
        mCanvas->mWidth, mCanvas->mHeight, end
        );
    }
    
    mCtrlBar.mStatus.SetWindowText(msg);

    // Update the status icon
    //UpdateIcon(true);

    // Update the output progress bar
    bool barVisible = false;
    if (s->inOutput) {
        // Only do the progress bar for output times of significant length, otherwise the
        // progress bar flashes too much
        if (mProgressDelay > 5) {
            barVisible = true;
            mCtrlBar.mBar.SetPos((100 * s->outputDone) / s->outputCount);
        } else {
            mProgressDelay++;
            mCtrlBar.mBar.SetPos(0);
        }
    } else {
        mCtrlBar.mBar.SetPos(0);
        mProgressDelay = 0;
    }
    mCtrlBar.mBar.ShowWindow(barVisible ? SW_SHOW : SW_HIDE);
}

int CChildFrame::GetEncoderClsid(const WCHAR* format, CLSID* pClsid)
{
   UINT  num = 0;          // number of image encoders
   UINT  size = 0;         // size of the image encoder array in bytes

   ImageCodecInfo* pImageCodecInfo = NULL;

   GetImageEncodersSize(&num, &size);
   if(size == 0)
      return -1;  // Failure

   pImageCodecInfo = (ImageCodecInfo*)(malloc(size));
   if(pImageCodecInfo == NULL)
      return -1;  // Failure

   GetImageEncoders(num, size, pImageCodecInfo);

   for(UINT j = 0; j < num; ++j)
   {
      if( wcscmp(pImageCodecInfo[j].MimeType, format) == 0 )
      {
         *pClsid = pImageCodecInfo[j].Clsid;
         free(pImageCodecInfo);
         return j;  // Success
      }    
   }

   free(pImageCodecInfo);
   return -1;  // Failure
}

static LPCTSTR errorMsg[] = {
    _T("Ok"),
    _T("Generic Error"),
    _T("Invalid Parameter"),
    _T("Out Of Memory"),
    _T("Object Busy"),
    _T("Insufficient Buffer"),
    _T("Not Implemented"),
    _T("Win32 Error"),
    _T("Wrong State"),
    _T("Aborted"),
    _T("File Not Found"),
    _T("Value Overflow"),
    _T("Access Denied"),
    _T("Unknown Image Format"),
    _T("Font Family Not Found"),
    _T("Font Style Not Found"),
    _T("Not TrueType Font"),
    _T("Unsupported Gdiplus Version"),
    _T("Gdiplus Not Initialized"),
    _T("Property Not Found"),
    _T("Property Not Supported"),
    _T("Profile Not Found")
};

static char* EmbedCFDG(CContextFreeView* view, Bitmap* bm)
{
    PropertyItem pi;
    pi.id = PropertyTagImageDescription;
    pi.type = PropertyTagTypeASCII;

    if (view) {
        // Get the CFDG file and convert it to ASCII with Unix line endings
        int len = view->GetWindowTextLength();
        TCHAR* wtxt = new TCHAR[len + 1];
        char* ctxt = new char[len*4 + 1];
        TCHAR* wtxt_start = wtxt;
        char* ctxt_start = ctxt;
        view->GetWindowText(wtxt, len + 1);
        for (; *wtxt; wtxt++) {
            if (*wtxt == '\t') {
                *ctxt++ = ' ';
                *ctxt++ = ' ';
                *ctxt++ = ' ';
                *ctxt++ = ' ';
            } 
            else if (*wtxt != _T('\r')) {
                *ctxt++ = (char)*wtxt;
            }
        }
        *ctxt = '\0';
        delete[] wtxt_start;

        pi.length = strlen(ctxt_start) + 1;
        pi.value = (VOID*)ctxt_start;

        if (bm) {
            bm->SetPropertyItem(&pi);
            delete[] ctxt_start;
        } else {
            return ctxt_start;
        }
    } else {
        pi.length = strlen("Context Free generated image") + 1;
        pi.value = (VOID*)"Context Free generated image";
        if (bm) {
            bm->SetPropertyItem(&pi);
        } else {
            char* ctxt = new char[pi.length];
            strcpy(ctxt, (char*)pi.value);
            return ctxt;
        }
    }

    return 0;
}

void CChildFrame::SaveToSVG(LPCTSTR path)
{
    alert(_T("Saving SVG image."), false);

#ifdef _UNICODE
    char cpath[MAX_PATH + 1];
    ::wcstombs(cpath, path, MAX_PATH + 1);
#else
    const char* cpath = path;
#endif

    delete[] mDescription;
    if (theApp.getPrefEmbedCFDG())
        mDescription = EmbedCFDG(mDoc->getView(), 0);
    else
        mDescription = EmbedCFDG(0, 0);

    mSVGCanvas = new SVGCanvas(cpath, mWidth, mHeight, theApp.getPrefCrop(), mDescription);

    RunRenderThread();
}

void CChildFrame::OnSaveMovie()
{
    if (!mCanvas || !mRenderer) {
        alert(_T("Nothing to save."));
        return;
    }

    LPTSTR filebuf = theApp.mSaveMovieDialog->m_ofn.lpstrFile;    // this is a buffer of MAX_PATH length
    GetWindowText(filebuf, MAX_PATH);
    PathRemoveExtension(filebuf);
    if (theApp.getPrefAppendVariation()) {
        TCHAR var[64];
        Variation::toString(mVariation, var, true);
        _tcscat(filebuf, _T("-"));
        _tcscat(filebuf, var);
    } 

    // We have to create this early so that it can catch Movie Settings button events
    if (!qtCanvas::systemInit()) {
        alert(_T("QuickTime is not installed or can't be initialized."));
        return;
    }

    mAnimationCanvas = new qtCanvas(mWidth, mHeight);
    theApp.mSaveMovieDialog->mQTCanvas = mAnimationCanvas;

    if (theApp.mSaveMovieDialog->DoModal() == IDCANCEL) {
        //DWORD ret = GetLastError();
        return;
    }

    CString path = theApp.mSaveMovieDialog->GetPathName();

    alert(_T("Saving QuickTime movie."), false);

    if (theApp.getPrefLengthUnits() == CFileDialogEx::Seconds)
        mAnimateFrameCount = mAnimationCanvas->convertToFrames((float)theApp.getPrefLength());
    else
        mAnimateFrameCount = theApp.getPrefLength();

    CFStringRef cfs;
#ifdef _UNICODE
    cfs = CFStringCreateWithCharacters(0, (const UniChar*)((const TCHAR*)path), _tcslen(path));
#else
    cfs = CFStringCreateWithCString(0, path, kCFStringEncodingWindowsLatin1);
#endif

    mAnimationCanvas->prepareMovie(cfs);

    RunRenderThread();
}

void CChildFrame::OnSaveImage()
{
    if (!mCanvas) {
        alert(_T("Nothing to save."));
        return;
    }

    LPTSTR filebuf = theApp.mSaveDialog->m_ofn.lpstrFile;    // this is a buffer of MAX_PATH length
    GetWindowText(filebuf, MAX_PATH);
    PathRemoveExtension(filebuf);
    if (theApp.getPrefAppendVariation()) {
        TCHAR var[64];
        Variation::toString(mVariation, var, true);
        _tcscat(filebuf, _T("-"));
        _tcscat(filebuf, var);
    } 

    theApp.mSaveDialog->mTiled = mTiled;
    if (mTiledCanvas) 
        theApp.mSaveDialog->mIsRect = mTiledCanvas->isRectangular();

    if (theApp.mSaveDialog->DoModal() == IDCANCEL) {
        //DWORD ret = CommDlgExtendedError();
        return;
    }

    CString path = theApp.mSaveDialog->GetPathName();

    switch(theApp.mSaveDialog->m_ofn.nFilterIndex) {
    case 1:
        SaveToPNGorJPEG(path, false, theApp.mSaveDialog->mTileType);
        break;
    case 2:
        SaveToSVG(path);
        break;
    case 3:
        SaveToPNGorJPEG(path, true, theApp.mSaveDialog->mTileType);
        break;
    default:
        alert(_T("Unknown file type. Nothing saved."));
        break;
    }
}
Status CChildFrame::SaveToPNGorJPEG(LPCTSTR path, bool jpeg, bool rect)
{ return SaveToPNGorJPEG(0, path, jpeg, rect); }

Status CChildFrame::SaveToPNGorJPEG(IStream* pIStream, bool jpeg, bool rect)
{ return SaveToPNGorJPEG(pIStream, 0, jpeg, rect); }

Status CChildFrame::SaveToPNGorJPEG(IStream* pIStream, LPCTSTR path, bool jpeg, bool rect)
{
    static CLSID encClsid;

    alert(_T("Saving image."), false);

#ifdef _UNICODE
    const WCHAR* wpath = path;
#else
    WCHAR wpath[MAX_PATH];
    ::mbstowcs(wpath, path, MAX_PATH);
#endif

    if (GetEncoderClsid(jpeg ? L"image/jpeg" : L"image/png", &encClsid) == -1) {
        alert(_T("Image encoder missing from GDI+!"));
        return UnknownImageFormat;
    } 
	mOwnCanvas.Lock();

    if (jpeg && mCanvas->mBackground.GetAlpha() != 255) {
        alert(_T("JPEGs require an opaque background"));
        return Aborted;
    }

    Bitmap* grayBM = mCanvas->MakeBitmap(theApp.getPrefCrop());
    Bitmap* saveBM = grayBM;
    agg::point_i factor;
    if (mTiled && rect && mTiledCanvas && mTiledCanvas->isRectangular(&factor)) {
        int srcWidth = grayBM->GetWidth();
        int srcHeight = grayBM->GetHeight();
#ifdef _DEBUG
#undef new
#endif
        PixelFormat fmt = (grayBM->GetPixelFormat() & PixelFormatAlpha) ? 
            PixelFormat32bppPARGB : PixelFormat24bppRGB;

        saveBM = new Bitmap(srcWidth * factor.x, srcHeight * factor.y, fmt);
#ifdef _DEBUG
#define new DEBUG_NEW
#endif
        Graphics g(saveBM);

        tileList points = 
            mTiledCanvas->getTesselation(saveBM->GetWidth(), saveBM->GetHeight(),
                                         0, 0, true);
        
        for (tileList::iterator pt = points.begin(); 
             pt != points.end(); pt++) {
            Gdiplus::Rect destRect(pt->x, pt->y, srcWidth, srcHeight);

            g.DrawImage(grayBM, destRect, 0, 0, srcWidth, srcHeight,
                UnitPixel, NULL, NULL, NULL);
        }

        delete grayBM;
    }

    delete[] mDescription;
    if (theApp.getPrefEmbedCFDG())
        mDescription = EmbedCFDG(mDoc->getView(), saveBM);
    else
        mDescription = EmbedCFDG(0, saveBM);

    EncoderParameters encoderParameters;
    ULONG             quality;
        
    if (jpeg) {
        encoderParameters.Count = 1;
        encoderParameters.Parameter[0].Guid = EncoderQuality;
        encoderParameters.Parameter[0].Type = EncoderParameterValueTypeLong;
        encoderParameters.Parameter[0].NumberOfValues = 1;
        quality = theApp.getPrefJPEGqual();
        encoderParameters.Parameter[0].Value = &quality;
    } else {
        encoderParameters.Count = 0;
    }

    Status s;
    if (pIStream) {
        s = saveBM->Save(pIStream, &encClsid, &encoderParameters);
    } else {
        s = saveBM->Save(wpath, &encClsid, &encoderParameters);
    }
    delete saveBM;
    mOwnCanvas.Unlock();
    mRenderView->Invalidate();    // must invalidate after unlocking

	if (s != Ok) {
        TCHAR buf[128];
        wsprintf(buf, _T("Error saving file %s [%s] (really useful I know)."), path, errorMsg[s]);
        alert(buf);
    } else {
        alert(_T("Image save complete."), false);
    }
    return s;
}

void CChildFrame::OnUpload()
{
    if (!mCanvas) {
        alert(_T("You must render the cfdg file first."));
        return;
    }

    const CString name = mDoc->docName();
    TCHAR fbuf[MAX_PATH];
    _tcsnccpy(fbuf, name, MAX_PATH);


    CUploadWiz uwiz(_T("Upload to CFDG Gallery"));

    PathRemoveExtension(fbuf);
    TCHAR* fileName = PathFindFileName(fbuf);
    uwiz.mCFDGFileName = fileName;
    *fileName = (TCHAR)::_totupper(*fileName);
    uwiz.mTitle = fileName;
    uwiz.mVariation = mVariation;
    uwiz.mTiled = mTiled;
    uwiz.mImageCompression = mCanvas->colorCount256() ? 1 : 0;
    uwiz.mCFDG = mDoc->GetContents();
    uwiz.mFrame = this;
    uwiz.DoModal();
}

static UINT RenderThreadProc(LPVOID frame)
{
    CChildFrame* f = (CChildFrame*)frame; 
    f->Render();
    return 0;
}

void CChildFrame::OnRenderButton()
{
    // Event handler for the Render/Stop button

    // Don't bother rendering an empty document
    CContextFreeDoc* doc = (CContextFreeDoc*)GetActiveDocument();
    if (doc->mEmpty)
        return;

    // This button is a start and stop button depending on whether a render
    // is already in progress
    switch (mRenderMode) {
    case New:
    case Idle:
        OnRender();
        break;
    case Rendering:
        OnStop();
        break;
    case Stopping:
        StopNow();
        break;
    }
}

void CChildFrame::OnRenderSize()
{
    mLastRenderWasToSize = true;

    // Perform render-to-size or defer until render thread ends
    if (mThreadRunning) {
        mRenderSizeAgain = true;
        StopNow();
    } else {
        mRenderSizeAgain = false;
        if (theApp.mRenderSize->DoModal() == IDOK) {
            RenderMe(theApp.getPrefWidth(), theApp.getPrefHeight(), 
                theApp.getPrefNoDisplay(),
                theApp.getPrefMinSize());
        }
    }
}

void CChildFrame::OnRender()
{
    mLastRenderWasToSize = false;

    // Perform render or defer until render thread ends
    if (mThreadRunning) {
        mRenderAgain = true;
        StopNow();
    } else {
        mRenderAgain = false;
        RenderMe();
    }
}

void CChildFrame::OnRenderRepeat()
{
    if (mThreadRunning) {
        mRepeatRenderAgain = true;
        StopNow();
    } else {
        mRepeatRenderAgain = false;
        if (mLastRenderWasToSize) {
            RenderMe(theApp.getPrefWidth(), theApp.getPrefHeight(), 
                theApp.getPrefNoDisplay(),
                theApp.getPrefMinSize());
        } else {
            RenderMe();
        }
    }
}

void CChildFrame::StopNow()
{
    if (mThreadRunning) 
        mRenderer->requestStop();   // Guaranteed to be non-null if mThreadRunning true
}

void CChildFrame::OnStop()
{
    // Ask render thread to stop at the next good point and update Render/Stop button
    if (mThreadRunning) {
        mRenderer->requestFinishUp();   // Guaranteed to be non-null if mThreadRunning true
        SetMode(Stopping);
    }
}

void CChildFrame::RenderMe(int width, int height, bool nodisplay, 
                           double minsize)
{
    delete mCFDG;
    delete mRenderer;
    mRenderer = 0;
    delete mTiledCanvas;
    mTiledCanvas = 0;
    const CString name = mDoc->docName();

#ifdef _UNICODE
    char fbuf[MAX_PATH + 1];
    ::wcstombs(fbuf, name, MAX_PATH);
#else
    const char* fbuf = name;
#endif

    mCFDG = CFDG::ParseFile(fbuf, &mSystem);
    if (!mCFDG) {
        MessageBeep(MB_ICONASTERISK);
        return;                               // must be a parse error
    }

    if (mDoc->mIncrementVariation && !width && !height) {
        mVariation = mVariation += 1;
        if (mVariation > Variation::recommendedMax())
            mVariation = Variation::recommendedMin();
        OnRandomSpin(mVariation);
    }

    mMinSize = minsize;

    if (width && height) {
        mWidth = width;
        mHeight = height;
    } else {
        mWidth = mRenderView->mWidth;
        mHeight = mRenderView->mHeight;
    }

    mTiled = mCFDG->isTiled(&mTile_tr); 
    
    // Convert mBorderSlider from integer interval [0,100] to real interval [-1,2]
    double border = (double)theApp.getPrefBorderWidth() / 33.333 - 1;
        
    mRenderer = mCFDG->renderer(mWidth, mHeight, (float)mMinSize, mVariation, border);
    mWidth = mRenderer->m_width;
    mHeight = mRenderer->m_height;

    SetMode(Rendering);
    mOwnCanvas.Lock();                        // Create a new canvas in case the
    delete mCanvas;                           // window size changed
    mCanvas = 0;

    mUsesAlpha = mCFDG->backgroundColor().a < 1.0;
    mPixfmt = aggCanvas::SuggestPixelFormat(mCFDG);

    mPartialDraw = theApp.getPrefProgressive() && !(width && height);
    if (mPartialDraw) 
        setupCanvas();

    mRenderView->mCanvas = mCanvas;
    mRenderView->mDisplay = !nodisplay;
	mRenderView->mNotRendered = false;

    if (!mCanvas || mCanvas->mWidth) {
        mOwnCanvas.Unlock();
        if (!mCanvas)
            mRenderView->Invalidate(FALSE);
        RunRenderThread();
    } else {
       	mRenderView->mNotRendered = true;
        SetMode(Idle);
        delete mCanvas;
        mCanvas = 0;
        mOwnCanvas.Unlock();
        mRenderView->Invalidate(FALSE);
    }
}

void CChildFrame::RunRenderThread()
{
    UpdateIcon(1);
    mRenderThread = AfxBeginThread(RenderThreadProc, (LPVOID)this); // kick off render thread
    mRenderThread->m_bAutoDelete = TRUE;
}

void CChildFrame::Render()
{
    mThreadRunning = true;

    if (mAnimationCanvas) {
        tiledCanvas* tile = 0;
        if (mTiled) {
            tile = new tiledCanvas(mAnimationCanvas, mTile_tr);
            tile->scale(mScale);
        }
        mRenderer->animate(mTiled ? (Canvas*)tile : (Canvas*)mAnimationCanvas, mAnimateFrameCount, theApp.getPrefZoom());
        
        delete tile;
        delete mAnimationCanvas;
        mAnimationCanvas = 0;
        
        mSystem.message("Movie save complete.");
    } 
    else if (mSVGCanvas) {
        mRenderer->draw(mSVGCanvas);
        delete mSVGCanvas;
        mSVGCanvas = 0;
        
        mSystem.message("SVG image save complete.");
    }
    else {
        mRenderView->mSizeChanged |= mTiled;
        mScale = mRenderer->run(mTiled ? (Canvas*)mTiledCanvas : (Canvas*)mCanvas, mPartialDraw);
        if (!mCanvas) {
            setupCanvas();
            if (mTiledCanvas) mTiledCanvas->scale(mScale);
            mOwnCanvas.Lock();
            mRenderView->mCanvas = mCanvas;
            mOwnCanvas.Unlock();
            mRenderer->draw(mTiled ? (Canvas*)mTiledCanvas : (Canvas*)mCanvas);
        }
        mCanvas->mDone = mCanvas->mChanged = true;
    }

    // This message tells the render view that we are done and that the canvas area and status
    // icon need to be updated
    ::PostMessage(m_hWnd, WM_USER_RENDER_OVER, 0, NULL);
}

LRESULT CChildFrame::OnRenderOver(WPARAM , LPARAM)
{
    // Handler for the WM_USER_RENDER_OVER message
    // If a WM_CLOSE message was received while the thread was running then the close was
    // deferred until now.
    if (mClose) {
        CMDIChildWnd::OnClose();
        return 0;
    }

    // Perform post-render clean-up
    UpdateIcon(-1);
    mThreadRunning = false;
    if (mDoc->mIncrementVariation) {
        mVariation = mVariation += 1;
        if (mVariation > Variation::recommendedMax())
            mVariation = Variation::recommendedMin();
    }
    OnRandomSpin(mVariation);
    mDoc->mIncrementVariation = true;
    mRenderView->mSizeChanged |= mTiled;
    mRenderView->Invalidate(FALSE);

    // Perform re-render operations that happened during this previous render
    // and were deferred.
    if (mRenderAgain)
        OnRender();
    else if (mRenderSizeAgain)
        OnRenderSize();
    else if (mRepeatRenderAgain)
        OnRenderRepeat();
    else if (!mRenderView->mDisplay) {
        // We just finished a big Render-to-Size
        alert(_T("Done!"), false);
        MessageBeep(MB_OK);
    }
    return 0;
}

void CChildFrame::setupCanvas()
{
    mCanvas = new WinCanvas(this, mPixfmt, mWidth, mHeight, 
        mCFDG->backgroundColor());
    if (mTiled)
        mTiledCanvas = new tiledCanvas(mCanvas, mTile_tr);
}

void CChildFrame::OnTimer(UINT nIDEvent)
{
    if (nIDEvent == 1 && mThreadRunning && mRenderer) {
        // turn this update timer tick into an update request into the render thread
        // mCFDG is only created/deleted by the UI thread so this is safe
        mRenderer->requestUpdate();
        UpdateIcon(0);
    }
    
    CMDIChildWnd::OnTimer(nIDEvent);
}


void CChildFrame::OnRandomSpin(int v)
{
    mVariation = v;
    mDoc->mIncrementVariation = false;
    
    TCHAR code[Variation::maxStringLength + 1];
    Variation::toString(v, code, false);

    mCtrlBar.mRandomText.SetWindowText(code);
    mCtrlBar.mRandomSpin.SetPos(mVariation);
}

void CChildFrame::OnRandomText()
// Validate and process changes to the variation CEdit
{
    TCHAR code[Variation::maxStringLength];
    mCtrlBar.mRandomText.GetWindowText(code, Variation::maxStringLength);

    // If new Cedit contents do not correspond to a valid variation then
    // restore previous contents and beep
    int newVariation = Variation::fromString(code);
    if (newVariation == -1) {
        OnRandomSpin(mVariation);
        MessageBeep(MB_OK);
        return;
    } 
    
    // Otherwise accept new variation and suppress automatic variation increment
    // for the next render
    mVariation = newVariation;
    mDoc->mIncrementVariation = false;

    mCtrlBar.mRandomSpin.SetPos(mVariation);
}

/////////////////////////////////////////////////////////////////////////////
// CChildFrame diagnostics

#ifdef _DEBUG
void CChildFrame::AssertValid() const
{
	CMDIChildWnd::AssertValid();
}

void CChildFrame::Dump(CDumpContext& dc) const
{
	CMDIChildWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CChildFrame message handlers
