#ifndef INCLUDE_CRENDERVIEW_H
#define INCLUDE_CRENDERVIEW_H

#include "stdafx.h"

class WinCanvas;
class CChildFrame;

namespace Gdiplus {
	class Bitmap;
};

class CRenderView : public CView
{
    DECLARE_DYNCREATE(CRenderView)
public:
    CChildFrame*     mFrame;
    WinCanvas*	  mCanvas;
    bool          mDisplay;
	bool		  mNotRendered;
    int           mWidth;
    int           mHeight;
    int           mActualWidth;
    int           mActualHeight;
    afx_msg void OnSize(UINT type, int width, int height);
    afx_msg void OnContextMenu(CWnd* wnd, CPoint pos);
    afx_msg BOOL OnEraseBkgnd(CDC*);
    bool          mSizeChanged;
protected:
    Gdiplus::Bitmap*       mBackingStore;
    CRenderView();
    void SplatBitmap(Gdiplus::Bitmap* srcBM, int srcWidth, int srcHeight, 
        Gdiplus::Graphics& destGfx, Gdiplus::Color back, int destWidth, int destHeight, 
        Gdiplus::InterpolationMode stretchMode);
public: 
    ~CRenderView();
    CRenderView(const CRenderView&);				// declare but do not implement
    CRenderView& operator=(const CRenderView&);		// declare but do not implement
    
    void OnDraw(CDC*);

    DECLARE_MESSAGE_MAP()
};

#endif // INCLUDE_CRENDERVIEW_H