// CFDGCtrlBar.cpp : implementation file
//

#include "stdafx.h"
#include "ContextFree.h"
#include "CFDGCtrlBar.h"
#include "ChildFrm.h"
#include "variation.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "StatusIcon.h"

/////////////////////////////////////////////////////////////////////////////
// CCFDGCtrlBar dialog


CCFDGCtrlBar::CCFDGCtrlBar()
{
    mInited = false;
    //{{AFX_DATA_INIT(CCFDGCtrlBar)
	//}}AFX_DATA_INIT
}


void CCFDGCtrlBar::DoDataExchange(CDataExchange* pDX)
{
	CDialogBar::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCFDGCtrlBar)
	DDX_Control(pDX, IDC_STATUS_BAR, mBar);
	DDX_Control(pDX, IDC_SAVE_IMAGE, mSave);
	DDX_Control(pDX, IDC_RENDER, mRender);
	DDX_Control(pDX, IDC_RANDOM_SPIN, mRandomSpin);
	DDX_Control(pDX, IDC_MESSAGE_TEXT, mMessage);
	DDX_Control(pDX, IDC_RANDOM, mRandomText);
	DDX_Control(pDX, IDC_STATUS_ICON, mStatusIcon);
	DDX_Control(pDX, IDC_STATUS_TEXT, mStatus);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCFDGCtrlBar, CDialogBar)
	//{{AFX_MSG_MAP(CCFDGCtrlBar)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
    ON_MESSAGE(WM_INITDIALOG, OnInitDialog )
    ON_WM_HSCROLL()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCFDGCtrlBar message handlers
LONG CCFDGCtrlBar::OnInitDialog ( UINT wParam, LONG lParam)
{
    BOOL bRet = HandleInitDialog(wParam, lParam);
    
    if (!UpdateData(FALSE))
    {
        TRACE0("Warning: UpdateData failed during dialog init.\n");
    }
        
    // initialize the controls
    mBar.SetRange(0, 100);

    int v = Variation::random();
    mRandomSpin.SetRange32(0, Variation::recommendedMax());
    mRandomSpin.SetPos(v);
    mRandomText.SetLimitText(3);
    mFrame->OnRandomSpin(v);

    mFrame->UpdateIcon(0);

    mInited = true;

    if (theApp.getPrefRenderOnOpen())
        mRender.PostMessage(BM_CLICK, 0, 0);

    return bRet;
}

void CCFDGCtrlBar::OnHScroll(UINT part, UINT value, CScrollBar* )
{
    if (part == SB_THUMBPOSITION || part == SB_THUMBTRACK) {
        mFrame->OnRandomSpin(value);

    }
}

void CCFDGCtrlBar::newSize(int width)
{
    if (!mInited) return;       // ignore WM_SIZE before Init

    // take all the area to the left of mBar and split it between mMessage and mStatus
    WINDOWPLACEMENT wp;
    mMessage.GetWindowPlacement(&wp);
    int newWidth = (width - wp.rcNormalPosition.left) / 2 - 6;
    int height = wp.rcNormalPosition.bottom - wp.rcNormalPosition.top;
    mMessage.MoveWindow(wp.rcNormalPosition.left, wp.rcNormalPosition.top, 
        newWidth, height, TRUE);
    mStatus.MoveWindow(wp.rcNormalPosition.left + newWidth + 6, wp.rcNormalPosition.top, 
        newWidth, height, TRUE);
}
