#ifndef INCLUDE_POSIX_SYSTEM
#define INCLUDE_POSIX_SYSTEM

#include "cfdg.h"

class PosixSystem : public System
{
    public:
        virtual void message(const char* fmt, ...);
        virtual void syntaxError(const std::string&, int);
        
        virtual std::istream* openFileForRead(const std::string& path);
        virtual std::istream* tempFileForRead(const std::string& path);
        virtual std::ostream* tempFileForWrite(std::string& prefixInNameOut);
            // caller must delete returned streams when done
            
        virtual std::string relativeFilePath(
            const std::string& base, const std::string& rel);

		virtual void stats(const Stats&);
};

#endif // INCLUDE_POSIX_SYSTEM
