#include "cfdg.h"
#include "aggCanvas.h"

class pngCanvas : public aggCanvas
{
public:
  pngCanvas(const char* outfilename, int width, int height, 
            aggCanvas::PixelFormat pixfmt, bool crop, int frameCount);
  ~pngCanvas();

  void output(const char * outfilename, int frame = -1);

  void start(bool clear, const agg::rgba& bk, int width, int height);
  void end();

private:
  unsigned char* mData;

  const char* mOutputFileName;
  int mStride;
  int mFrameCount;
  int mCurrentFrame;

  aggCanvas::PixelFormat mPixelFormat;

  bool mCrop;
};

