//
//  VariationFormatter.mm
//  Context Free
//
//  Created by Mark Lentczner on 4/23/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "VariationFormatter.h"
#include "variation.h"

@implementation VariationFormatter

+ (int)minVariation     { return Variation::recommendedMin(); }
+ (int)maxVariation     { return Variation::recommendedMax(); }
+ (int)randomVariation  { return Variation::random(); }

+ (NSString *)stringForVariation:(int)v lowerCase:(BOOL)lowerCase
{
    char code[Variation::maxStringLength];
    Variation::toString(v, code, lowerCase);
    return [NSString stringWithCString: code];
}

- (NSString *)stringForObjectValue:(id)obj
{
    int v = 0;
    if ([obj respondsToSelector: @selector(intValue)]) {
        v = [obj intValue];
    }
    return [VariationFormatter stringForVariation: v lowerCase: NO];
}

- (BOOL)getObjectValue:(id *)obj forString:(NSString *)string
    errorDescription:(NSString **)error
{
    unsigned int l = [string length];
    if (l > 3) {
        if (error)
            *error = NSLocalizedString(@"No more than three letters", @"");
        return NO;
    }
    
    for (unsigned int i = 0; i < l; ++i) {
        unichar c = [string characterAtIndex: i];

        if (('A' <= c && c <= 'Z') ||  ('a' <= c && c <= 'z'))
            continue;
            
        if (error)
            *error = NSLocalizedString(@"Only accepts letters", @"");
        return NO;
    }
    
    int v = Variation::fromString([string cString]);
    
    if (obj)
        *obj = [NSNumber numberWithInt: v];
    return YES;
}


- (BOOL)isPartialStringValid:(NSString **)partialStringPtr
    proposedSelectedRange:(NSRangePointer)proposedSelRangePtr
    originalString:(NSString *)origString
    originalSelectedRange:(NSRange)origSelRange
    errorDescription:(NSString **)error
{
    return [self getObjectValue: nil forString: *partialStringPtr
                errorDescription: error];
}

@end
