//
//  GalleryUploader.h
//  Context Free
//
//  Created by Mark Lentczner on 1/12/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class CFDGDocument;
@class GView;

@interface GalleryUploader : NSWindowController {
	CFDGDocument*		mDocument;
	GView*				mView;
    int                 mStatus;

	IBOutlet NSView*	mContentView;

    IBOutlet NSView*	mFormView;
		IBOutlet NSTextField*	mUserNameField;
		IBOutlet NSTextField*	mPasswordField;
		IBOutlet NSTextField*	mTitleField;
		IBOutlet NSTextView*	mNotesView;
		IBOutlet NSTextField*	mFileField;
		IBOutlet NSTextField*	mVariationField;
		IBOutlet NSMatrix*		mCompressionMatrix;
	
	IBOutlet NSView*	mProgressView;
		IBOutlet NSProgressIndicator*	mProgressBar;
	
	IBOutlet NSView*	mDoneView;
		IBOutlet NSTextView*	mMessage;
		IBOutlet NSButton*      mRetryButton;
	
	NSURLConnection*	mConnection;
	NSMutableData*		mResponseBody;
}

- (id)initForDocument:(CFDGDocument*)document andView:(GView*)view;

- (IBAction)show:(id)sender;

- (IBAction)goToCreateAccount:(id)sender;
- (IBAction)upload:(id)sender;

- (IBAction)cancel:(id)sender;
- (IBAction)retry:(id)sender;

@end
