//
//  CFDGDocument.h
//  Context Free
//
//  Created by Mark Lentczner on 4/18/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GalleryUploader;
@class GView;

class CFDG;
class System;

@interface CFDGDocument : NSDocument {
    System*                 mSystem;
    NSData*                 mContent;
    
    IBOutlet NSTextView*    mEditor;
    IBOutlet NSTextField*   mStatus;
    
    IBOutlet GView*         mGView;
    IBOutlet NSPanel*       mHiresSheet;
    
	GalleryUploader*		mUploader;
	
    NSString*               mDisplayName;
}

- (IBAction) startRender:(id)sender;
- (IBAction) repeatRender:(id)sender;
- (IBAction) finishRender:(id)sender;
- (IBAction) stopRender:(id)sender;
- (IBAction) saveImage:(id)sender;
- (IBAction) saveAsSVG:(id)sender;
- (IBAction) saveAsMovie:(id)sender;
- (IBAction) uploadToGallery:(id)sender;

- (BOOL)validateMenuItem:(NSMenuItem *)anItem;

- (IBAction) showHiresRenderSheet:(id)sender;
- (IBAction) startHiresRender:(id)sender;
- (IBAction) cancelHiresRender:(id)sender;

- (CFDG*)buildEngine;

- (void)showContent;
- (NSData*)getContent;

- (void)noteStatus:(NSString*)s;
- (void)noteStats:(NSValue*)v;
- (void)highlightLine:(int)line;
- (void)readFromExample:(NSString*)path;

+ (NSString*)documentType;

@end
