#ifndef INCLUDED_VARIATION
#define INCLUDED_VARIATION

#ifdef VC6
typedef unsigned short WinTcharType;
#else
typedef wchar_t WinTcharType;
#endif

class Variation {
  public:
    static int  fromString(const char* str);
    static void toString(int var, char* str, bool lowerCase);
    static int  fromString(const WinTcharType* str);
    static void toString(int var, WinTcharType* str, bool lowerCase);

    enum Constants { maxStringLength = 9 }; // including null terminator

    static int recommendedMin();
    static int recommendedMax(int letters = 3);
      // if giving the user an up/down control, cycle between these inclusive

    static int random(int letters = 3);
      // return a random variation, in the recommended range
};

#endif // INCLUDED_VARIATION


