/*
 *  tiledCanvas.h
 *  Context Free
 *
 *  Created by John Horigan on 4/11/06.
 *  Copyright 2006 John Horigan. All rights reserved.
 *
 */

#ifndef INCLUDE_TILEDCANVAS_H
#define INCLUDE_TILEDCANVAS_H

#include "agg_trans_affine.h"
#include "agg_color_rgba.h"
#include "cfdg.h"
#include <vector>

typedef std::vector<agg::point_i> tileList;

class tiledCanvas : public Canvas {
public:
	void start(bool clear, const agg::rgba& bk, int width, int height);
	void end();
	
	void circle(RGBA8 c, agg::trans_affine tr);
	void square(RGBA8 c, agg::trans_affine tr);
	void triangle(RGBA8 c, agg::trans_affine tr);
	
	tiledCanvas(Canvas* tile, const agg::trans_affine& tr); 
    
    void scale(double scaleFactor);
    
    tileList getTesselation(int width, int height, int x, int y, bool flipY = false);
    bool isRectangular(agg::point_i* factor = 0);
    
private:
	Canvas* mTile;
	bool tileTransform(agg::trans_affine& tr);
	agg::trans_affine mTr[9];
	agg::trans_affine mOffset;
    agg::trans_affine mInvert;
};

#endif  // INCLUDE_TILEDCANVAS_H
