/*
 *  tempfile.cpp
 *  Context Free
 *
 *  Created by Mark Lentczner on 2006-02-16.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#include "tempfile.h"

#include <stdio.h>
#include <stdlib.h>
#ifndef WIN32
#include <unistd.h>
#endif

#include <iostream>

using namespace std;


ref_ptr<TempFile>
TempFile::build(System* system, const char* prefix, const char* type, int num)
{
    return Countable::build(new TempFile(system, prefix, type, num));
}


std::ostream*
TempFile::forWrite()
{
    if (mWritten) {
        cerr << "TempFile::forWrite already wrote to " << mPath << endl;
    }
    mWritten = true;
    mSystem->message("Writing %s temp file %d", mType.c_str(), mNum);
    return mSystem->tempFileForWrite(mPath);
}

std::istream*
TempFile::forRead()
{
    if (!mWritten) {
        cerr << "TempFile::forRead temp file never written, " << mPath << endl;
    }
    mSystem->message("Reading %s temp file %d", mType.c_str(), mNum);
    return mSystem->tempFileForRead(mPath);
}

TempFile::TempFile(System* system, const char* prefix, const char* type, int num)
    : mSystem(system), mPath(prefix), mType(type), mNum(num), mWritten(false)
    { }

TempFile::~TempFile()
{
    if (mWritten) {
        mSystem->message("Deleting %s temp file %d", mType.c_str(), mNum);
        unlink(mPath.c_str());
    }
}

