/*
 *  shapeSTL.h
 *  Context Free
 *
 *  Created by Mark Lentczner on 3/17/06.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef INCLUDE_SHAPESTL_H
#define INCLUDE_SHAPESTL_H

#ifdef _WIN32
#pragma warning( disable : 4786 )
#endif

#include <deque>
#include <functional>
#include <iostream>
#include <iterator>
#include <map>
#include <vector>

#include "cfdg.h"
#include "shape.h"
#include "tempfile.h"

class ShapeOp
{
public:
    ShapeOp() { };
	virtual ~ShapeOp();
    
    virtual void apply(const FinishedShape&) = 0;


    class iterator
    {
    public:
        iterator(const iterator& i) : mOp(i.mOp) { }
        
        iterator& operator++()      { return *this; }
        iterator& operator++(int)   { return *this; }
        iterator& operator*()       { return *this; }
        
        iterator& operator=(const FinishedShape& s)
			{ mOp.apply(s); return *this; }
    
    private:
        friend class ShapeOp;
        
        iterator(ShapeOp& op) : mOp(op) { }
        
        void operator=(const iterator&);	// not defined: can't be assigned
        
		ShapeOp& mOp;
	};
    
    iterator outputIterator() { return iterator(*this); }


	class function : public std::unary_function<const FinishedShape&, void>
	{
    public:
        function(const function& f) : mOp(f.mOp) { }
		
        void operator()(const FinishedShape& s) const
			{ mOp.apply(s); }
			
    private:
        friend class ShapeOp;
        
        function(ShapeOp& op) : mOp(op) { }
        
        void operator=(const function&);	// not defined: can't be assigned
        
        ShapeOp& mOp;
	};
	
	function outputFunction() { return function(*this); }


private:		
	ShapeOp(const ShapeOp&);
	ShapeOp& operator=(const ShapeOp&);
		// not implemented, not copyable
};


class OutputMerge
{
public:
    OutputMerge(System& system) : mSystem(system) { }
    ~OutputMerge();
    
    typedef std::deque<FinishedShape>   ShapeSource;
    typedef ShapeSource::iterator		ShapeIter;
    
    void addShapes(ShapeIter begin, ShapeIter end);

    
	typedef std::unary_function<ref_ptr<TempFile>, void > TempFileAdderBase;
    class TempFileAdder: public TempFileAdderBase
    {
    public:
        void operator()(ref_ptr<TempFile>& t) { mOM.addTempFile(t); }
    private:
        TempFileAdder(OutputMerge& om) : mOM(om) { }
        TempFileAdder& operator=(const TempFileAdder&) { return *this; }
        OutputMerge& mOM;
        friend class OutputMerge;
    };
    
    TempFileAdder tempFileAdder() { return TempFileAdder(*this); }
    
    void addTempFile(ref_ptr<TempFile>);


    template < typename O >
    void merge(O output)
    {
        while (!mSieve.empty()) {
            Sieve::iterator nextShape = mSieve.begin();
        
            *output++ = nextShape->first;
            int i = nextShape->second;
        
            mSieve.erase(nextShape);
            insertNext(i);
        }
    }
    
    
private:
    typedef std::istream_iterator<FinishedShape>	FileIter;
    typedef std::vector<std::istream*>				FileStreams;
    typedef std::vector<FileIter>					FileIters;
    
    System&     mSystem;
    FileStreams mStreams;
    FileIters   mIters;
    FileIter    mFileEnd;
    
    
    ShapeIter   mShapesNext;
    ShapeIter   mShapesEnd;

    typedef std::map<FinishedShape, int>	Sieve;
    typedef Sieve::value_type				SievePair;
    
    Sieve       mSieve;
    
    void insertNext(int i);
    OutputMerge& operator=(const OutputMerge&) { return *this; }
};

#endif // INCLUDE_SHAPESTL_H
