/*
 *  shapeSTL.cpp
 *  Context Free
 *
 *  Created by Mark Lentczner on 3/17/06.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#include "shapeSTL.h"

using namespace std;

ShapeOp::~ShapeOp() { }


void
OutputMerge::addTempFile(ref_ptr<TempFile> t)
{
    istream* f = t->forRead();
    mStreams.push_back(f);
    mIters.push_back(FileIter(*f));
    
    insertNext(mIters.size() - 1);
}

void
OutputMerge::addShapes(ShapeIter begin, ShapeIter end)
{
    mShapesNext = begin;
    mShapesEnd = end;
    
    insertNext(-1);
}

OutputMerge::~OutputMerge()
{
    for (FileStreams::iterator i = mStreams.begin(); i != mStreams.end(); ++i) {
        delete *i;
    }
}

void
OutputMerge::insertNext(int i)
{
    if (i < 0) {
        if (mShapesNext != mShapesEnd) {
            mSieve.insert(SievePair(*mShapesNext++, i));
        }
    }
    else {
        FileIter& input = mIters[i];
        if (input != mFileEnd) {
            mSieve.insert(SievePair(*input++, i));
        }
    }
}
