/*
 *  renderimpl.h
 *  Context Free
 *
 *  Created by Mark Lentczner on 2006-02-18.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef INCLUDE_RENDERIMPL_H
#define INCLUDE_RENDERIMPL_H

#ifdef _WIN32
#pragma warning( disable : 4786 )
#endif

#include <deque>
#include <set>

#include "agg_trans_affine.h"
#include "bounds.h"
#include "cfdg.h"
#include "cfdgimpl.h"
#include "shape.h"
#include "tempfile.h"

class ShapeOp;


class RendererImpl : public Renderer {
    public:
        RendererImpl(CFDGImpl* cfdg,
                        int width, int height, float minSize,
                        int variation, double border);
        ~RendererImpl();

        void setMaxShapes(int n);
        void resetBounds();
        
        double run(Canvas* canvas, bool partialDraw);
        void draw(Canvas* canvas);
        void animate(Canvas* canvas, int frames, bool zoom);
        
        void requestStop();
        void requestFinishUp();
        void requestUpdate();
        
    private:
        void updateBounds(const agg::trans_affine& tr, int primShapeType);
        
        void outputPrep(Canvas*);
        void rescaleOutput(int& curr_width, int& curr_height, bool final);
		void forEachShape(bool final, ShapeOp& op);

        void output(bool final);
        void outputPartial() { output(false); }
        void outputFinal() { output(true); }
        void outputStats();
		
        friend class OutputDraw;
        friend class OutputMerge;
		friend class OutputBounds;
        
        bool isDone();
        void fileIfNecessary();
        void moveFinishedToFile();
        void moveUnfinishedToTwoFiles();
        void getUnfinishedFromFile();
        System* system() { return m_cfdg->system(); }
        void processShape(const Shape& s);

    private:
        CFDGImpl*   m_cfdg;
        Canvas*     m_canvas;

        int m_maxShapes;
        bool m_tiled;
        bool m_sized;

        double mNextFramePoint;

        std::deque<FinishedShape> mFinishedShapes;
        std::multiset<Shape> mUnfinishedShapes;

        std::deque< ref_ptr<TempFile> > m_finishedFiles;
        std::deque< ref_ptr<TempFile> > m_unfinishedFiles;
        int mFinishedFileCount;
        int mUnfinishedFileCount;

        int mVariation;
        
        double mScaleArea;
        double mFixedBorder;
        double mShapeBorder;
        double mTotalArea;

        double m_currScale;
        double m_minArea;
        Bounds mBounds;
        agg::trans_affine m_currTrans;
        unsigned int m_outputSoFar;

        System::Stats m_stats;
        int m_unfinishedInFilesCount;

        volatile bool m_pleaseStop;
        volatile bool m_pleaseFinishUp;
        volatile bool m_pleaseSendUpdate;
};


#endif // INCLUDE_RENDERIMPL_H
