/*
 *  qtCanvas.h
 *  Context Free
 *
 *  Created by Mark Lentczner on 2006-02-23.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef INCLUDE_QTCANVAS_H
#define INCLUDE_QTCANVAS_H

// forward decls and ugly typedef from CFBase.h -- pointer types are bad!
struct __CFString;
typedef const struct __CFString * CFStringRef;

#include "aggCanvas.h"

class qtCanvas : public aggCanvas {
    public:
        qtCanvas(int width, int height);
        ~qtCanvas();
        
        void end();

		void setPreview(void* data, unsigned width, unsigned height,
							int stride, PixelFormat format);
		void showSettingsDialog();
		void prepareMovie(CFStringRef);
		
		int convertToFrames(float seconds);

        static bool systemInit();
        static void systemExit();
        
    private:
        static bool systemInited;
        class Impl;
        Impl& impl;
        qtCanvas& operator=(qtCanvas& c) { return c; }
};

#endif // INCLUDE_QTCANVAS_H

