%{
    #include "yglue.h"
%}

%token STARTSHAPE
%token RULE
%token LEFTBRACKET
%token RIGHTBRACKET
%token LEFTBRACE
%token RIGHTBRACE
%token STAR
%token ROTATE
%token FLIP
%token XSHIFT
%token YSHIFT
%token ZSHIFT
%token SIZE
%token SKEW
%token HUE
%token SATURATION
%token BRIGHTNESS
%token ALPHA
%token TARGETHUE
%token TARGETSATURATION
%token TARGETBRIGHTNESS
%token TARGETALPHA
%token BACKGROUND
%token <string> USER_STRING
%token <real> USER_INTEGER
%token <real> USER_RATIONAL
%token <real> USER_RATIONAL_TARGET
%token <string> USER_FILENAME
%token INCLUDE
%token TILE

%%


cfdg:
        cfdg statement
        |
        ;
        
statement:
          initialization
        | background  
        | inclusion
        | tile
        /* | size */
        | rule
        ;
        
inclusion:
        INCLUDE USER_STRING  {
            yg_IncludeFile($2);
        }
        |
        INCLUDE USER_FILENAME  {
            yg_IncludeFile($2);
        } 
        ;

initialization:
        STARTSHAPE USER_STRING  {
            yg_Initialize($2);
        }

background:
        BACKGROUND LEFTBRACKET buncha_color_adjustments RIGHTBRACKET {
            yg_Background();
        }
        ;

tile:
        TILE modification {
            const char *errmsg = yg_Tile();
            if (errmsg) {
                yyerror(errmsg);
                YYABORT;
            }
        }
        ;

size:
SIZE modification {
    const char *errmsg = yg_SizeLine();
    if (errmsg) {
        yyerror(errmsg);
        YYABORT;
    }
}
;

rule:
        RULE USER_STRING LEFTBRACKET buncha_replacements RIGHTBRACKET {
            yg_Rule($2, 1.0);
        }
        |
        RULE USER_STRING USER_RATIONAL { yg_ClearTransform(); } LEFTBRACKET buncha_replacements RIGHTBRACKET {
            if ($3 <= 0.0) {
                yyerror("Rule weights must be positive.");
                YYABORT;
            }
            yg_Rule($2, $3);
        }
        ;

buncha_replacements: 
        buncha_replacements replacement
        |
        ;

replacement:
        USER_STRING modification {
            yg_Replacement($1);
        }
        |
        USER_RATIONAL STAR modification { yg_SaveTransform(); } USER_STRING modification {
            yg_ReplacementLoop($5, (int)$1);
        }
        ;

modification:
        LEFTBRACKET buncha_adjustments RIGHTBRACKET {
            yg_DefTransform();
        }
        |
        LEFTBRACE buncha_adjustments RIGHTBRACE {
        }
        ;

buncha_adjustments:
        buncha_adjustments adjustment
        |
        ;

buncha_color_adjustments:
        buncha_color_adjustments color_adjustment
        |
        ;

adjustment:
        ROTATE USER_RATIONAL {
            yg_Orientation($2);
        }
        |
        FLIP USER_RATIONAL {
            yg_Reflection($2);
        }
        |
        XSHIFT USER_RATIONAL {
            yg_XLocation($2);
        }
        |
        YSHIFT USER_RATIONAL {
            yg_YLocation($2);
        }
        |
        ZSHIFT USER_RATIONAL {
            yg_ZLocation($2);
        }
        |
        SIZE USER_RATIONAL {
            yg_Size($2, $2, 1.0);
        }
        |
        SIZE USER_RATIONAL USER_RATIONAL {
            yg_Size($2, $3, 1.0);
        }
        |
        SIZE USER_RATIONAL USER_RATIONAL USER_RATIONAL {
            yg_Size($2, $3, $4);
        }
        |
        SKEW USER_RATIONAL USER_RATIONAL {
            yg_Skew($2, $3);
        }
        |
        color_adjustment
        ;

color_adjustment:
        HUE USER_RATIONAL {
            yg_Hue($2, 0);
        }
        |
        SATURATION USER_RATIONAL {
            yg_Saturation($2, 0);
        }
        |
        BRIGHTNESS USER_RATIONAL {
            yg_Brightness($2, 0);
        }
        |
        ALPHA USER_RATIONAL {
            yg_Alpha($2, 0);
        }
        |
        HUE USER_RATIONAL_TARGET {
            yg_Hue($2, -1);
        }
        |
        SATURATION USER_RATIONAL_TARGET {
            yg_Saturation($2, -1);
        }
        |
        BRIGHTNESS USER_RATIONAL_TARGET {
            yg_Brightness($2, -1);
        }
        |
        ALPHA USER_RATIONAL_TARGET {
            yg_Alpha($2, -1);
        }
        |
        TARGETHUE USER_RATIONAL {
            yg_HueTarget($2, 0);
        }
        |
        TARGETSATURATION USER_RATIONAL {
            yg_SaturationTarget($2, 0);
        }
        |
        TARGETBRIGHTNESS USER_RATIONAL {
            yg_BrightnessTarget($2, 0);
        }
        |
        TARGETALPHA USER_RATIONAL {
            yg_AlphaTarget($2, 0);
        } 
        ;

%%


