%{
    #include "yglue.h"
    #include "y.tab.h"
    
    extern YYSTYPE yylval;
%}


INTEGER     [0-9]+
RATIONAL    ([0-9]+\.[0-9]*)|(\.[0-9]+)
STRING      [a-zA-Z\200-\377_]+[a-zA-Z_0-9\200-\377]*
WHITESPACE  [ \n\t\r\f]*
FILENAME    [/a-zA-Z\200-\377_\-0-9\.\"~]+

/* calling this externally    */
/* don't want yywrap to exist.*/

%option noyywrap
%option yylineno
%%

\#[^\n]*\n  /* pound comment line */
\/\/[^\n]*\n  /* c++ style comment line */
\/\*([^\*]|[\r\n]|(\*+([^\*\/]|[\r\n])))*\*+\/ /* c style comments */
\#[^\r\n]*\r\n*  /* pound comment line */
\/\/[^\r\n]*\r\n*  /* c++ style comment line */


"startshape"    {return STARTSHAPE;}
"background"    {return BACKGROUND;}
"include"       {return INCLUDE;}
"tile"          {return TILE;}
"rule"          {return RULE;}
"{"             {return LEFTBRACKET;}
"}"             {return RIGHTBRACKET;}
"["             {return LEFTBRACE;}
"]"             {return RIGHTBRACE;}
"*"		{return STAR;}
"rotate"        {return ROTATE;}
"r"             {return ROTATE;}
"flip"	        {return FLIP;}
"f"             {return FLIP;}
"hue"           {return HUE;}
"h"             {return HUE;}
"saturation"    {return SATURATION;}
"sat"           {return SATURATION;}
"brightness"    {return BRIGHTNESS;}
"b"             {return BRIGHTNESS;}
"alpha"         {return ALPHA;}
"a"             {return ALPHA;}
"x"             {return XSHIFT;}
"y"             {return YSHIFT;}
"z"             {return ZSHIFT;}
"size"          {return SIZE;}
"s"             {return SIZE;}
"skew"          {return SKEW;}
"|hue"          {return TARGETHUE;}
"|h"            {return TARGETHUE;}
"|saturation"   {return TARGETSATURATION;}
"|sat"          {return TARGETSATURATION;}
"|brightness"   {return TARGETBRIGHTNESS;}
"|b"            {return TARGETBRIGHTNESS;}
"|alpha"        {return TARGETALPHA;}
"|a"            {return TARGETALPHA;}


{STRING}    {yylval.string=yg_BuildString(yytext); return USER_STRING;}
{RATIONAL}  {yylval.real=yg_BuildReal(yytext); return USER_RATIONAL;}
{INTEGER}   {yylval.real=yg_BuildReal(yytext); return USER_RATIONAL;}
"-"{RATIONAL}  {yylval.real=yg_BuildReal(yytext); return USER_RATIONAL;}
"-"{INTEGER}   {yylval.real=yg_BuildReal(yytext); return USER_RATIONAL;}
{RATIONAL}"|"  {yylval.real=yg_BuildReal(yytext); return USER_RATIONAL_TARGET;}
{INTEGER}"|"   {yylval.real=yg_BuildReal(yytext); return USER_RATIONAL_TARGET;}
"-"{RATIONAL}"|"  {yylval.real=yg_BuildReal(yytext); return USER_RATIONAL_TARGET;}
"-"{INTEGER}"|"   {yylval.real=yg_BuildReal(yytext); return USER_RATIONAL_TARGET;}
{FILENAME}    {yylval.string=yg_BuildString(yytext); return USER_FILENAME;}


.|\n|\r      /* eat up any unmatched character */
