/*
 *  bounds.h
 *  Context Free
 *
 *  Created by Mark Lentczner on 3/18/06.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef INCLUDE_BOUNDS_H
#define INCLUDE_BOUNDS_H

namespace agg { struct trans_affine; }

class Bounds {
    public:
        Bounds() : mValid(false) {}
		
		Bounds(const agg::trans_affine& trans,
			int primShapeType);
			// set bounds to be the bounds of this shape, transformed
		
		bool valid() { return mValid; }
		
		void merge(const Bounds&);
			// merge the other bounds into this bounds
		
		Bounds operator+(const Bounds& other)
			{ Bounds t(*this); t.merge(other); return t; }
			
		Bounds& operator+=(const Bounds& other)
			{ merge(other); return *this; }
		
		Bounds interpolate(const Bounds& other, double alpha) const;
			// compute the interpolation between this bounds and the other
			// an alpha of 0.0 has no effect, an alpha of 1.0 give the other
		Bounds slewCenter(const Bounds& other, double alpha) const;
			// compute a new bounds who's center is slewed alpha of the way
			// toward the other center, yet incorporates all of the current
			// bounds
			
		double computeScale(int& width, int& height, double border,
					bool modify = false, agg::trans_affine* trans = 0,
                    bool exact = false);
			// Computes the scale factor of fitting this bounds into a canvas
			// of the given width and height, with the provided fixed border.
			// If modify is true, width and height are reset to the scaled size.
			// If trans isn't null, it is set to the needed transformation.
            // If exact is true then the diensions are not bumped to preserve parity.

		void gather(const Bounds& other, double weight);
		
        static agg::trans_affine ScaleFactor;
    
        double  mMin_X, mMin_Y, mMax_X, mMax_Y;
        bool    mValid;
};

#endif // INCLUDE_BOUNDS_H
