/*
 *  aggCanvas.h
 *  Context Free
 *
 *  Created by Mark Lentczner on 5/19/05.
 *  Copyright 2005 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef INCLUDE_AGGCANVAS_H
#define INCLUDE_AGGCANVAS_H

#include "cfdg.h"
#include "agg_trans_affine.h"

class aggCanvas : public Canvas {
    public:
        enum PixelFormat {Gray8_Blend = 0, RGBA8_Blend = 1, QT_Blend = 2, RGB8_Blend = 3};
        static int BytesPerPixel[4];
        void start(bool clear, const agg::rgba& bk, int width, int height);
        void end();

        void circle(RGBA8 c, agg::trans_affine tr);
        void square(RGBA8 c, agg::trans_affine tr);
        void triangle(RGBA8 c, agg::trans_affine tr);
        
		bool colorCount256();
			// return whether the aggCanvas can fit in byte pixels
        
        static PixelFormat SuggestPixelFormat(CFDG* engine);
        
    protected:
        aggCanvas(PixelFormat);
        virtual ~aggCanvas();
        
        void attach(void* data, unsigned width, unsigned height, int stride);
            // data is int8u grayscale pixels or int32u pixels
        
		void copy(void* data, unsigned width, unsigned height,
							int stride, PixelFormat format);
			// copy the image from different pixel buffer
			
        int cropX();
        int cropY();
        int cropWidth();
        int cropHeight();
    
    //private:
    public:
        class impl;
        impl* m;
};

#endif // INCLUDE_AGGCANVAS_H


