.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: RkGetDic.man,v 2.1 1994/04/21 00:46:27 kuma Exp $ NEC;
.TH "RKGETDICLIST" "3"
.SH "NAME"
\f4RkGetDicList\f1 \- get the name of a dictionary that can be added to the dictionary list
.SH "SYNOPSIS"
.nf
.ft 4
#include <canna/RK.h>
int RkGetDicList(cxnum, dics, maxdics)
int cxnum;
char *dics;
int maxdics;
.ft 1
.fi
.SH "DESCRIPTION"
\f2RkGetDicList\f1 gets the name of a dictionary that can be added to the dictionary list.
.P
Multiple dictionaries can be simultaneously used during kana-kanji conversion.  The simultaneously available dictionaries are chained to the dictionary list in the conversion context.  The dictionary named at the beginning of the dictionary list is referenced first of all and candidates generated from it are also treated on a priority basis.  Dictionaries are identified by the dictionary name in the dictionary table.
.P
Dictionary names are got in the area \f2dics\f1 in the following format:
.P
.RS 0.2c
dictionary-name-1 0 dictionary-name-2 0 ... dictionary-name-n 0 0
.RE
.P
The size of the area \f2dics\f1 is given in bytes by \f2maxdics\f1.  The dictionary list is truncated in character strings when it exceeds this size.
.SH "RETURN VALUE"
This function returns number of dictionary names, or returns \f4-1\f1 if the context is invalid.   
