
#include "nap.h"
#include "struct.h"
#include "alias.h"
#include "exec.h"
#include "if.h"
#include "history.h"
#include "hook.h"
#include "keys.h"
#include "list.h"
#include "input.h"
#include "output.h"
#include "ircterm.h"
#include "server.h"
#include "vars.h"
#include "window.h"
#include "status.h"
#include "napster.h"
#include "commands.h"
#include "timer.h"
#include "help.h"
#include "scott2.h"
#include "tgtk.h"
#include "whois.h"
#include "ptest.h"
#include <unistd.h>
#include <sys/stat.h>

#ifdef HAVE_UNAME
#include <sys/utsname.h>
#endif

int parse_command(register char *, int, char *);

#ifndef SCRIPT_PATH
#define SCRIPT_PATH "/usr/local/lib/"
#endif

BUILT_IN_COMMAND(send_comm);
BUILT_IN_COMMAND(send_1comm);
BUILT_IN_COMMAND(send_2comm);
BUILT_IN_COMMAND(exec_cmd);
BUILT_IN_COMMAND(versioncmd);
BUILT_IN_COMMAND(nap_stats);
BUILT_IN_COMMAND(evalcmd);
BUILT_IN_COMMAND(send_me);
BUILT_IN_COMMAND(query);
BUILT_IN_COMMAND(browse);
BUILT_IN_COMMAND(my_clear);
BUILT_IN_COMMAND(scott);
BUILT_IN_COMMAND(send_names);
BUILT_IN_COMMAND(relmcmd);
BUILT_IN_COMMAND(queuecmd);
BUILT_IN_COMMAND(server_ignore);
BUILT_IN_COMMAND(echocmd);
BUILT_IN_COMMAND(resume);
BUILT_IN_COMMAND(beepcmd);
BUILT_IN_COMMAND(nslookup);
BUILT_IN_COMMAND(mychdir);
BUILT_IN_COMMAND(dbsearch);
BUILT_IN_COMMAND(send_allcomm);
BUILT_IN_COMMAND(send_file);
BUILT_IN_COMMAND(send_kill);
BUILT_IN_COMMAND(send_kick);
BUILT_IN_COMMAND(send_muzzle);
BUILT_IN_COMMAND(send_unmuzzle);
BUILT_IN_COMMAND(ptestcmd);
BUILT_IN_COMMAND(hookcmd);
BUILT_IN_COMMAND(inputcmd);
BUILT_IN_COMMAND(reset);
BUILT_IN_COMMAND(e_pause);

BUILT_IN_COMMAND(breakcmd);
BUILT_IN_COMMAND(continuecmd);
BUILT_IN_COMMAND(returncmd);
BUILT_IN_COMMAND(sleepcmd);
BUILT_IN_COMMAND(usleepcmd);
BUILT_IN_COMMAND(comment);
BUILT_IN_COMMAND(waitcmd);
BUILT_IN_COMMAND(spingcmd);
BUILT_IN_COMMAND(dnscmd);
BUILT_IN_COMMAND(sendlinecmd);
BUILT_IN_COMMAND(listusers);
BUILT_IN_COMMAND(send_chanlevel);
BUILT_IN_COMMAND(listop);
BUILT_IN_COMMAND(createop);
BUILT_IN_COMMAND(delop);
BUILT_IN_COMMAND(set_chanlimit);

int load_depth = -1;
int loading_savefile = 0;
extern int current_numeric;

PingStruct *ping_time = NULL;
PingStruct *sping_time = NULL;

static IgnoreStruct *ignores = NULL;
static IgnoreStruct *signores = NULL;
static IgnoreStruct *cignores = NULL;

typedef	struct	WaitCmdstru
{
	char	*stuff;
	struct	WaitCmdstru	*next;
}	WaitCmd;

static	WaitCmd	*start_wait_list = NULL,
		*end_wait_list = NULL;

#define SERVERREQ	0x0001
#define INTERNAL_HELP	0x0010

/* Used to handle and catch breaks and continues */
	int     will_catch_break_exceptions = 0;
	int     will_catch_continue_exceptions = 0;
	int     will_catch_return_exceptions = 0;
	int     break_exception = 0;
	int     continue_exception = 0;
	int     return_exception = 0;


IrcCommand irc_command[] = {
{ "",		empty_string,	do_send_text,	NULL, SERVERREQ, 0 },
{ "#",		NULL,		comment,	NULL, 0, 0 },
{ ":",		NULL,		comment,	NULL, 0, 0 },
{ "ADMIN",	NULL,		nadmin,		HELP_ADMIN, SERVERREQ|INTERNAL_HELP, 0 },
{ "ALIAS",	NULL,		aliascmd,	HELP_ALIAS, 0, 0 },
{ "ASSIGN",	NULL,		assigncmd,	HELP_ASSIGN, 0, 0 },
{ "BEEP",	NULL,		beepcmd,	HELP_BEEP, 0, 0 },
{ "BIND",	NULL,		bindcmd,	HELP_BIND, 0, 0 },

{ "BLOCK",	NULL,		send_1comm,	HELP_BLOCK, SERVERREQ, CMDS_BLOCK },
{ "BLOCKLIST",	NULL,		send_comm,	HELP_BLOCK, SERVERREQ, CMDS_BLOCKLIST },

{ "BREAK",	NULL,		breakcmd,	HELP_BREAK, 0, 0 },
{ "BROWSE",	NULL,		browse,		HELP_BROWSE, SERVERREQ, CMDS_BROWSE },

{ "CBAN",	NULL,		send_2comm,	HELP_CBAN, SERVERREQ, CMDS_CBAN },
{ "CBANCLEAR",	NULL,		send_1comm,	HELP_CBANCLEAR, SERVERREQ, CMDS_CBANCLEAR },
{ "CBANLIST",	NULL,		send_1comm,	HELP_CBANLIST, SERVERREQ, CMDS_CBANLIST },
{ "CD",		NULL,		mychdir,	HELP_CD, 0, 0 },
{ "CHANLEVEL",	NULL,		send_chanlevel, HELP_CHANLEVEL, SERVERREQ, CMDS_SETCHANLEVEL },
{ "CIGNORE",	"CIGNORE",	ignore_user,	HELP_CIGNORE, 0, 0 },
{ "CLEAR",	NULL,		my_clear,	HELP_CLEAR, 0, 0 },
{ "CLOAK",	NULL,		send_comm,	HELP_CLOAK, SERVERREQ, CMDS_CLOAK },
{ "CLOSE",	NULL,		serverclose,	HELP_CLOSE, SERVERREQ, 0 },
{ "CONTINUE",	NULL,		continuecmd,	HELP_CONTINUE, 0, 0 },
{ "CUNBAN",	NULL,		send_2comm,	HELP_CUNBAN, SERVERREQ, CMDS_CUNBAN },
{ "DBSEARCH",	NULL,		dbsearch,	HELP_DBSEARCH, 0, 0 },
{ "DELETE",	NULL,		nap_del,	HELP_DELETE, 0, 0 },
{ "DEOP",	NULL,		delop,		HELP_DELOP, 0, 0 },
{ "DF",		"df",		exec_cmd,	HELP_DF, 0, 0 },
{ "DISCONNECT",	NULL,		serverclose,	HELP_DISCONNECT, SERVERREQ, 0 },
{ "DNS",	NULL,		dnscmd,		NULL, SERVERREQ, 0 },
{ "DO",		NULL,		docmd,		HELP_DO, 0, 0 },
{ "DU",		"du",		exec_cmd,	HELP_DU, 0, 0 },
{ "DUMP",	NULL,		dumpcmd,	HELP_DUMP, 0, 0 },
{ "ECHO",	NULL,		echocmd,	HELP_ECHO, 0, 0 },
{ "EVAL",	NULL,		evalcmd,	HELP_EVAL, 0, 0 },
{ "EXEC",	NULL,		execcmd,	HELP_EXEC, 0, 0 },
{ "FE",		"FE",		fe,		HELP_FE, 0, 0 },
{ "FEC",	"FEC",		fe,		HELP_FEC, 0, 0 },
{ "FOR",	NULL,		forcmd,		HELP_FOR, 0, 0 },
{ "FOREACH",	NULL,		foreach,	HELP_FOREACH, 0, 0 },
{ "GET",	"GET",		request,	HELP_GET, SERVERREQ, 0 },
{ "GLIST",	NULL,		glist,		HELP_GLIST, 0, 0 },
{ "GUSERS",	NULL,		listusers,	HELP_GUSERS, SERVERREQ, CMDS_SHOWUSERS },
{ "HELP",	NULL,		help,		HELP_HELP, 0, 0 },
{ "HISTORY",	NULL,		history,	HELP_HISTORY, 0, 0 },
{ "HOOK",	NULL,		hookcmd,	HELP_HOOK, 0, 0 },
{ "HOTLIST",	NULL,		hotlist,	HELP_HOTLIST, 0, 0 },
{ "IF",		"IF",		ifcmd,		HELP_IFCMD, 0, 0 },
{ "IGNORE",	NULL,		ignore_user,	HELP_IGNORE, 0, 0 },

{ "INPUT",	"INPUT",	inputcmd,	HELP_INPUT, 0, 0 },
{ "INPUT_CHAR",	"INPUT_CHAR",	inputcmd,	HELP_INPUTCHAR, 0, 0 },

{ "JOIN",	NULL,		joincmd,	HELP_JOIN, 0, 0 },
{ "KICK",	NULL,		send_kick,	HELP_KICK, 0, CMDS_KICK },
{ "KILL",	NULL,		send_kill,	HELP_KILL, SERVERREQ, CMDS_KILLUSER },
{ "L",		NULL,		partcmd,	HELP_L, SERVERREQ, 0 },
{ "LASTLOG",	NULL,		lastlog,	HELP_LASTLOG, 0, 0 },
{ "LEAVE",	NULL,		partcmd,	HELP_LEAVE, SERVERREQ, 0 },
{ "LIST",	NULL,		send_comm,	HELP_LIST, SERVERREQ, CMDS_SHOWALLCHANNELS },
{ "LOAD",	NULL,		load,		HELP_LOAD, 0, 0 },
{ "LOCAL",	NULL,		localcmd,	HELP_LOCAL, 0, 0 },
{ "LS",		"ls",		exec_cmd,	HELP_LS, 0, 0 },
{ "M",		"MSG",		privmsg,	HELP_M, SERVERREQ, 0 },
{ "ME",		NULL,		send_me,	HELP_ME, 0, CMDS_SENDME },
{ "MOTD",	NULL,		send_comm,	HELP_MOTD, SERVERREQ, CMDR_MOTDS },
{ "MSG",	"MSG",		privmsg,	HELP_MSG, SERVERREQ, 0 },
{ "MUZZLE",	NULL,		send_muzzle,	HELP_MUZZLE, SERVERREQ, CMDS_MUZZLE },
{ "NAMES",	NULL,		send_names,	HELP_NAMES, SERVERREQ, CMDS_NAME },
{ "NSLOOKUP",	NULL,		nslookup,	HELP_NSLOOKUP, 0, 0 },
{ "ON",		NULL,		oncmd,		HELP_ON, 0, 0 },
{ "OP",		NULL,		createop,	HELP_OP, 0, 0 },
{ "OPDEL",	NULL,		delop,		HELP_DELOP, 0, 0 },
{ "OPLIST",	NULL,		listop,		HELP_OPLIST, 0, 0 },
{ "PARSEKEY",	NULL,		parsekeycmd,	HELP_PARSEKEY, 0, 0 },
{ "PART",	NULL,		partcmd,	HELP_PART, SERVERREQ, 0 },

{ "PAUSE",	NULL,		e_pause,	HELP_PAUSE, 0, 0 },

{ "PING",	NULL,		ping,		HELP_PING, SERVERREQ, 0 },
{ "PRINT",	NULL,		print_napster,	HELP_PRINT, 0, 0 },
{ "PS",		"ps",		exec_cmd,	HELP_PS, 0, 0 },
{ "PTEST",	NULL,		ptestcmd,	HELP_PTEST, 0, 0 },
{ "PURGE",	NULL,		purge,		HELP_PURGE, 0, 0 },
{ "QUERY",	NULL,		query,		HELP_QUERY, 0, 0 },
{ "QUEUE",	NULL,		queuecmd,	HELP_QUEUE, 0, 0 },
{ "QUIT",	NULL,		napquit,	HELP_QUITNAP, 0, 0 },
{ "RAW",	NULL,		rawcmd,		HELP_RAW, SERVERREQ, 0 },
{ "RBIND",	NULL,		rbindcmd,	HELP_RBIND, 0, 0 },
{ "RELM",	NULL,		relmcmd,	HELP_RELM, 0, 0 },
{ "RELOAD",	NULL,		reload_save,	HELP_RELOAD, 0, 0 },
{ "REPEAT",	NULL,		repeatcmd,	HELP_REPEAT, 0, 0 },
{ "REQUEST",	"REQUEST",	request,	HELP_REQUEST, SERVERREQ, 0 },
{ "RESET",	NULL,		reset,		HELP_RESET, 0, 0 },
{ "RESUME",	"RESUME",	resume,		HELP_RESUME, SERVERREQ, 0 },
{ "RETURN",	NULL,		returncmd,	HELP_RETURN, 0, 0 },
{ "S",		NULL,		nap_search,	HELP_S, SERVERREQ, 0 },
{ "SAVE",	NULL,		savenap,	HELP_SAVE, 0, 0 },
{ "SAY",	empty_string,	do_send_text,	HELP_SAY, SERVERREQ, 0 },
{ "SC",		NULL,		nap_scan,	HELP_SC, SERVERREQ, 0 },
{ "SCAN",	NULL,		nap_scan,	HELP_SCAN, SERVERREQ, 0 },
#ifdef SCOTT
{ "SCOTT",	NULL,		scott,		HELP_SCOTT, SERVERREQ, 0 },
#endif
{ "SEARCH",	NULL,		nap_search,	HELP_SEARCH, SERVERREQ, 0 },
{ "SEND",	NULL,		send_file,	HELP_SEND, SERVERREQ, 0 },
{ "SENDLINE",	empty_string,	sendlinecmd,	HELP_SENDLINE, 0, 0 },
{ "SERVER",	NULL,		window_serv,	HELP_SERVER, 0, 0 },
{ "SET",	NULL,		setcmd,		HELP_SET, 0, 0 },
{ "SETCHANNELLIMIT", NULL,	set_chanlimit,	NULL, 0, 0 },
{ "SHARE",	NULL,		share_napster,	HELP_SHARE, 0, 0 },
{ "SIGNORE",	NULL,		server_ignore,	HELP_SIGNORE, 0, 0 },
{ "SLEEP",	NULL,		sleepcmd,	HELP_SLEEP, 0, 0 },
{ "SOUNDEX",	"SOUNDEX",	nap_search,	HELP_SOUNDEX, SERVERREQ, 0 },
{ "SPING",	NULL,		spingcmd,	HELP_SPING, SERVERREQ, 0 },
{ "STATS",	NULL,		nap_stats,	HELP_STATS, 0, 0 },
{ "STUB",	NULL,		stubcmd,	HELP_STUB, 0, 0 },
{ "SWITCH",	NULL,		switchcmd,	HELP_SWITCH, 0, 0 },
{ "TIMER",	NULL,		timercmd,	HELP_TIMER, 0, 0 },
{ "TOPIC",	NULL,		topic,		HELP_TOPIC, SERVERREQ, 0 },
{ "TYPE",	NULL,		typecmd,	HELP_TYPE, 0, 0 },
{ "UNBLOCK",	NULL,		send_1comm,	HELP_UNBLOCK, SERVERREQ, CMDS_UNBLOCK },
{ "UNLESS",	"UNLESS",	ifcmd,		HELP_UNLESS, 0, 0 },
{ "UNMUZZLE",	NULL,		send_unmuzzle,	HELP_UNMUZZLE, SERVERREQ, CMDS_UNMUZZLE },
{ "USLEEP",	NULL,		usleepcmd,	HELP_USLEEP, 0, 0 },
{ "VERSION",	NULL,		versioncmd,	HELP_VERSION, 0, 0 },
{ "W",		NULL,		whois,		HELP_W, SERVERREQ, 0 },
{ "WAIT",	NULL,		waitcmd,	HELP_WAIT, 0, 0 },
{ "WALLOP",	NULL,		send_allcomm,	HELP_WALLOP, SERVERREQ, CMDS_OPSAY },
{ "WHILE",	"WHILE",	whilecmd,	HELP_WHILE, 0, 0 },
{ "WHOIS",	NULL,		whois,		HELP_WHOIS, SERVERREQ, 0 },
{ "WINDOW",	NULL,		windowcmd,	HELP_WINDOW, INTERNAL_HELP, 0 },
{ "XECHOl",	"XECHO",	echocmd,	HELP_XECHO, 0, 0 },
{ NULL,		NULL,		NULL,		NULL, 0, 0 }
};

#define	NUMBER_OF_COMMANDS (sizeof(irc_command) / sizeof(IrcCommand)) - 2

/* comment: does the /COMMENT command, useful in .ircrc */
BUILT_IN_COMMAND(comment)
{
	/* nothing to do... */
}



int check_nignore(char *nick)
{
	if (ignores && find_in_list((List **)&ignores, nick, 0))
		return 1;
	return 0;
}

int check_cignore(char *chan)
{
	if (cignores && find_in_list((List **)&cignores, chan, 0))
		return 1;
	return 0;
}

int check_server_ignore(char *match)
{
IgnoreStruct *new;
	if (signores)
	{
		for (new = signores; new; new = new->next)
			if (wild_match(new->nick, match))
				return 1;
	}
	return 0;
}

BUILT_IN_COMMAND(versioncmd)
{
int cmd = CMDS_SENDMSG;
char *arg;
ChannelStruct *ch;
char *version_buf = NULL;
#ifdef HAVE_UNAME
struct utsname buf;
	
	uname(&buf);
	malloc_sprintf(&version_buf, "%s %s %s %s", nap_version, internal_version, buf.sysname, buf.release?buf.release:empty_string);
#else
	malloc_sprintf(&version_buf, "%s %s", nap_version, internal_version);
#endif
	if (!(arg = next_arg(args, &args)))
		arg = current_window->current_channel, cmd = CMDS_SEND;
	else
	{
		for (ch = current_window->nchannels; ch; ch = ch->next)
		{
			if (!my_stricmp(arg, ch->channel))
			{
				cmd = CMDS_SEND;
				break;
			}
		}
	}
	if (arg)		
		send_ncommand(cmd, "%s %s", arg, version_buf);
	else
		say("%s", version_buf);
	new_free(&version_buf);
}

BUILT_IN_COMMAND(send_comm)
{
	send_ncommand(numeric, NULL);
}

BUILT_IN_COMMAND(send_1comm)
{
char *arg;
	if ((arg = next_arg(args, &args)))
		send_ncommand(numeric, "%s%s%s", arg, args && *args ? space : empty_string, args && *args ? args : empty_string);
}

BUILT_IN_COMMAND(send_2comm)
{
char *arg1, *arg2;
	if ((arg1 = next_arg(args, &args)) && (arg2 = next_arg(args, &args)))
		send_ncommand(numeric, "%s %s%s%s", arg1, arg2, args && *args ? space : empty_string, args && *args ? args : empty_string);
}

BUILT_IN_COMMAND(send_names)
{
char *arg;
	if ((arg = next_arg(args, &args)))
		send_ncommand(numeric, "%s", arg);
	else if (current_window->current_channel)
		send_ncommand(numeric, "%s", current_window->current_channel);
}

BUILT_IN_COMMAND(browse)
{
char *arg;
extern Server *server_list;
NickStruct *n;
	if (from_server == -1)
		return;
	n = server_list[from_server].users;
	if ((arg = next_arg(args, &args)))
	{
		if (!my_stricmp(arg, "-clear"))
		{
			while ((arg = next_arg(args, &args)))
			{
				if ((n = (NickStruct *)find_in_list((List **)&n, arg, 0)))
					clear_filelist(&n->file_browse);
			}
			return;
		}
		if (!n || !(n = (NickStruct *)find_in_list((List **)&server_list[from_server].users, arg, 0)))
		{
			n = (NickStruct *)new_malloc(sizeof(NickStruct));
			n->nick = m_strdup(arg);
#ifdef GTK
			if (tgtk_okay() && get_int_var(GTK_VAR) && scott2_okay())
				scott2_add_nick(from_server, n->nick);
#endif
			add_to_list_double((List **)&server_list[from_server].users, (List *)n);
			do_hook(BROWSE_BEGIN_LIST, "%s", arg);
			send_ncommand(numeric, "%s", arg);
			clear_filelist(&n->file_browse);
			n->flag |= BROWSE_IN_PROGRESS;
		} 
		else if (n->flag & BROWSE_IN_PROGRESS)
		{
			say("Can't do that while a browse is in progress");
			return;
		}
		else
		{
			display_list(n->file_browse);
			return;
		}
	}
	else if (n)
		display_list(n->file_browse);
}

BUILT_IN_COMMAND(send_me)
{
	if (args && *args && current_window->current_channel)
		send_ncommand(numeric, "%s \"%s\"", current_window->current_channel, args);
}

BUILT_IN_COMMAND(send_kill)
{
char *nick, *n;
	if ((nick = next_arg(args, &args)))
	{
		while ((n = next_in_comma_list(nick, &nick)))
		{
			if (!n || !*n)
				break;
			send_ncommand(numeric, "%s \"%s\"", n, args && *args ? args : empty_string);
		}
	}
}

BUILT_IN_COMMAND(send_muzzle)
{
char *nick, *n;
	if ((nick = next_arg(args, &args)))
	{
		while ((n = next_in_comma_list(nick, &nick)))
		{
			if (!n || !*n)
				break;
			send_ncommand(numeric, "%s \"%s\"", n, args && *args ? args : empty_string);
		}
	}
}

BUILT_IN_COMMAND(send_chanlevel)
{
char *nick, *n, *level;
	if ((nick = next_arg(args, &args)))
	{
		level = next_arg(args, &args);
		if (!level || !*level)
		{
			say("Need to specify a Level");
			return;
		}
		while ((n = next_in_comma_list(nick, &nick)))
		{
			if (!n || !*n)
				break;
			send_ncommand(numeric, "%s %s", n, level);
		}
	}
}

BUILT_IN_COMMAND(send_unmuzzle)
{
char *nick, *n;
	while ((nick = next_arg(args, &args)))
	{
		while ((n = next_in_comma_list(nick, &nick)))
		{
			if (!n || !*n)
				break;
			send_ncommand(numeric, "%s", n);
		}
	}
}


BUILT_IN_COMMAND(send_kick)
{
char *nick = NULL, *n, *chan = NULL;
	if ((chan = next_arg(args, &args)))
	{
		if (!find_in_list((List **)&current_window->nchannels, chan, 0))
		{
			nick = chan;
			chan = current_window->current_channel;
		}
	}
	else
		nick = next_arg(args, &args);
	if (chan && nick)
	{
		while ((n = next_in_comma_list(nick, &nick)))
		{
			if (!n || !*n)
				break;
			send_ncommand(numeric, "%s %s \"%s\"", chan, n, args && *args ? args : empty_string);
		}
	}
}

BUILT_IN_COMMAND(send_allcomm)
{
	if (args && *args)
		send_ncommand(numeric, "%s", args);
}

BUILT_IN_COMMAND(exec_cmd)
{
	char	buffer[BIG_BUFFER_SIZE + 1];
	
	snprintf(buffer, BIG_BUFFER_SIZE, "%s %s", command, args);
	execcmd(NULL, buffer, subargs, helparg, 0);
}

BUILT_IN_COMMAND(nap_scan)
{
ChannelStruct *ch;
char *chan = NULL;
int sort_type = NORMAL_SORT;
	if (!args || !*args)
		chan = current_window->current_channel;
	else
	{
		char *arg;
		while ((arg = next_arg(args, &args)))
		{
			if (!my_stricmp(arg, "-sort"))
			{
				arg = next_arg(args, &args);
				if (!my_stricmp(arg, "songs"))
					sort_type = SONG_SORT;
				else if (!my_stricmp(arg, "speed"))
					sort_type = SPEED_SORT;
			}
			else
				chan = arg;
		}
	}
	if (!chan || !*chan)
		return;
	if ((ch = (ChannelStruct *)find_in_list((List **)&current_window->nchannels, chan, 0)))
		name_print(chan, ch->nicks, 0, sort_type);
}

BUILT_IN_COMMAND(nap_search)
{
char buff[BIG_BUFFER_SIZE+1];
char s_buff[BIG_BUFFER_SIZE+1];
int n = 0;

int bitrate = 0;
unsigned int freq = 0;
int linespeed = 0;
int bit_int = -1;
int freq_int = -1;
int line_int = -1;
int do_type = 0;
int buf_len = 0;
char *search_param[] = { "EQUAL TO", "AT BEST", "AT LEAST", ""};
int soundex = 0;
char *sound_ex[] = { "FILENAME", "SOUNDEX", "" };
char any[] = "ANY";
char *type = NULL;

	if (!args || !*args)
	{
		display_list(file_search);
		return;
	}
	if (get_server_search(from_server))
	{
		if (args && !my_strnicmp(args, "-end", 4))
			set_server_search(from_server, 0);
		else
			say("Already a search in progress");
		return;
	}
	if (command && !my_stricmp(command, "soundex"))
		soundex++;
	while (args && *args == '-')
	{
		char *cmd, *val;
		unsigned int value = 0;
		cmd = next_arg(args, &args);
		val = next_arg(args, &args);
		value = my_atol(val);
		if (!my_strnicmp(cmd, "-type", 4))
		{
			if (!(type = val))
			{
				say("You must specify a type [video/image/audio/application/text]");
				break;
			}
			do_type = 1;
			continue;
		}
		else if (!my_strnicmp(cmd, "-any", 4))
		{
			type = any;
			do_type = 1;
			continue;
		}
		if (!my_strnicmp(cmd, "-maxresults", 4))
		{
			if (!args)
			{
				say("Default Max Results %d", get_int_var(MAX_RESULTS_VAR));
				return;
			}
			set_int_var(MAX_RESULTS_VAR, value);
			continue;
		}
		if (strstr(cmd, "bitrate"))
		{
			int br[] = {20, 24, 32, 48, 56, 64, 98, 112, 128, 160, 192, 256, 320, -1 };
			int o;
			for (o = 0; br[o] != -1; o++)
				if (br[o] == value)
					break;
			if (br[o] == -1)
			{
				say("Allowed Bitrates 20, 24, 32, 48, 56, 64, 98, 112, 128, 160, 192, 256, 320");
				return;
			}
			if (!my_strnicmp(cmd, "-bitrate", 4))
				bitrate = value, bit_int = 0;
			else if (!my_strnicmp(cmd, "-minbitrate", 4))
				bitrate = value, bit_int = 2;
			else if (!my_strnicmp(cmd, "-maxbitrate", 4))
				bitrate = value, bit_int = 1;
		} 
		else if (strstr(cmd, "freq"))
		{
			long fr[] = {8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000, -1};
			int o;
			for (o = 0; fr[o] != -1; o++)
				if (fr[o] == value)
					break;
			if (fr[o] == -1)
			{
				say("Allowed Freq 8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000");
				return;
			}
			if (!my_strnicmp(cmd, "-maxfreq", 4))
				freq = value, freq_int = 1;
			else if (!my_strnicmp(cmd, "-minfreq", 4))
				freq = value, freq_int = 2;
			else if (!my_strnicmp(cmd, "-freq", 4))
				freq = value, freq_int = 0;
		}
		else if (strstr(cmd, "line"))
		{
			if (value < 0 || value > MAX_SPEED)
			{
				say("Allowed linespeed 0-%d", MAX_SPEED);
				return;
			}
			if (!my_strnicmp(cmd, "-maxlinespeed", 4))
				linespeed = value, line_int = 1;
			else if (!my_strnicmp(cmd, "-minlinespeed", 4))
				linespeed = value, line_int = 2;
			else if (!my_strnicmp(cmd, "-linespeed", 4))
				linespeed = value, line_int = 0;
		}
		else if (strstr(cmd, "-end"))
		{
			set_server_search(from_server, 0);
			return;
		}
	}
	

	if (!args || !*args)
		return;

	clear_filelist(&file_search);
	if (soundex)
		compute_soundex(s_buff, sizeof(s_buff), args);

	if (do_type && type)
	{
		sprintf(buff, "TYPE %s ", type);
		buf_len = strlen(buff);
	}	

	if ((n = get_int_var(MAX_RESULTS_VAR)))
		sprintf(buff + buf_len, "%s CONTAINS \"%s\" MAX_RESULTS %d", sound_ex[soundex], soundex ? s_buff : lower(args), n);
	else
		sprintf(buff + buf_len, "%s CONTAINS \"%s\"", sound_ex[soundex], soundex ? s_buff : lower(args));

	if (!do_type && !type)
	{
		if (bitrate && (bit_int != -1))
			strmopencat(buff, BIG_BUFFER_SIZE, " BITRATE \"", search_param[bit_int], "\" \"", ltoa(bitrate), "\"", NULL);
		if (freq && (freq_int != -1))
			strmopencat(buff, BIG_BUFFER_SIZE, " FREQ \"", search_param[freq_int], "\" \"", ltoa(freq), "\"", NULL);
		if (linespeed && (line_int != -1))
			strmopencat(buff, BIG_BUFFER_SIZE, " LINESPEED \"", search_param[line_int], "\" ", ltoa(linespeed), NULL);
	}
	if (do_type)	
	{
		if (do_hook(SEARCH_BEGIN_LIST, "%s", buff))
			say("* Searching for type [%s] %s %s", type, args, soundex ? s_buff: "");
	}
	else
		if (do_hook(SEARCH_BEGIN_LIST, "%s", buff))
			say("* Searching for %s %s", args, soundex ? s_buff: "");
	send_ncommand(CMDS_SEARCH, "%s", buff);
	set_server_search(from_server, 1);
}



BUILT_IN_COMMAND(ignore_user)
{
IgnoreStruct *new;
char *nick;
IgnoreStruct **todo = &ignores;
	if (command && !my_stricmp(command, "CIGNORE"))
		todo = &cignores;
	if (!args || !*args)
	{
		char buffer[BIG_BUFFER_SIZE+1];
		int cols = get_int_var(NAMES_COLUMNS_VAR);
		int count = 0;
		int buf_len;
		
		if (!cols)
			cols = 1;
		*buffer = 0;
		say("Ignore List:");
		for (new = *todo; new; new = new->next)
		{
			buf_len = strlen(buffer);
			sprintf(buffer+buf_len, get_string_var(NAMES_NICKCOLOR_VAR), new->nick); 
			strcat(buffer, space);
			if (count++ >= (cols - 1))
			{
				put_it("%s", buffer);
				*buffer = 0;
				count = 0;
			}
		}
		if (*buffer)
			put_it("%s", buffer);
		return;
	}
	while ((nick = new_next_arg(args, &args)))
	{
		if (*nick == '-')
		{
			nick++;
			if (!*nick)
				continue;
			if ((new = (IgnoreStruct *)remove_from_list((List **)todo, nick)))
			{
				new_free(&new->nick);
				new_free(&new);
				say("Removed %s from ignore list", nick);
			}
		}
		else
		{
			new = new_malloc(sizeof(IgnoreStruct));
			new->nick = m_strdup(nick);
			new->start = time(NULL);
			new->next = *todo;
			*todo = new;
			say("Added %s to ignore list", new->nick);
		}
	}
	return;
}

BUILT_IN_COMMAND(server_ignore)
{
IgnoreStruct *new;
char *nick;
	if (!args || !*args)
	{
		say("Server Ignore List:");
		for (new = signores; new; new = new->next)
			put_it("\"%s\"", new->nick);
		return;
	}
	while ((nick = new_next_arg(args, &args)))
	{
		if (*nick == '-')
		{
			nick = new_next_arg(args, &args);
			if (!nick || !*nick)
				continue;
			if ((new = (IgnoreStruct *)remove_from_list((List **)&signores, nick)))
			{
				new_free(&new->nick);
				new_free(&new);
				say("Removed \"%s\" from server ignore list", nick);
			}
		}
		else
		{
			new = new_malloc(sizeof(IgnoreStruct));
			new->nick = m_strdup(nick);
			new->start = time(NULL);
			new->next = signores;
			signores = new;
			say("Added \"%s\" to server ignore list", new->nick);
		}
	}
	return;
}



BUILT_IN_COMMAND(window_serv)
{
	window_server(current_window, &args, NULL);
}

static void real_quit(char *dummy, char *ptr)
{
	if (ptr && *ptr && (toupper(*ptr) == 'Y'))
		nap_exit(1, NULL, NULL);
	bitchsay("Good Choice. Not Quitting");
}

BUILT_IN_COMMAND(napquit)
{
	if (!files_in_progress(NULL, -1))
		nap_exit(1, NULL, NULL);
	glist(NULL, NULL, NULL, NULL, 0);
	add_wait_prompt("Active File\'s. Really Quit [y/N] ? ", real_quit, NULL, WAIT_PROMPT_LINE, 1);
}

BUILT_IN_COMMAND(partcmd)
{
char *cmd;
ChannelStruct *ch = NULL;
	cmd = next_arg(args, &args);
	if (cmd)
	{
		if ((ch = (ChannelStruct *)remove_from_list((List **)&current_window->nchannels, cmd)))
			send_ncommand(CMDS_PART, "%s", cmd);
	}
	else if (current_window->current_channel)
	{
		if ((ch = (ChannelStruct *)remove_from_list((List **)&current_window->nchannels, current_window->current_channel)))
			send_ncommand(CMDS_PART, "%s", current_window->current_channel);
	}
	if (ch)
	{
		say("Parting %s", ch->channel);
		free_nicks(ch);
		if (current_window->current_channel && !my_stricmp(ch->channel, current_window->current_channel))
		{
			if (ch->next)
				malloc_strcpy(&current_window->current_channel, ch->next->channel);
			else if (current_window->nchannels)
				malloc_strcpy(&current_window->current_channel, current_window->nchannels->channel);
			else
				new_free(&current_window->current_channel);
		}
		new_free(&ch->channel);
		new_free(&ch->topic);
		new_free(&ch);
	}
	update_window_status(current_window, 0);
	update_input(UPDATE_ALL);	
}

BUILT_IN_COMMAND(joincmd)
{
char *buffer;
Window *tmp = NULL;
ChannelStruct *df = NULL;
char *ch;
	if ((buffer = next_arg(args, &args)))
	{
		while ((ch = next_in_comma_list(buffer, &buffer)))
		{
			if (!ch || !*ch)
				break;
			while (traverse_all_windows(&tmp))
				if ((df = (ChannelStruct *)find_in_list((List **)&tmp->nchannels, ch, 0)))
					break;
			if (!df)
			{
				send_ncommand(CMDS_JOIN, "%s", ch);
				add_waiting_channel(current_window, ch);
			} 
			else if (!tmp->bind_channel || my_stricmp(tmp->bind_channel, df->channel))
			{
				df = (ChannelStruct *)remove_from_list((List **)&tmp->nchannels, df->channel);
				add_to_list((List **)&current_window->nchannels, (List *)df);
				if (tmp->current_channel && !my_stricmp(df->channel, tmp->current_channel))
				{
					new_free(&tmp->current_channel);
					if (tmp->nchannels)
						malloc_strcpy(&tmp->current_channel, tmp->nchannels->channel);
				}
				malloc_strcpy(&current_window->current_channel, df->channel);
			}
			else
				say("%s is bound to another window.", ch);
		}
		update_window_status(current_window, 0);
		update_input(UPDATE_ALL);	
	}
	else
		switch_channels(0, NULL);
}




struct target_type
{
	char *nick_list;
	char *message;
	int  hook_type;
	char *format;
	unsigned long level;
	int hook;
};




void 	send_text(const char *nick_list, const char *text, char *command, int hook, int log)
{
	int	i, 
		old_window_display = window_display;
	char	*current_nick,
		*next_nick,
		*line;
	        
struct target_type target[2] = 
{	
{NULL, NULL, CMDS_SENDMSG,	FORMAT_SENDMSG,	LOG_MSG,	SEND_MSG_LIST },
{NULL, NULL, CMDS_SEND,		FORMAT_PUBLIC,	LOG_PUBLIC,	SEND_PUBLIC_LIST },
};
	
	if (!nick_list || from_server == -1)
		return;
	next_nick = LOCAL_COPY(nick_list);
		
	while ((current_nick = next_nick))
	{
		if ((next_nick = strchr(current_nick, ',')))
			*next_nick++ = 0;

		if (!*current_nick)
			continue;

		if (*current_nick == '%')
		{
			if ((i = get_process_index(&current_nick)) == -1)
				say("Invalid process specification");
			else
				text_to_process(i, text, 1);
		}
		/*
		 * This test has to be here because it is legal to
		 * send an empty line to a process, but not legal
		 * to send an empty line anywhere else.
		 */
		else if (!text || !*text)
			;
		else if (*current_nick == '"')
			send_ncommand(CMDS_SEND, "%s %s", current_window->current_channel, text);
		else if (*current_nick == '/')
		{
			line = m_opendup(current_nick, space, text, NULL);
			parse_command(line, 0, empty_string);
			new_free(&line);
		}
		else
		{
			if (!command && find_in_list((List **)&current_window->nchannels, current_nick, 0))
			{
				i = 1;
				do_hook(target[i].hook, "%s %s", current_nick, text);
			}
			else
			{
				i = 0;
				addtabkey(current_nick, "msg", (char *)text);
			}
			send_ncommand(target[i].hook_type, "%s %s", current_nick, text);
			if (!i)
				do_hook(target[i].hook, "%s %s", current_nick, text);
			m_s3cat(&target[i].nick_list, ",", current_nick);
			target[i].message = (char *)text;
		}
	}
	
	if (target[0].nick_list && target[0].message)
	{
		const char *old_mf;
		unsigned long old_ml;
				
		save_display_target(&old_mf, &old_ml);
		set_display_target(target[0].nick_list, target[0].level);
		if (do_hook(target[0].hook, "%s %s", target[0].nick_list, target[0].message))
			put_it(target[0].format, target[0].nick_list, target[0].message);
		new_free(&target[0].nick_list);
		target[0].message = NULL;
		restore_display_target(old_mf, old_ml);
	}
	window_display = old_window_display;
}

void	redirect_text (int to_server, const char *nick_list, const char *text, int hook, int log)
{
	int 	old_from_server = from_server;
	from_server = to_server;
	send_text(nick_list, text, NULL, hook, log);
	from_server = old_from_server;
}

BUILT_IN_COMMAND(privmsg)
{
char *nick;
	if ((nick = next_arg(args, &args)))
		send_text(nick, args, command, window_display, 1);
}

BUILT_IN_COMMAND(do_send_text)
{
	char	*tmp;
	char	*cmd = NULL;
	
	if (command)
		tmp = get_current_channel_by_refnum(0);
	else
		tmp = get_target_by_refnum(0);
	if (cmd)
	{
		if (!my_stricmp(cmd, "SAY") || !my_stricmp(cmd, "MSG"))
			send_text(tmp, args, NULL, 1, 1);
		else
			send_text(tmp, args, NULL, 1, 1);					
	}
	else
		send_text(tmp, args, NULL, 1, 1);
}



IrcCommand *find_command(char *com, int *cnt)
{
	IrcCommand *retval;
	int loc;

	/*
	 * As a special case, the empty or NULL command is send_text.
	 */
	if (!com || !*com)
	{
		*cnt = -1;
		return irc_command;
	}

	retval = (IrcCommand *)find_fixed_array_item ((void *)irc_command, sizeof(IrcCommand), NUMBER_OF_COMMANDS + 1, com, cnt, &loc);
	return retval;
}

struct load_info
{
	char 	*filename;
	int	line;
	int	start_line;
} load_level[MAX_LOAD_DEPTH] = {{ NULL, 0 }};

void dump_load_stack (int onelevel)
{
	int i = load_depth;

	if (i == -1)
		return;

	yell("Right before line [%d] of file [%s]", load_level[i].line,
					  load_level[i].filename);

	if (!onelevel)
	{
		while (--i >= 0)
		{
			yell("Loaded right before line [%d] of file [%s]", 
				load_level[i].line, load_level[i].filename);
		}
	}
	return;
}

#if 0
void parse_line(char *name, char *org, const char *args, int hist, int append, int local)
{
char	*line,
	*s,
	*t;

	line = LOCAL_COPY(org);
	
	if (load_depth != -1)
	{
		parse_command(line, hist, (char *)args);
	}
	else
	{
		while ((s = line))
		{
			if ((t = sindex(line, "\r\n")))
			{
				*t++ = '\0';
				line = t;
			}
			else
				line = NULL;
			parse_command(s, hist, (char *)args);
		}
	}
}
#endif

void parse_line (const char *name, char *org_line, const char *args, int hist_flag, int append_flag, int handle_local)
{
	char	*line = NULL,
			*stuff,
			*s,
			*t;
	int	args_flag = 0,
		die = 0;

	

	if (handle_local)
		make_local_stack((char *)name);

	line = LOCAL_COPY(org_line);

	if (!*org_line)
		do_send_text(NULL, empty_string, empty_string, NULL, 0);
	else if (args) do
	{
		while (*line == '{') 
               	{
                       	if (!(stuff = next_expr(&line, '{'))) 
			{
				error("Unmatched {");
				destroy_local_stack();
                               	return;
                        }
       	                parse_line(name, stuff, args, hist_flag, append_flag, handle_local);

			if ((will_catch_break_exceptions && break_exception) ||
			    (will_catch_return_exceptions && return_exception) ||
			    (will_catch_continue_exceptions && continue_exception))
			{
				die = 1;
				break;
			}

			while (line && *line && ((*line == ';') || (my_isspace(*line))))
				*line++ = '\0';
		}

		if (!line || !*line || die)
			break;

		stuff = expand_alias(line, args, &args_flag, &line);
		if (!line && append_flag && !args_flag && args && *args)
			m_3cat(&stuff, space, args);

		parse_command(stuff, hist_flag, (char *)args);
       	        new_free(&stuff);

		if ((will_catch_break_exceptions && break_exception) ||
		    (will_catch_return_exceptions && return_exception) ||
		    (will_catch_continue_exceptions && continue_exception))
			break;
	} while (line && *line);
        else
	{
		if (load_depth != -1) /* CDE should this be != 1 or > 0 */
			parse_command(line, hist_flag, (char *)args);
		else
		{
			while ((s = line))
			{
				if ((t = sindex(line, "\r\n")))
				{
					*t++ = '\0';
					line = t;
				}
				else
					line = NULL;
				parse_command(s, hist_flag, (char *)args);

				if ((will_catch_break_exceptions && break_exception) ||
				    (will_catch_return_exceptions && return_exception) ||
				    (will_catch_continue_exceptions && continue_exception))
					break;

			}
		}
	}
	if (handle_local)
		destroy_local_stack();
	return;
}

int parse_command(register char *line, int hist_flag, char *sub_args)
{
char	*cmdchars,
	*this_cmd,
	*rest,
	*com,
	*cline;
int	add_to_hist,
	display,
	noisy = 1,
	args_flag = 0,
	cmdchar_used = 0,
	old_display_var;

	if (!(cmdchars = get_string_var(CMDCHARS_VAR)))
		cmdchars = DEFAULT_CMDCHARS;


	this_cmd = LOCAL_COPY(line);

	add_to_hist = 1;
	display = window_display;
	old_display_var = (unsigned) get_int_var(DISPLAY_VAR);

	for ( ;*line;line++)
	{
		if (*line == '^' && (!hist_flag || cmdchar_used))
		{
			if (!noisy)
				break;
			noisy = 0;
		}
		else if ((!hist_flag && *line == '/') || strchr(cmdchars, *line))
		{
			cmdchar_used++;
			if (cmdchar_used > 2)
				break;
		}
		else
			break;
	}

	com = line;
	if (!noisy)
		window_display = 0;
			
	if (hist_flag && !cmdchar_used && !get_int_var(COMMAND_MODE_VAR))
	{
		send_text(get_target_by_refnum(0), line, NULL, 0, 0);
		if (hist_flag && add_to_hist)
			add_to_history(this_cmd);
	}
	else if (*com == '\'' && get_int_var(COMMAND_MODE_VAR))
	{
		send_text(NULL, line+1, NULL, 0, 0);
		if (hist_flag && add_to_hist)
			add_to_history(this_cmd);
	}
	else if ((*com == '@') || (*com == '('))
	{
		/* This kludge fixes a memory leak */
		char	*tmp;
		char	*my_line = LOCAL_COPY(line); 
		char	*l_ptr;
		/*
		 * This new "feature" masks a weakness in the underlying
		 * grammar that allowed variable names to begin with an
		 * lparen, which inhibited the expansion of $s inside its
		 * name, which caused icky messes with array subscripts.
		 *
		 * Anyhow, we now define any commands that start with an
		 * lparen as being "expressions", same as @ lines.
		 */
		if (*com == '(')
		{
			if ((l_ptr = MatchingBracket(my_line + 1, '(', ')')))
				*l_ptr++ = 0;
		}

		if ((tmp = parse_inline(my_line + 1, sub_args, &args_flag)))
			new_free(&tmp);

		if (hist_flag && add_to_hist)
			add_to_history(this_cmd);
	}
	else
	{
		char	*alias = NULL,
			*alias_name = NULL;
		int	alias_cnt = 0;
		void	*arglist = NULL;
					
		if ((rest = strchr(line, ' ')))
		{
			cline = alloca((rest - line) + 1);
			strmcpy(cline, line, rest - line);
			rest++;
		}
		else
		{	
			cline = LOCAL_COPY(line);
			rest = empty_string;
		}

		upper(cline);

		if (cmdchar_used < 2)
			alias = get_cmd_alias(cline, &alias_cnt, &alias_name, &arglist);

		if (alias && alias_cnt < 0)
		{
			if (hist_flag && add_to_hist)
				add_to_history(this_cmd);
			call_user_alias(alias_name, alias, rest, arglist);
			new_free(&alias_name);
			goto end_parse;
		}

		if (*cline == '!')
		{
			if ((cline = do_history(cline + 1, rest)) != NULL)
			{
				set_input(cline);
				update_input(UPDATE_ALL);
				new_free(&cline);
			}
			else
				set_input(empty_string);
		}
		else
		{
			char unknown[] = "Unknown command:";
			int cmd_cnt = 0;
			IrcCommand      *command = NULL;
		
			if (hist_flag && add_to_hist)
				add_to_history(this_cmd);
			command = find_command(cline, &cmd_cnt);

			if (cmd_cnt < 0 || (alias_cnt == 0 && cmd_cnt == 1))
			{
				if (rest && !my_strnicmp(rest, "-help", 3))
				{
					if ((command->flag & INTERNAL_HELP) == INTERNAL_HELP)
						command->func(command->server_func, rest, sub_args, command->help, 0);
					else
						bitchsay("Usage: /%s %s", cline, command->help? command->help:"Undocumented");
				}
				else if ((command->flag & SERVERREQ) && (from_server == -1))
					say("Try connecting to a server first");
				else if (command->func)
					command->func(command->server_func, rest, sub_args, command->help, command->numeric);
			}
			else if ((alias_cnt == 1 && cmd_cnt == 1 && (!strcmp(alias_name, command->name))) ||
				    (alias_cnt == 1 && cmd_cnt == 0))
			{
				will_catch_return_exceptions++;
				parse_line(alias_name, alias, rest, 0, 1, 1);
				will_catch_return_exceptions--;
				return_exception = 0;
			}
			else if (from_server != -1 && !my_stricmp(get_server_nickname(from_server), cline))
				send_me(NULL, rest, empty_string, NULL, 0);
			else if (cmd_cnt > 1)
				bitchsay("Ambigous command: %s", cline);
			else if (cmd_cnt == 0)
				bitchsay("%s %s", unknown, cline);
		}	
		if (alias)
			new_free(&alias_name);
	}

end_parse:

	if (old_display_var != get_int_var(DISPLAY_VAR))
		window_display = get_int_var(DISPLAY_VAR);
	else
		window_display = display;
/*	reset_display_target();*/
	return 0;
}

void command_completion(char unused, char *not_used)
{
	int	do_aliases = 1, 
		do_functions = 1;
	int	cmd_cnt = 0,
		alias_cnt = 0,
		function_cnt = 0,
		i,
		c;

	char	**aliases = NULL;
	char	**functions = NULL;

	char	*line = NULL,
		*com,
		*cmdchars,
		*rest,
		firstcmdchar[2] = "/";
IrcCommand	*command;
	char	buffer[BIG_BUFFER_SIZE + 1];
	
	
	malloc_strcpy(&line, get_input());
	if ((com = next_arg(line, &rest)) != NULL)
	{
		if (!(cmdchars = get_string_var(CMDCHARS_VAR)))
			cmdchars = DEFAULT_CMDCHARS;
		if (*com == '/' || strchr(cmdchars, *com))
		{
			*firstcmdchar = *cmdchars;
			com++;
			if (*com && strchr(cmdchars, *com))
			{
				do_aliases = 0;
				do_functions = 0;
				alias_cnt = 0;
				function_cnt = 0;
				com++;
			}
			else if (*com && strchr("$", *com))
			{
				do_aliases = 0;
				alias_cnt = 0;
				do_functions = 1;
				com++;
			} else
				do_aliases = do_functions = 1;

			upper(com);
			if (do_aliases)
				aliases = glob_cmd_alias(com, &alias_cnt);

			if (do_functions)
				functions = get_builtins(com, &function_cnt);

			if ((command = find_command(com, &cmd_cnt)) != NULL)
			{
				if (cmd_cnt < 0)
					cmd_cnt *= -1;
				/* special case for the empty string */
				if (!*command->name)
				{
					command++;
					cmd_cnt = NUMBER_OF_COMMANDS;
				}
			}
			if ((alias_cnt == 1) && (cmd_cnt == 0))
			{
				snprintf(buffer, BIG_BUFFER_SIZE, "%s%s %s", firstcmdchar, *aliases, rest);
				set_input(buffer);
				new_free((char **)aliases);
				new_free((char **)&aliases);
				update_input(UPDATE_ALL);
			}
			else if (((cmd_cnt == 1) && (alias_cnt == 0)) ||
			    (((cmd_cnt == 1) && (alias_cnt == 1) &&
			    !strcmp(aliases[0], command[0].name))))
			{
				snprintf(buffer, BIG_BUFFER_SIZE, "%s%s %s", firstcmdchar,
					command[0].name, rest);
				set_input(buffer);
				update_input(UPDATE_ALL);
			}
			else
			{
				*buffer = 0;
				if (command)
				{
					int buf_len;
					*buffer = 0;
					c = 0;
					for (i = 0; i < cmd_cnt; i++)
					{
						if (i == 0)
							bitchsay("Commands:");
						buf_len = strlen(buffer);
						sprintf(buffer+buf_len, "%15s", command[i].name);
						if (++c == 5)
						{
							put_it("%s", buffer);
							*buffer = 0;
							c = 0;
						}
					}
					if (*buffer)
						put_it("%s", buffer);
				}
				if (aliases)
				{
					int buf_len = 0;
					*buffer = 0;
					c = 0;
					for (i = 0; i < alias_cnt; i++)
					{
						if (i == 0)
							bitchsay("Aliases:");
						buf_len = strlen(buffer);
						sprintf(buffer+buf_len, "%15s", aliases[i]);
						if (++c == 5)
						{
							put_it("%s", buffer);
							*buffer = 0;
							c = 0;
						}
						new_free(&(aliases[i]));
					}
					if (*buffer)
						put_it("%s", buffer);
					new_free((char **)&aliases);
				}
				if (functions)
				{
					int buf_len = 0;
					*buffer = 0;
					c = 0;
					for (i = 0; i < function_cnt; i++)
					{
						if (i == 0)
							bitchsay("Functions:");
						buf_len = strlen(buffer);
						sprintf(buffer+buf_len, "%15s", functions[i]);
						if (++c == 5)
						{
							put_it("%s", buffer);
							*buffer = 0;
							c = 0;
						}
						new_free(&(functions[i]));
					}
					if (*buffer)
						put_it("%s", buffer);
					new_free((char **)&functions);
				}
				if (!*buffer)
					term_beep();
			}
		}
		else
			term_beep();
	}
	else
		term_beep();
	new_free(&line);
}


BUILT_IN_COMMAND(load)
{
	FILE	*fp;
	char	*filename,
		*expanded = NULL;
	int	flag = 0;
        int     paste_level = 0;
	register char	*start;
	char	*current_row = NULL;
#define MAX_LINE_LEN 5 * BIG_BUFFER_SIZE
	char	buffer[MAX_LINE_LEN + 1];
	int	no_semicolon = 1;
	char	*irc_path;
	int	display = window_display;
        int     ack = 0;

	
	if (!(irc_path = get_string_var(LOAD_PATH_VAR)))
	{
		bitchsay("LOAD_PATH has not been set");
		return;
	}

	if (++load_depth == MAX_LOAD_DEPTH)
	{
		load_depth--;
		bitchsay("No more than %d levels of LOADs allowed", MAX_LOAD_DEPTH);
		return;
	}

	display = window_display;
	window_display = 0;
	status_update(0);

	/* 
	 * We iterate over the whole list -- if we use the -args flag, the
	 * we will make a note to exit the loop at the bottom after we've
	 * gone through it once...
	 */
	while (args && *args && (filename = next_arg(args, &args)))
	{
		/* 
		   If we use the args flag, then we will get the next
		   filename (via continue) but at the bottom of the loop
		   we will exit the loop 
		 */
		if (!my_strnicmp(filename, "-args", strlen(filename)))
		{
			flag = 1;
			continue;
		}
#if 0
		if (!end_strcmp(filename, ".tcl", 4))
		{
#ifdef WANT_TCL
			if (Tcl_EvalFile(tcl_interp, filename) != TCL_OK)
				error("Unable to load filename %s[%s]", filename, tcl_interp->result);
#endif
			continue;
		}
#endif
		if (!(expanded = expand_twiddle(filename)))
		{
			error("Unknown user for file %s", filename);
			continue;
		}

		if (!(fp = uzfopen(&expanded, irc_path, 0)))
		{
			int owc = window_display;
			/* uzfopen emits an error if the file
			 * is not found, so we dont have to. */
			window_display = 1;
#if 0
#ifdef WANT_DLL
			if (expanded)
			{
				dll_load(NULL, expanded, NULL, NULL);
				new_free(&expanded);
				window_display = owc;
				continue;
			}
#endif
#endif
			new_free(&expanded);
			window_display = owc;
			continue;
		}

		if (command && *command == 'W')
		{
			yell ("%s", expanded);
			if (fp)
				fclose (fp);
			new_free(&expanded);
			continue;
		}
/* Reformatted by jfn */
/* *_NOT_* attached, so dont "fix" it */
		{
		int	in_comment 	= 0;
		int	comment_line 	= -1;
		int 	paste_line	= -1;

		current_row = NULL;
		load_level[load_depth].filename = expanded;
		load_level[load_depth].line = 1;
                                
		for (;;load_level[load_depth].line++)
		{
			int len;
			register char *ptr;
			
			if (!(fgets(buffer,MAX_LINE_LEN, fp)))
				break;

			for (start = buffer; my_isspace(*start); start++)
				;
			if (!*start || *start == '#')
				continue;

			len = strlen(start);

			/*
			 * this line from stargazer to allow \'s in scripts for continued
			 * lines <spz@specklec.mpifr-bonn.mpg.de>
			 *  If we have \\ at the end of the line, that
			 *  should indicate that we DONT want the slash to 
			 *  escape the newline (hop)
			 *  We cant just do start[len-2] because we cant say
			 *  what will happen if len = 1... (a blank line)
			 *  SO.... 
			 *  If the line ends in a newline, and
			 *  If there are at least 2 characters in the line
			 *  and the 2nd to the last one is a \ and,
			 *  If there are EITHER 2 characters on the line or
			 *  the 3rd to the last character is NOT a \ and,
			 *  If the line isnt too big yet and,
			 *  If we can read more from the file,
			 *  THEN -- adjust the length of the string
			 */

			while ( (start[len-1] == '\n') && 
				(len >= 2 && start[len-2] == '\\') &&
				(len < 3 || start[len-3] != '\\') && 
				(len < MAX_LINE_LEN) && 
				(fgets(&(start[len-2]), MAX_LINE_LEN - len, fp)))
			{
				len = strlen(start);
				load_level[load_depth].line++;
			}

			if (start[len - 1] == '\n')
				start[--len] = 0;
			if (start[len-1] == '\r')
				start[--len] = 0;

			while (start && *start)
			{
				char    *optr = start;

				/* Skip slashed brackets */
				while ((ptr = sindex(optr, "{};/")) && 
				      ptr != optr && ptr[-1] == '\\')
					optr = ptr+1;

				/* 
				 * if no_semicolon is set, we will not attempt
				 * to parse this line, but will continue
				 * grabbing text
				 */
				if (no_semicolon)
					no_semicolon = 0;
				else if ((!ptr || (ptr != start || *ptr == '/')) && current_row)
				{
					if (!paste_level)
					{
						parse_line(NULL, current_row, flag ? args :get_int_var(INPUT_ALIASES_VAR) ?empty_string: NULL, 0, 0, 1);
						new_free(&current_row);
					}
					else if (!in_comment)
						malloc_strcat(&current_row, ";");
				}

				if (ptr)
				{
					char    c = *ptr;

					*ptr = '\0';
					if (!in_comment)
						malloc_strcat(&current_row, start);
					*ptr = c;

					switch (c)
					{
		/* switch statement tabbed back */
case '/' :
{
	/* If we're in a comment, any slashes that arent preceeded by
	   a star is just ignored (cause its in a comment, after all >;) */
	if (in_comment)
	{
		/* ooops! cant do ptr[-1] if ptr == optr... doh! */
		if ((ptr > start) && (ptr[-1] == '*'))
		{
			in_comment = 0;
			comment_line = -1;
		}
		else
			break;
	}
	/* We're not in a comment... should we start one? */
	else
	{
		/* COMMENT_BREAKAGE_VAR */
		if ((ptr[1] == '*') && ptr == start)
		{
			/* Yep. its the start of a comment. */
			in_comment = 1;
			comment_line = load_level[load_depth].line;
		}
		else
		{
			/* Its NOT a comment. Tack it on the end */
			malloc_strcat(&current_row, "/");

			/* Is the / is at the EOL? */
			if (ptr[1] == '\0')
			{
				/* If we are NOT in a block alias, */
				if (!paste_level)
				{
					/* Send the line off to parse_line */
					parse_line(NULL, current_row, flag ? args : get_int_var(INPUT_ALIASES_VAR) ? empty_string : NULL, 0, 0, 1);
					new_free(&current_row);
					ack = 0; /* no semicolon.. */
				}
				else
					/* Just add a semicolon and keep going */
					ack = 1; /* tack on a semicolon */
			}
		}


	}
	no_semicolon = 1 - ack;
	ack = 0;
	break;
}
case '{' :
{
	if (in_comment)
		break;

	/* If we are opening a brand new {} pair, remember the line */
	if (!paste_level)
		paste_line = load_level[load_depth].line;
		
	paste_level++;
	if (ptr == start)
		malloc_strcat(&current_row, " {");
	else
		malloc_strcat(&current_row, "{");
	no_semicolon = 1;
	break;
}
case '}' :
{
	if (in_comment)
		break;
        if (!paste_level)
		error("Unexpected } in %s, line %d", expanded, load_level[load_depth].line);
	else 
	{
        	--paste_level;

		if (!paste_level)
			paste_line = -1;
		malloc_strcat(&current_row, "}"); /* } */
		no_semicolon = ptr[1]? 1: 0;
	}
	break;
}
case ';' :
{
	if (in_comment)
		break;
	malloc_strcat(&current_row, ";");
	if (!ptr[1] && !paste_level)
	{
		parse_line(NULL, current_row, flag ? args : get_int_var(INPUT_ALIASES_VAR) ? empty_string : NULL, 0, 0, 1);
		new_free(&current_row);
	}
	else if (!ptr[1] && paste_level)
		no_semicolon = 0;
	else
		no_semicolon = 1;
	break;
}
	/* End of reformatting */
					}
					start = ptr+1;
				}
				else
				{
					if (!in_comment)
						malloc_strcat(&current_row, start);
					start = NULL;
				}
			}
		}
		if (in_comment)
			error("File %s ended with an unterminated comment in line %d", expanded, comment_line);
		if (current_row)
		{
			if (paste_level)
				error("Unexpected EOF in %s trying to match '[' at line %d",
						expanded, paste_line);
			else
				parse_line(NULL,current_row, flag ? args: get_int_var(INPUT_ALIASES_VAR) ? empty_string : NULL,0,0, 1);
			new_free(&current_row);
		}
		}
		new_free(&expanded);
		fclose(fp);
	}	/* end of the while loop that allows you to load
		   more then one file at a time.. */

	if (get_int_var(DISPLAY_VAR))
		window_display = display;

	status_update(1);
	load_depth--;
}


BUILT_IN_COMMAND(reload_save)
{
char *p = NULL;
char buffer[BIG_BUFFER_SIZE+1];

#ifdef WINNT
	snprintf(buffer, BIG_BUFFER_SIZE, "~/%s", version);
#else	
	snprintf(buffer, BIG_BUFFER_SIZE, "~/.%s", version);
#endif
	p = expand_twiddle(buffer);
	if (p && access(p, F_OK) != 0)
	{
		bitchsay("Created directory %s", p);
		mkdir(p, S_IWUSR|S_IRUSR|S_IXUSR);
	}
	new_free(&p);
#ifdef WINNT
	snprintf(buffer, BIG_BUFFER_SIZE, "~/%s/%s.sav", version, version);
#else
	snprintf(buffer, BIG_BUFFER_SIZE, "~/.%s/%s.sav", version, version);
#endif
	p = expand_twiddle(buffer);
	load(empty_string, p, empty_string, NULL, 0); /*CDE XXX p */
	new_free(&p);
}

void load_scripts(void)
{
	static int done = 0;
	char buffer[BIG_BUFFER_SIZE+1];
	int old_display = window_display;
	if (!done++)
	{
		window_display = 0;
#ifdef WINNT
		if (!access(bircrc_file, R_OK))
			load("LOAD", bircrc_file, empty_string, NULL, 0);
		else
		{
			char *p;
			strcpy(buffer, bircrc_file);
			if ((p = strrchr(buffer, '.')))
			{
				*p = '-';
				if (!access(buffer, R_OK))
					load("LOAD", buffer, empty_string, NULL, 0);
			}
		}
#else
		if (!access(bircrc_file, R_OK))
			load("LOAD", bircrc_file, empty_string, NULL, 0);
#endif
		sprintf(buffer, "%s/%s/%s", SCRIPT_PATH, version, version);
		load("LOAD", buffer, empty_string, NULL, 0);

		loading_savefile++;
		reload_save(NULL, NULL, empty_string, NULL, 0);
		loading_savefile--;
		window_display = old_display;
	}
}

BUILT_IN_COMMAND(whois)
{
	if (args && *args)
		whobase(args);
	else if (current_window->server > -1)
		whobase(get_server_nickname(current_window->server));
}

BUILT_IN_COMMAND(dnscmd)
{
	if (args && *args)
		dnsbase(args);
	else if (current_window->server > -1)
		dnsbase(get_server_nickname(current_window->server));
}


BUILT_IN_COMMAND(serverclose)
{
	window_discon(current_window, NULL, NULL);
}

BUILT_IN_COMMAND(hotlist)
{
NickStruct *new;
char *nick;
	if (!args || !*args)
	{
		say("Your Hotlist:");
		name_print(NULL, nap_hotlist, 1, 0);
		return;
	}
	while ((nick = next_arg(args, &args)))
	{
		if (!(*nick == '-'))
		{
			send_ncommand(CMDS_ADDHOTLIST, "%s", nick);
			if (!(new = (NickStruct *)find_in_list((List **)&nap_hotlist, nick, 0)))
			{
				new = new_malloc(sizeof(NickStruct));
				new->nick = m_strdup(nick);
				new->speed = -1;
				add_to_list((List **)&nap_hotlist, (List *)new);
			} else 
				say("%s is already on your Hotlist", nick);
		}
		else
		{
			nick++;
			if (*nick && (new = (NickStruct *)remove_from_list((List **)&nap_hotlist, nick)))
			{
				send_ncommand(CMDS_HOTLISTREMOVE, "%s", nick);
				say("Removing %s from your HotList", nick);
				new_free(&new->nick);
				new_free(&new);
			}
		}
	}
}

BUILT_IN_COMMAND(topic)
{
ChannelStruct *ch;
char *cmd;
	if (!args && !current_window && !current_window->current_channel)
		return;
	cmd = next_arg(args, &args);
	ch = (ChannelStruct *)find_in_list((List **)&current_window->nchannels, cmd ? cmd : current_window->current_channel ? current_window->current_channel : empty_string, 0);
	if (ch)
	{
		if (args && *args)
			send_ncommand(CMDS_TOPIC, "%s %s", ch->channel, args);
		else
			say("Topic for %s: %s", ch->channel, ch->topic);
	}
	else
		say("No Channel found %s", cmd ? cmd : empty_string);
}


BUILT_IN_COMMAND(ping)
{
char *cmd;
	if ((cmd = next_arg(args, &args)))
	{
		PingStruct *new;
		if (!(new = (PingStruct *)find_in_list((List **)&ping_time, cmd, 0)))
		{
			new = new_malloc(sizeof(PingStruct));
			new->nick = m_strdup(cmd);
			add_to_list((List **)&ping_time, (List *)new);
		}
		get_time(&new->start);
		send_ncommand(CMDS_PING, "%s %s", cmd, args ? args : empty_string);
	}
}

BUILT_IN_COMMAND(spingcmd)
{
char *cmd;
	if ((cmd = next_arg(args, &args)))
	{
		struct timeval tv;
		get_time(&tv);
		send_ncommand(CMDS_SPING, "%s %lu %lu", cmd, tv.tv_sec, tv.tv_usec);
	}
}

BUILT_IN_COMMAND(rawcmd)
{
char *cmd;
int x;
	if ((cmd = next_arg(args, &args)) && (x = my_atol(cmd)))
		send_ncommand(x, "%s", args);
}

BUILT_IN_COMMAND(nap_stats)
{
int i;
N_STATS *s_stats;
	say("Client Uptime is %s", convert_time(now - start_time));
	for (i = 0; i < server_list_size(); i++)
	{
		if ((s_stats = get_server_stats(i)) && s_stats->libraries)
			say("There are %d libraries with %d songs in %dgb on %s", s_stats->libraries, s_stats->songs, s_stats->gigs, get_server_name(i));
	}
	say("We are sharing %d for %4.2f%s", shared_stats.shared_files, _GMKv(shared_stats.shared_filesize), _GMKs(shared_stats.shared_filesize));
	say("There are %d files loaded with %4.2f%s", shared_stats.total_files, _GMKv(shared_stats.total_filesize), _GMKs(shared_stats.total_filesize));
	say("We have served %lu files and %4.2f%s", shared_stats.files_served, _GMKv(shared_stats.filesize_served), _GMKs(shared_stats.filesize_served));
	say("We have downloaded %lu files for %4.2f%s", shared_stats.files_received, _GMKv(shared_stats.filesize_received), _GMKs(shared_stats.filesize_received));
	say("The Highest download speed has been %4.2fK/s", _GMKv(shared_stats.max_downloadspeed));
	say("The Highest upload speed has been %4.2fK/s", _GMKv(shared_stats.max_uploadspeed));
	if (get_int_var(PTEST_VAR))
	{
		for (i = 0; i < server_list_size(); i++)
		{
			if (!is_connected(i))
				continue;
			s_stats = get_server_stats(i);
			say("%d total unreach. (%d pending / %d switched / %d zero'ed / %d bogus / %d dupes).",
			   s_stats->total_unreach_messages, s_stats->total_unreach_pending,
			   s_stats->total_unreach_real - s_stats->total_unreach_switch_to_zero,
			   s_stats->total_unreach_switch_to_zero, s_stats->total_unreach_bogus,
  			   s_stats->total_unreach_duplicates);
		}
	}
}

BUILT_IN_COMMAND(evalcmd)
{

	parse_line(NULL, args, subargs ? subargs : empty_string, 0, 0, 0);
}

BUILT_IN_COMMAND(query)
{
	window_query(current_window, &args, NULL);
	build_status(current_window, NULL, 0);
}

BUILT_IN_COMMAND(my_clear)
{
	char	*arg;
	int	all = 0,
		scrollback = 0,
		unhold = 0;

	
	while ((arg = next_arg(args, &args)) != NULL)
	{
		if (!my_strnicmp(arg+1, "A", 1))
			all = 1;
		else if (!my_strnicmp(arg+1, "U", 1))
			unhold = 1;
		else if (!my_strnicmp(arg+1, "S", 1))
			scrollback = 1;
	}
	if (all)
		clear_all_windows(unhold, scrollback);
	else
	{
		if (scrollback)
			clear_scrollback(get_window_by_refnum(0));
		if (unhold)
			hold_mode(NULL, OFF, 1);
		clear_window_by_refnum(0);
	}
	update_input(UPDATE_JUST_CURSOR);
}

BUILT_IN_COMMAND(relmcmd)
{
	if (args && *args)
	{
		if (!my_stricmp(args, "-clear"))
			clear_servermsg();
		else
			display_servermsgs();
	}
	else
		display_servermsgs();
}

BUILT_IN_COMMAND(queuecmd)
{
extern Server *server_list;
GetFile **queue = NULL, *tmp, *last;
int count = 1;
int delete = 0;
char *who = NULL;
	if (from_server == -1)
		return;
	if (server_list[from_server].users)
		queue = &server_list[from_server].users->Queued;
	while (args && *args)
	{
		who = next_arg(args, &args);
		if (!my_stricmp(who, "-remove"))
		{
			delete = 1;
			if (!(who  = next_arg(args, &args)))
				return;
		} else if (!my_stricmp(who, "-clear"))
			delete = -1;
	}
		if (queue && *queue)
		{
			say("Download Queue");
			for (tmp = *queue; tmp; tmp = last)
			{
				last = tmp->next;
				switch (delete)
				{
					case 1:
						if (!wild_match(who, tmp->nick) && !wild_match(who, tmp->filename))
							continue;
					case -1:
					{
						break_from_list((List **)queue, (List *)tmp);
						nap_finished_file(tmp->socket, PREMATURE_FINISH);
						count++;
						break;
					}
					default:
						put_it("%3d %3d %16s %s", count, now - tmp->addtime, tmp->nick, base_name(tmp->filename));
						count++;
						break;
				}
			}
		}
	if (delete && count)
		say("Removed %d entries from download queue", count);
}

BUILT_IN_COMMAND(echocmd)
{
int	owd = window_display,
	all_windows = 0,
	banner = 0,
	no_log = 0,
	more = 1,
	xtended = 0,
	old_und = 0,
	old_rev = 0,
	old_bold = 0,
	old_color = 0,
	old_blink = 0,
	old_ansi = 0;
unsigned long	lastlog_level = 0;
unsigned long	from_level = 0;
unsigned long	temp;

unsigned long	saved_level;
const char	*saved_from;
char 		*stuff = NULL,
		*flag_arg;
	

	window_display = 1;
	save_display_target(&saved_from, &saved_level);

	if (command && *command == 'X')
	{
		while (more && args && (*args == '-' || *args == '/'))
		{
			switch(toupper(args[1]))
			{
				case 'C':
				{
					next_arg(args, &args);
					target_window = current_window;
					break;
				}
				case 'L':
				{
					flag_arg = next_arg(args, &args);

					if (!(flag_arg = next_arg(args, &args)))
						break;
					if ((temp = parse_lastlog_level(flag_arg, 0)))
					{
						lastlog_level = 
							set_lastlog_msg_level(temp);
						from_level = message_from_level(temp);
					}
					break;
				}
				case 'W':
				{
					flag_arg = next_arg(args, &args);
					if (!(flag_arg = next_arg(args, &args)))
						break;
					if (isdigit(*flag_arg))
						target_window = get_window_by_refnum(my_atol(flag_arg));
					else
						target_window = get_window_by_name(flag_arg);
					break;
				}
				case 'T':
				{
					flag_arg = next_arg(args, &args);
					if (!(flag_arg = next_arg(args, &args)))
						break;
					target_window = get_window_target_by_desc(flag_arg);
					break;
				}
				case 'A':
				case '*':
				{
					next_arg(args, &args);
					all_windows = 1;
					break;
				}
				case 'X': /* X -- allow all attributes to be outputted */
				{
					next_arg(args, &args);

					old_und = get_int_var(UNDERLINE_VIDEO_VAR);
					old_rev = get_int_var(INVERSE_VIDEO_VAR);
					old_bold = get_int_var(BOLD_VIDEO_VAR);
					old_color = get_int_var(COLOR_VAR);
					old_blink = get_int_var(BLINK_VIDEO_VAR);
					old_ansi = get_int_var(DISPLAY_ANSI_VAR);

					set_int_var(UNDERLINE_VIDEO_VAR, 1);
					set_int_var(INVERSE_VIDEO_VAR, 1);
					set_int_var(BOLD_VIDEO_VAR, 1);
					set_int_var(COLOR_VAR, 1);
					set_int_var(BLINK_VIDEO_VAR, 1);
					set_int_var(DISPLAY_ANSI_VAR, 1);

					xtended = 1;
					break;
				}
				case 'B':
				{
					next_arg(args, &args);
					banner = 1;
					break;
				}
				case 'N':
				{
					next_arg(args, &args);
					no_log = 1;
					break;
				}
				case '-':
				{
					next_arg(args, &args);
					more = 0;
					break;					
				}
				default:
				{
					more = 0;
					break;
				}
			}
			if (!args)
				args = empty_string;				
		}
	}

	if (no_log)
		inhibit_logging = 1;
		 
	if (banner == 1)
	{
		malloc_strcpy(&stuff, numeric_banner(-current_numeric));
		if (*stuff)
		{
			m_3cat(&stuff, space, args);
			args = stuff;
		}
	} 
	else if (banner != 0)
		abort();
		
	if (all_windows == 1)
	{
		Window *win = NULL;
		while ((traverse_all_windows(&win)))
		{
			target_window = win;
			put_echo(args);
		}
	} 
	else if (all_windows != 0)
		abort();
	else
		put_echo(args);
	if (xtended)
	{
		set_int_var(UNDERLINE_VIDEO_VAR, old_und);
		set_int_var(INVERSE_VIDEO_VAR, old_rev);
		set_int_var(BOLD_VIDEO_VAR, old_bold);
		set_int_var(COLOR_VAR, old_color);
		set_int_var(BLINK_VIDEO_VAR, old_blink);
		set_int_var(DISPLAY_ANSI_VAR, old_ansi);
	}
	if (stuff) 
		new_free(&stuff);
	if (lastlog_level)
	{
		set_lastlog_msg_level(lastlog_level);
		message_from_level(from_level);
	}
	if (no_log)
		inhibit_logging = 0;
	set_display_target(saved_from, saved_level);
	window_display = owd;
}

BUILT_IN_COMMAND(beepcmd)
{
	term_beep();
}

BUILT_IN_COMMAND(nslookup)
{
#if defined(THREAD) && defined(WANT_NSLOOKUP)
char *host;
char *cmd = NULL;
	while ((host = next_arg(args, &args)))
	{
		if (*host == '-' || *host == '/')
		{
			host++;
			if (!my_stricmp(host, "cmd"))
			{
				if (!(cmd = next_expr(&args, '{')))
					say("Need {...} for -CMD argument");
				else
					host = next_arg(args, &args);
			}
			else
				continue;
		}
		if (!host)
			break;
		do_nslookup(NULL, host, cmd);
	}
#else
	say("This Command Disabled due to lack of Thread support");
#endif
}

BUILT_IN_COMMAND(ptestcmd)
{
#if defined(THREAD) && defined(WANT_PTEST)
char *arg = NULL, *host= NULL, *port = NULL;
char *cmd = NULL;
	if (!get_int_var(PTEST_VAR))
	{
		say("Enable PTEST before using");
		return;
	}
	while ((arg = next_arg(args, &args)))
	{
		if (*arg == '-' || *arg == '/')
		{
			arg++;
			if (!my_stricmp(arg, "cmd"))
			{
				if (!(cmd = next_expr(&args, '{')))
					say("Need {...} for -CMD argument");
				else
				{
					if (!(arg = next_arg(args, &args)))
						break;
				}
			}
			else
				continue;
		}
		if (strchr(arg, '.'))
		{
			char *p;
			host = arg;
			if ((p = strchr(host, ':')))
			{
				port = p;
				*port++ = 0;
			}	
		}
		else
			port = arg;
		if (host && port)
		{
			do_ptestcall(host, port, cmd);
			host = port = NULL;
		}
	}
#else
	say("This Command Disabled due to lack of Thread support");
#endif
}

BUILT_IN_COMMAND(mychdir)
{
	char	*arg,
		*expand;
	char buffer[BIG_BUFFER_SIZE + 1];

	
	*buffer = 0;
	if ((arg = new_next_arg(args, &args)) != NULL && *arg)
	{
		if ((expand = expand_twiddle(arg)) != NULL)
		{
			if (chdir(expand))
			{
				say("CD: %s %s", arg, strerror(errno));
				new_free(&expand);
				return;
			}
			new_free(&expand);
		}
		else
		{
			say("CD No such dir %s", arg);
			return;
		}
	}
	getcwd(buffer, BIG_BUFFER_SIZE);
	say("Current directory: %s", buffer);
}

BUILT_IN_COMMAND(hookcmd)
{
	if (*args)
		do_hook(HOOK_LIST, "%s", args);
	else
		say("Usage: /HOOK [text]");
}

/*
 * eval_inputlist:  Cute little wrapper that calls parse_line() when we
 * get an input prompt ..
 */
static void	eval_inputlist (char *args, char *line)
{
	parse_line(NULL, args, line ? line : empty_string, 0, 0, 1);
}


BUILT_IN_COMMAND(inputcmd)
{
	char	*prompt;
	int	wait_type = WAIT_PROMPT_KEY;
	char	*argument;
	int	echo = 1;

	if (!strcmp(command, "INPUT"))
		wait_type = WAIT_PROMPT_LINE;

	while (*args == '-')
	{
		argument = next_arg(args, &args);
		if (!my_stricmp(argument, "-noecho"))
			echo = 0;
	}

	if (!(prompt = new_next_arg(args, &args)))
	{
		say("Usage: %s \"prompt\" { commands }", command);
		return;
	}

	while (my_isspace(*args))
		args++;

	add_wait_prompt(prompt, eval_inputlist, args, wait_type, echo);
}

BUILT_IN_COMMAND(reset)
{
	refresh_screen(0, NULL);
}

static        int     e_pause_cb_throw = 0;
static        void    e_pause_cb (char *u1, char *u2) { e_pause_cb_throw--; }

BUILT_IN_COMMAND(e_pause)
{
	char *sec;
	long milliseconds;
struct timeval start;

	if (!(sec = next_arg(args, &args)))
	{
		int	c_level = e_pause_cb_throw;

		add_wait_prompt(empty_string, e_pause_cb, 
				NULL, WAIT_PROMPT_DUMMY, 0);
		e_pause_cb_throw++;
		while (e_pause_cb_throw > c_level)
			io("pause");
		return;
	}

	milliseconds = (long)(atof(sec) * 1000);
	get_time(&start);
	start.tv_usec += (milliseconds * 1000);
	start.tv_sec += (start.tv_usec / 1000000);
	start.tv_usec %= 1000000;

	/* 
	 * I use comment here simply becuase its not going to mess
	 * with the arguments.
	 */
	add_timer(0, empty_string, milliseconds, 1, (int (*)(void *, char *))comment, NULL, NULL, get_current_winref(), "pause");
	while (time_diff(get_time(NULL), start) > 0)
		io("e_pause");
}

BUILT_IN_COMMAND(breakcmd)
{
	if (!will_catch_break_exceptions)
		say("Cannot BREAK here.");
	else
		break_exception++;
}

BUILT_IN_COMMAND(continuecmd)
{
	if (!will_catch_continue_exceptions)
		say("Cannot CONTINUE here.");
	else
		continue_exception++;
}

BUILT_IN_COMMAND(returncmd)
{
	if (!will_catch_return_exceptions)
		say("Cannot RETURN here.");
	else
	{
		if (args && *args)
		{
			int o_w_d = window_display;
			window_display = 0;
			add_local_alias("FUNCTION_RETURN", args);
			window_display = o_w_d;
		}
		return_exception++;
	}
}

BUILT_IN_COMMAND(sleepcmd)
{
	char	*arg;

	
	if ((arg = next_arg(args, &args)) != NULL)
		sleep(atoi(arg));
}

BUILT_IN_COMMAND(usleepcmd)
{
	char 		*arg;
	struct timeval 	pause;
	time_t		nms;

	if ((arg = next_arg(args, &args)))
	{
		nms = (time_t)my_atol(arg);
		pause.tv_sec = nms / 1000000;
		pause.tv_usec = nms % 1000000;
		select(0, NULL, NULL, NULL, &pause);
	}
	else
		say("Usage: USLEEP <usec>");
}

/*
   This isnt a command, its used by the wait command.  Since its extern,
   and it doesnt use anything static in this file, im sure it doesnt
   belong here.
 */
void oh_my_wait (int servnum)
{
	int w_server;

	if ((w_server = servnum) == -1)
		w_server = from_server;

	if (is_connected(w_server))
	{
		int old_from_server = from_server;
				
		inc_server_waiting_out(w_server);
		lock_stack_frame();
		send_ncommand(1000, NULL);
		while (server_waiting_in(w_server) < server_waiting_out(w_server))
			io("oh_my_wait");
		from_server = old_from_server;
	}
}

BUILT_IN_COMMAND(waitcmd)
{
	char	*ctl_arg = next_arg(args, &args);

	if (from_server == -1)
		return;
	if (ctl_arg && !my_strnicmp(ctl_arg, "-c", 2))
	{
		WaitCmd	*new_wait;

		new_wait = (WaitCmd *) new_malloc(sizeof(WaitCmd));
		new_wait->stuff = m_strdup(args);
		new_wait->next = NULL;

		if (end_wait_list)
			end_wait_list->next = new_wait;
		end_wait_list = new_wait;
		if (!start_wait_list)
			start_wait_list = new_wait;
		send_ncommand(1000, NULL);
	}

	else if (ctl_arg && !my_strnicmp(ctl_arg, "for", 3))
	{
		clear_sent_to_server(from_server);
		parse_line(NULL, args, subargs, 0, 0, 1);
		if (sent_to_server(from_server))
			oh_my_wait(from_server);
		clear_sent_to_server(from_server);
	}

	else if (ctl_arg && *ctl_arg == '%')
	{
		int	w_index = is_valid_process(ctl_arg);

		if (w_index != -1)
		{
			if (args && *args)
			{
				if (!my_strnicmp(args, "-cmd", 4))
					next_arg(args, &args);
				add_process_wait(w_index, args?args:empty_string);
			}
			else
			{
				set_input(empty_string);
				lock_stack_frame();
				while (process_is_running(ctl_arg))
					io("wait %proc");
				unlock_stack_frame();
			}
		}
	}
	else if (ctl_arg)
		yell("Unknown argument to /WAIT");
	else
	{
		oh_my_wait(from_server);
		clear_sent_to_server(from_server);
	}
}

int check_wait_command(char *nick)
{
	if ((server_waiting_out(from_server) > server_waiting_in(from_server)) && !strcmp(nick, "Unknown command code 1000"))
	{
		inc_server_waiting_in(from_server);
		unlock_stack_frame();
	        return 1;
	}
	if (start_wait_list && !strcmp(nick, "Unknown command code 1000"))
	{
		WaitCmd *old = start_wait_list;

		start_wait_list = old->next;
		if (old->stuff)
		{
			parse_line("WAIT", old->stuff, empty_string, 0, 0, 1);
			new_free(&old->stuff);
		}
		if (end_wait_list == old)
			end_wait_list = NULL;
		new_free((char **)&old);
		return 1;
	}
	return 0;
}

/* The SENDLINE command.. */
BUILT_IN_COMMAND(sendlinecmd)
{
	int	server;
	int	display;

	server = from_server;
	display = window_display;
	window_display = 1;
	if (args && *args)
		parse_line(NULL, args, get_int_var(INPUT_ALIASES_VAR) ? empty_string : NULL, 1, 0, 1);
	update_input(UPDATE_ALL);
	window_display = display;
	from_server = server;
}

BUILT_IN_COMMAND(listusers)
{
char *server = NULL, *flag = NULL, *arg;

	while ((arg = next_arg(args, &args)))
	{
		if (!(*arg == '-') && !server)
			server = arg;
		else if (!my_strnicmp(arg, "-Leech", 2))
			flag = "l";
		else if (!my_strnicmp(arg, "-Moderator", 2))
			flag = "m";
		else if (!my_strnicmp(arg, "-Admin", 2))
			flag = "a";
		else if (!my_strnicmp(arg, "-Elite", 2))
			flag = "e";
		else 
			set_server_showuser(from_server, arg, -1);
	}
	send_ncommand(CMDS_SHOWUSERS, "%s%s%s", server ? server :star, flag ? space : empty_string, flag ? flag : empty_string);
}

BUILT_IN_COMMAND(listop)
{
char *chan;
	chan = next_arg(args, &args);
	if (!chan)
		chan = current_window->current_channel;
	if (!chan)
	{
		say("Specify a channel as you are not on a channel");
		return;
	}
	send_ncommand(CMDS_LISTOPS, "%s", chan);
}

BUILT_IN_COMMAND(createop)
{
char *chan;
	chan = next_arg(args, &args);
	if (args && *args)
		send_ncommand(CMDS_CREATEOP, "%s %s", chan, args);
	else
		say("Who's your Daddy?");
}

BUILT_IN_COMMAND(delop)
{
char *chan;
	chan = next_arg(args, &args);
	if (args && *args)
		send_ncommand(CMDS_DELETEOP, "%s %s", chan, args);
	else
		say("Who's your Daddy?");
}

BUILT_IN_COMMAND(set_chanlimit)
{
char *chan;
	if ((chan = next_arg(args, &args)) && args)
		send_ncommand(CMDS_SETCHANNELLIMIT, "%s %s", chan, args);
}

BUILT_IN_COMMAND(nadmin)
{
int	i;
char	*comm,
	*user;

typedef struct _Nadmin {
	char	*command;
	int	cmd;
	int	arg_count;
	int	len;
	char	*helparg;
} Nadmin;

Nadmin admin_comm[] = {
	{ "killserver",	CMDS_SERVERKILL,	-1,	5, NULL },
	{ "banuser",	CMDS_BANUSER,		1,	4, NULL },
	{ "setchanlevel",CMDS_SETCHANLEVEL,	2,	9, NULL },
	{ "setdataport",CMDR_SETDATAPORT,	2,	4, NULL }, 
	{ "setlinespeed",CMDS_SETLINESPEED,	2,	4, NULL },
	{ "setuserlevel",CMDS_SETUSERLEVEL,	2,	4, NULL },
	{ "connect",	CMDS_SERVERLINK,	-1,	4, NULL },
	{ "disconnect",	CMDS_SERVERUNLINK,	-1,	4, NULL },
	{ "config",	CMDS_SETCONFIG,		-1,	4, NULL },
	{ "unnukeuser",	CMDS_UNNUKEUSER,	1,	3, NULL },
	{ "unbanuser",	CMDS_UNBANUSER,		1,	3, NULL },
	{ "removeserver",CMDS_SERVERREMOVE,	-1,	3, NULL },
	{ "announce",	CMDR_ANNOUNCE,		-1,	1, NULL },
	{ "version",	CMDS_SERVERVERSION,	0,	1, NULL },
	{ "links",	CMDS_SERVERLINKS,	-1,	1, NULL },
	{ "reload",	CMDS_RELOADCONFIG,	-1,	3, NULL },
	{ "nukeuser",	CMDS_NUKEUSER,		1,	1, NULL },
	{ "banlist",	CMDS_BANLIST,		-1,	1, NULL },
	{ "speed",	CMDS_CHANGESPEED,	1,	2, NULL },
	{ "password",	CMDS_CHANGEPASS,	1,	2, NULL },
	{ "email",	CMDS_CHANGEEMAIL,	1,	2, NULL },
	{ "dataport",	CMDS_CHANGEDATA,	1,	2, NULL },
	{ "clearchannel",CMDS_CLEARCHANNEL,	2,	2, NULL },
	{ "stats",	CMDS_SERVERUSAGE,	0,	2, NULL },
	{ "register",	CMDS_ADMINREGISTER,	2,	3, NULL },
	{ "setpassword",CMDS_SETPASSWORD,	-1,	4, NULL },
	{ "showallchannels",CMDS_SHOWALLCHANNELS, -1,	2, NULL },
	{ NULL,		0,			-1,	0, NULL }
};
				
	if (!(comm = next_arg(args, &args)))
	{
		char buffer[BIG_BUFFER_SIZE+1];
		int buflen, count = 0;
		*buffer = 0;
		bitchsay("Admin commands:");
		for (i = 0; admin_comm[i].command; i++)
		{
			buflen = strlen(buffer);
			sprintf(buffer+buflen, "%16s ", admin_comm[i].command);
			if (count++ > 2)
			{
				put_it("%s", buffer);
				*buffer = 0;
				count = 0;
			}
		}
		if (*buffer)
			put_it("%s", buffer);
		return;
	}
	if (!my_stricmp(comm, "-help"))
	{
		bitchsay("%s", helparg);
		return;
	}
	for (i = 0; admin_comm[i].command; i++)
	{
		if (!my_strnicmp(admin_comm[i].command, comm, admin_comm[i].len))
		{
			if (args && !my_stricmp(args, "-help"))
			{
				bitchsay("Usage: /admin %s %s", comm, admin_comm->helparg? admin_comm->helparg:"Undocumented");
				bitchsay("\t /admin  to list all the admin commands");
				return;
			}
			switch(admin_comm[i].arg_count)
			{
				case 0:
				{
					send_ncommand(admin_comm[i].cmd, NULL);
					break;
				}
				case 1:
				{
					if ((user = next_arg(args, &args)))
						send_ncommand(admin_comm[i].cmd, "%s", user);
					else
						say("Nothing to send for %s", admin_comm[i].command);
					break;
				}
				case 2:
				{
					user = next_arg(args, &args);
					if (args && *args)
						send_ncommand(admin_comm[i].cmd, "%s \"%s\"", user, args);
					else
						send_ncommand(admin_comm[i].cmd, "%s", user);
					break;
				}
				case -1:
				{
					if (args && *args)
						send_ncommand(admin_comm[i].cmd, "%s", args);
					else
						send_ncommand(admin_comm[i].cmd, NULL);
				}
			}
			return;
		}
	}
}

