/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.csv;

import com.darwinsys.csv.CSVParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVRE
implements CSVParser {
    public static final String CSV_PATTERN = "\"([^\"]+?)\",?|([^,]+),?|,";
    private static final Pattern csvRE = Pattern.compile("\"([^\"]+?)\",?|([^,]+),?|,");

    public static void main(String[] argv) throws IOException {
        System.out.println(CSV_PATTERN);
        new CSVRE().process(new BufferedReader(new InputStreamReader(System.in)));
    }

    public void process(BufferedReader input) throws IOException {
        String line;
        while ((line = input.readLine()) != null) {
            System.out.println("line = `" + line + "'");
            List<String> list = this.parse(line);
            System.out.println("Found " + list.size() + " items.");
            int i = 0;
            while (i < list.size()) {
                System.out.print(list.get(i) + ",");
                ++i;
            }
            System.out.println();
        }
    }

    @Override
    public List<String> parse(String line) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = csvRE.matcher(line);
        while (m.find()) {
            String match = m.group();
            if (match == null) break;
            if (match.endsWith(",")) {
                match = match.substring(0, match.length() - 1);
            }
            if (match.startsWith("\"")) {
                match = match.substring(1, match.length() - 1);
            }
            if (match.length() == 0) {
                match = "";
            }
            list.add(match);
        }
        return list;
    }
}

