/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.SQLObject;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class SQLObjectTransferable
implements Transferable,
Serializable {
    private static final Logger logger = Logger.getLogger(SQLObjectTransferable.class);
    public static final DataFlavor SQLOBJECT_FLAVOR = new DataFlavor(SQLObject.class, "Database objects");
    protected SQLObject data;

    public SQLObjectTransferable(SQLObject data) {
        this.data = data;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{SQLOBJECT_FLAVOR};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(SQLOBJECT_FLAVOR);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor != SQLOBJECT_FLAVOR) {
            throw new IllegalArgumentException("Unsupported flavor " + flavor);
        }
        logger.debug((Object)("getTransferData returns '" + this.data.getName() + "'" + this.data.getClass().getName() + "@" + this.data.hashCode()));
        return this.data;
    }
}

