/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.swingui.ProfilePanel;
import ca.sqlpower.architect.swingui.table.FreqValueCountTableModel;
import ca.sqlpower.architect.swingui.table.FreqValueTable;
import ca.sqlpower.architect.swingui.table.TableModelSortDecorator;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryToPieDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.TableOrder;

public class ProfileGraphPanel {
    private JLabel rowCountDisplay;
    private JLabel title;
    private JLabel nullableLabel;
    private JLabel minValue;
    private JLabel maxValue;
    private JLabel avgValue;
    private JLabel nullCountLabel;
    private JLabel nullPercentLabel;
    private JLabel minLengthLabel;
    private JLabel uniqueCountLabel;
    private JLabel uniquePercentLabel;
    private JLabel maxLengthLabel;
    private FreqValueTable freqValueTable;
    private JScrollPane freqValueSp;
    ProfilePanel.ChartTypes chartType = ProfilePanel.ChartTypes.PIE;
    JPanel displayArea;
    private int rowCount;
    private ChartPanel chartPanel;
    private static final Logger logger = Logger.getLogger(ProfileGraphPanel.class);

    public ProfileGraphPanel(ProfilePanel panel, int rowCount) {
        this.rowCount = rowCount;
        FormLayout displayLayout = new FormLayout("4dlu, default, 4dlu, 100dlu, 4dlu, fill:default:grow, 4dlu", "4dlu, default, 6dlu");
        CellConstraints cc = new CellConstraints();
        this.displayArea = logger.isDebugEnabled() ? new FormDebugPanel(displayLayout) : new JPanel((LayoutManager)displayLayout);
        this.displayArea.setBorder(BorderFactory.createEtchedBorder());
        Font bodyFont = this.displayArea.getFont();
        Font titleFont = bodyFont.deriveFont(1, (float)bodyFont.getSize() * 1.25f);
        this.title = new JLabel("Column Name");
        this.title.setFont(titleFont);
        PanelBuilder pb = new PanelBuilder(displayLayout, this.displayArea);
        pb.add((Component)this.title, cc.xyw(2, 2, 5));
        int row = 4;
        this.rowCountDisplay = this.makeInfoRow(pb, "RowCount", row);
        this.nullableLabel = this.makeInfoRow(pb, "Nullable", row += 2);
        this.nullCountLabel = this.makeInfoRow(pb, "Null Count", row += 2);
        this.nullPercentLabel = this.makeInfoRow(pb, "% Null Records", row += 2);
        this.minLengthLabel = this.makeInfoRow(pb, "Minimum Length", row += 2);
        this.maxLengthLabel = this.makeInfoRow(pb, "Maximum Length", row += 2);
        this.uniqueCountLabel = this.makeInfoRow(pb, "Unique Values", row += 2);
        this.uniquePercentLabel = this.makeInfoRow(pb, "% Unique", row += 2);
        this.minValue = this.makeInfoRow(pb, "Minimum Value", row += 2);
        this.maxValue = this.makeInfoRow(pb, "Maximum Value", row += 2);
        this.avgValue = this.makeInfoRow(pb, "Average Value", row += 2);
        this.freqValueTable = new FreqValueTable(null);
        this.freqValueSp = new JScrollPane(this.freqValueTable);
        pb.appendRow("fill:10dlu:grow");
        pb.appendRow("fill:default:grow");
        pb.add((Component)this.freqValueSp, cc.xyw(2, (row += 2) + 1, 3));
        pb.appendRow("fill:4dlu:grow");
        pb.appendRow("4dlu");
        JFreeChart createPieChart = ChartFactory.createPieChart((String)"", (PieDataset)new DefaultPieDataset((KeyedValues)new DefaultKeyedValues()), (boolean)false, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(createPieChart);
        pb.add((Component)this.chartPanel, cc.xywh(6, 4, 1, row - 2));
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public JPanel getDisplayArea() {
        return this.displayArea;
    }

    public void setDisplayArea(JPanel displayArea) {
        this.displayArea = displayArea;
    }

    public void displayProfile(ColumnProfileResult cr) {
        TableProfileResult tr = cr.getParentResult();
        this.rowCount = tr instanceof TableProfileResult ? tr.getRowCount() : 0;
        this.rowCountDisplay.setText(Integer.toString(this.rowCount));
        StringBuffer sb = new StringBuffer();
        SQLColumn c = (SQLColumn)cr.getProfiledObject();
        sb.append(c);
        if (c.isPrimaryKey()) {
            sb.append(' ').append("[PK]");
        }
        this.setTitle(sb.toString());
        this.nullableLabel.setText(Boolean.toString(c.isDefinitelyNullable()));
        if (cr == null) {
            ProfilePanel.logger.error((Object)("displayProfile called but unable to get ColumnProfileResult for column: " + c));
            cr = new ColumnProfileResult(c, null, null, null);
            cr.setCreateStartTime(0L);
            this.chartPanel.setChart(ChartFactory.createPieChart((String)"", (PieDataset)new DefaultPieDataset(), (boolean)false, (boolean)false, (boolean)false));
        } else {
            this.chartPanel.setChart(this.createTopNChart(cr));
            this.nullCountLabel.setText(Integer.toString(cr.getNullCount()));
            int nullsInRecords = cr.getNullCount();
            double ratio = this.rowCount > 0 ? (double)nullsInRecords * 100.0 / (double)this.rowCount : 0.0;
            this.nullPercentLabel.setText(this.format(ratio));
            this.uniqueCountLabel.setText(Integer.toString(cr.getDistinctValueCount()));
            double uniqueRatio = this.rowCount > 0 ? (double)cr.getDistinctValueCount() * 100.0 / (double)this.rowCount : 0.0;
            this.uniquePercentLabel.setText(this.format(uniqueRatio));
            this.minLengthLabel.setText(Integer.toString(cr.getMinLength()));
            this.maxLengthLabel.setText(Integer.toString(cr.getMaxLength()));
            this.minValue.setText(cr.getMinValue() == null ? "" : cr.getMinValue().toString());
            this.maxValue.setText(cr.getMaxValue() == null ? "" : cr.getMaxValue().toString());
            Object o = cr.getAvgValue();
            if (o == null) {
                this.avgValue.setText("");
            } else if (o instanceof BigDecimal) {
                double d = ((BigDecimal)o).doubleValue();
                this.avgValue.setText(this.format(d));
            } else {
                ProfilePanel.logger.debug((Object)("Got avgValue of type: " + o.getClass().getName()));
                this.avgValue.setText(cr.getAvgValue().toString());
            }
            FreqValueCountTableModel freqValueCountTableModel = new FreqValueCountTableModel(cr);
            TableModelSortDecorator sortModel = new TableModelSortDecorator(freqValueCountTableModel);
            this.freqValueTable.setModel(sortModel);
            sortModel.setTableHeader(this.freqValueTable.getTableHeader());
            this.freqValueTable.initColumnSizes();
        }
    }

    private JFreeChart createTopNChart(ColumnProfileResult cr) {
        JFreeChart chart;
        String chartTitle;
        List<ColumnValueCount> valueCounts = cr.getValueCount();
        SQLColumn col = (SQLColumn)cr.getProfiledObject();
        DefaultCategoryDataset catDataset = new DefaultCategoryDataset();
        long otherDataCount = this.rowCount;
        for (ColumnValueCount vc : valueCounts) {
            catDataset.addValue((double)vc.getCount(), (Comparable)((Object)col.getName()), (Comparable)((Object)(vc.getValue() == null ? "null" : vc.getValue().toString())));
            otherDataCount -= (long)vc.getCount();
        }
        int numberOfTopValues = catDataset.getColumnCount();
        if (otherDataCount > 0L) {
            catDataset.addValue((double)otherDataCount, (Comparable)((Object)col.getName()), (Comparable)((Object)"Other Values"));
        }
        if (this.chartType == ProfilePanel.ChartTypes.BAR) {
            chartTitle = numberOfTopValues == 10 ? "Top " + numberOfTopValues + " most common values" : "All " + numberOfTopValues + " values";
            chart = ChartFactory.createBarChart((String)chartTitle, (String)"", (String)"", (CategoryDataset)catDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            CategoryAxis domainAxis = chart.getCategoryPlot().getDomainAxis();
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
        } else if (this.chartType == ProfilePanel.ChartTypes.PIE) {
            chartTitle = numberOfTopValues == 10 ? "Top " + numberOfTopValues + " most common values" : "All " + numberOfTopValues + " values";
            chart = ChartFactory.createPieChart((String)chartTitle, (PieDataset)new CategoryToPieDataset((CategoryDataset)catDataset, TableOrder.BY_ROW, 0), (boolean)false, (boolean)true, (boolean)false);
            if (chart.getPlot() instanceof PiePlot) {
                ((PiePlot)chart.getPlot()).setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} [{1}]"));
            }
        } else {
            throw new IllegalStateException("chart type " + (Object)((Object)this.chartType) + " not recognized");
        }
        return chart;
    }

    public ProfilePanel.ChartTypes getChartType() {
        return this.chartType;
    }

    public void setChartType(ProfilePanel.ChartTypes chartType) {
        this.chartType = chartType;
    }

    private String format(double d) {
        return String.format("%6.2f", d);
    }

    private JLabel makeInfoRow(PanelBuilder pb, String title, int row) {
        CellConstraints cc = new CellConstraints();
        pb.appendRow("default");
        pb.appendRow("2dlu");
        pb.add((Component)new JLabel(title), cc.xy(2, row));
        JLabel label = new JLabel("--");
        pb.add((Component)label, cc.xy(4, row));
        return label;
    }
}

