/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.DatabaseListChangeEvent;
import ca.sqlpower.architect.DatabaseListChangeListener;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class ConnectionComboBoxModel
implements ComboBoxModel,
DatabaseListChangeListener {
    private static final Logger logger = Logger.getLogger(ConnectionComboBoxModel.class);
    ArchitectDataSource selectedItem;
    List<ArchitectDataSource> connections;
    List<ListDataListener> listenerList;
    DataSourceCollection plini;

    public ConnectionComboBoxModel() {
        this(ArchitectFrame.getMainInstance().getUserSettings().getPlDotIni());
    }

    public ConnectionComboBoxModel(DataSourceCollection plini) {
        this.plini = plini;
        this.listenerList = new ArrayList<ListDataListener>();
        this.connections = plini.getConnections();
        plini.addDatabaseListChangeListener(this);
    }

    public void cleanup() {
        this.plini.removeDatabaseListChangeListener(this);
    }

    public void setSelectedItem(Object anItem) {
        int selectedIndex = this.connections.indexOf(anItem);
        if (selectedIndex >= 0) {
            if (anItem instanceof ArchitectDataSource) {
                this.selectedItem = (ArchitectDataSource)anItem;
            } else if (anItem == null) {
                this.selectedItem = null;
            }
            this.fireContentChangedEvent(selectedIndex);
        }
    }

    public void setSelectedItem(String anItem) {
        for (ArchitectDataSource ds : this.connections) {
            if (!ds.getName().equals(anItem)) continue;
            this.selectedItem = ds;
            this.setSelectedItem(this.selectedItem);
            return;
        }
        logger.debug((Object)("warning: set selected item:" + anItem));
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public int getSize() {
        return this.connections.size() + 1;
    }

    public Object getElementAt(int index) {
        if (index == 0) {
            return null;
        }
        return this.connections.get(index - 1);
    }

    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(l);
    }

    private void fireContentChangedEvent(int index) {
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).contentsChanged(new ListDataEvent(this, 0, index, index));
        }
    }

    public void databaseAdded(DatabaseListChangeEvent e) {
        this.connections = this.plini.getConnections();
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).contentsChanged(new ListDataEvent(this, 1, e.getListIndex(), e.getListIndex()));
        }
    }

    public void databaseRemoved(DatabaseListChangeEvent e) {
        this.connections = this.plini.getConnections();
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).contentsChanged(new ListDataEvent(this, 2, e.getListIndex(), e.getListIndex()));
        }
    }
}

