/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.layout;

import ca.sqlpower.architect.layout.AbstractLayout;
import ca.sqlpower.architect.layout.ArchitectGridLayout;
import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.layout.LayoutNode;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FruchtermanReingoldForceLayout
extends AbstractLayout {
    private static final Logger logger = Logger.getLogger(FruchtermanReingoldForceLayout.class);
    private ArrayList<LayoutNode> nodes;
    private ArrayList<LayoutNode> orphanedTables = new ArrayList();
    private ArrayList<LayoutEdge> edges;
    private double k;
    private double temp;
    private static final double SPACING_MULTIPLIER = 2.0;
    private int stoppedFrames;
    private int baseLineJitter;
    private boolean overrideDone;
    private int frameNum = 0;
    private static final int ORPHAN_BUFFER = 50;

    @Override
    public void setup(Collection<? extends LayoutNode> nodes, Collection<? extends LayoutEdge> edges, Rectangle frame) {
        this.frame = new Rectangle(frame);
        this.nodes = new ArrayList<LayoutNode>(nodes);
        for (LayoutNode layoutNode : nodes) {
            if (layoutNode.getOutboundEdges().size() != 0 || layoutNode.getInboundEdges().size() != 0) continue;
            this.orphanedTables.add(layoutNode);
        }
        this.nodes.removeAll(this.orphanedTables);
        this.edges = new ArrayList<LayoutEdge>(edges);
        this.baseLineJitter = 10;
        this.temp = 1000 * nodes.size();
        this.stoppedFrames = 0;
        this.overrideDone = false;
        this.k = this.getEmptyRadius();
    }

    public double magnitude(Point p) {
        return p.distance(0.0, 0.0);
    }

    @Override
    public boolean isDone() {
        return this.stoppedFrames > 5 || this.nodes.size() + this.orphanedTables.size() < 2 || this.overrideDone;
    }

    @Override
    public void nextFrame() {
        if (this.frameNum == 0) {
            ArchitectGridLayout gl = new ArchitectGridLayout();
            gl.setup(this.orphanedTables, Collections.EMPTY_LIST, this.frame);
            gl.done();
            int maxy = 0;
            for (LayoutNode tp : this.orphanedTables) {
                maxy = Math.max(tp.getY() + tp.getHeight(), maxy);
            }
            int orphanStartY = this.frame.height - maxy;
            logger.debug((Object)("max y is " + maxy + ". orphanStartY is " + orphanStartY));
            for (LayoutNode tp : this.orphanedTables) {
                tp.setBounds(tp.getX(), tp.getY() + orphanStartY, tp.getWidth(), tp.getHeight());
            }
            this.frame.height -= maxy + 50;
        }
        HashMap<LayoutNode, Point> displacement = new HashMap<LayoutNode, Point>();
        for (LayoutNode tp : this.nodes) {
            displacement.put(tp, new Point((int)Math.round(Math.random() * (double)this.baseLineJitter - (double)(this.baseLineJitter / 2)), (int)Math.round(Math.random() * (double)this.baseLineJitter - (double)(this.baseLineJitter / 2))));
        }
        if (this.nodes != null && !this.isDone()) {
            for (int ii = 0; ii < this.nodes.size(); ++ii) {
                LayoutNode v = this.nodes.get(ii);
                Point disp = (Point)displacement.get(v);
                for (int jj = 0; jj < this.nodes.size(); ++jj) {
                    LayoutNode u = this.nodes.get(jj);
                    if (u == v) continue;
                    while (v.getLocation().equals(u.getLocation())) {
                        v.setLocation((int)Math.round(Math.random() * 5.0 - 3.0), (int)Math.round(Math.random() * 5.0 - 3.0));
                    }
                    Point delta = this.displacementBetween(u, v);
                    if (!(delta.distance(0.0, 0.0) < 5.0 * this.k)) continue;
                    disp.translate((int)Math.round((double)delta.x / this.magnitude(delta) * this.repulsiveForce(this.magnitude(delta), u, v, this.k)), (int)Math.round((double)delta.y / this.magnitude(delta) * this.repulsiveForce(this.magnitude(delta), u, v, this.k)));
                }
            }
            for (LayoutEdge e : this.edges) {
                Point uDisp;
                LayoutNode v = e.getTailNode();
                LayoutNode u = e.getHeadNode();
                Point delta = this.displacementBetween(u, v);
                Point vDisp = (Point)displacement.get(v);
                if (vDisp == null || (uDisp = (Point)displacement.get(u)) == null) break;
                if (uDisp.equals(vDisp)) {
                    vDisp.translate((int)Math.random() + 1, (int)Math.random() + 1);
                }
                vDisp.translate(-((int)Math.round(0.5 * ((double)delta.x / this.magnitude(delta) * this.attractiveForce(delta, this.k)))), -((int)Math.round(0.5 * ((double)delta.y / this.magnitude(delta) * this.attractiveForce(delta, this.k)))));
                uDisp.translate((int)Math.round(0.5 * ((double)delta.x / this.magnitude(delta) * this.attractiveForce(delta, this.k))), (int)Math.round(0.5 * ((double)delta.y / this.magnitude(delta) * this.attractiveForce(delta, this.k))));
            }
            boolean done = true;
            for (LayoutNode v : this.nodes) {
                Point pos = (Point)v.getLocation().clone();
                Point disp = (Point)displacement.get(v);
                pos.translate((int)Math.round((double)disp.x / this.magnitude(disp) * Math.min(this.magnitude(disp), this.getTemp())), (int)Math.round((double)disp.y / this.magnitude(disp) * Math.min(this.magnitude(disp), this.getTemp())));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unmodified move x:" + pos.x + ", y:" + pos.y));
                }
                int xJitter = (int)Math.round(Math.random() * (double)this.baseLineJitter);
                int yJitter = (int)Math.round(Math.random() * (double)this.baseLineJitter);
                pos.x = Math.min(Math.max(this.frame.x + xJitter, pos.x), this.getRightBoundary() - v.getWidth() - xJitter);
                pos.y = Math.min(Math.max(this.frame.y + yJitter, pos.y), this.getLowerBoundary() - v.getHeight() - yJitter);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Moving table " + v + " to position " + pos));
                }
                if (pos.distance(v.getLocation()) > 2.0) {
                    done = false;
                }
                v.setLocation(pos);
            }
            if (done) {
                ++this.stoppedFrames;
            }
        }
        this.cool();
        ++this.frameNum;
    }

    private Point displacementBetween(LayoutNode u, LayoutNode v) {
        Point dist = null;
        if (dist == null) {
            dist = new Point(v.getLocation().x + v.getWidth() / 2 - (u.getLocation().x + u.getWidth() / 2), v.getLocation().y + v.getHeight() / 2 - (u.getLocation().y + u.getHeight() / 2));
        }
        return dist;
    }

    protected double attractiveForce(Point distance, double emptyRadius) {
        double force = (double)(distance.x * distance.x + distance.y * distance.y) / emptyRadius;
        return force;
    }

    protected double repulsiveForce(double distance, LayoutNode u, LayoutNode v, double emptyRadius) {
        double baseForce = 0.1;
        double tableSizes = u.getHeight() + u.getWidth() + v.getHeight() + v.getWidth();
        double force = 0.1 * tableSizes * (emptyRadius * emptyRadius) / (distance * distance);
        return force;
    }

    public double getEmptyRadius() {
        double radius = 0.0;
        for (LayoutNode tp : this.nodes) {
            Rectangle b = tp.getBounds();
            radius += (double)b.height;
            radius += (double)b.width;
        }
        return (radius /= (double)this.nodes.size()) * 2.0;
    }

    @Override
    public void done() {
        this.overrideDone = true;
    }

    public void cool() {
        this.temp /= 1.1;
    }

    public ArrayList<LayoutEdge> getEdges() {
        return this.edges;
    }

    public double getK() {
        return this.k;
    }

    public ArrayList<LayoutNode> getNodes() {
        return this.nodes;
    }

    public double getTemp() {
        return this.temp;
    }

    public int getH() {
        return this.frame.height;
    }

    public int getRightBoundary() {
        return this.frame.x + this.frame.width;
    }

    public int getLowerBoundary() {
        return this.frame.y + this.frame.height;
    }

    public int getW() {
        return this.frame.width;
    }
}

