/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.etl;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETLUtils {
    private ETLUtils() {
    }

    public static Map<SQLTable, Collection<SQLTable>> findTableLevelMappings(Collection<SQLTable> targetTables) throws ArchitectException {
        HashMap<SQLTable, Collection<SQLTable>> mappings = new HashMap<SQLTable, Collection<SQLTable>>();
        for (SQLTable t : targetTables) {
            HashSet<SQLTable> sources = new HashSet<SQLTable>();
            for (SQLColumn c : t.getColumns()) {
                SQLColumn sc = c.getSourceColumn();
                if (sc != null) {
                    sources.add(sc.getParentTable());
                    continue;
                }
                sources.add(null);
            }
            for (SQLTable st : sources) {
                ArrayList<SQLTable> targets = (ArrayList<SQLTable>)mappings.get(st);
                if (targets == null) {
                    targets = new ArrayList<SQLTable>();
                    mappings.put(st, targets);
                }
                targets.add(t);
            }
        }
        return mappings;
    }
}

