/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.macosui;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.darwinsys.macosui.AboutBoxHandler;
import com.darwinsys.macosui.PrefsHandler;
import com.darwinsys.macosui.PrintHandler;
import com.darwinsys.macosui.ShutdownHandler;
import javax.swing.JFrame;

public class MacOSAppAdapter
extends Application {
    ApplicationListener appListener = new MyAppEventHandler();
    JFrame parent;
    AboutBoxHandler abouter;
    PrefsHandler prefser;
    PrintHandler printer;
    ShutdownHandler shutter;

    public MacOSAppAdapter(JFrame theParent, AboutBoxHandler about, PrefsHandler prefs, PrintHandler print, ShutdownHandler shut) {
        this.parent = theParent;
        if (about != null) {
            this.abouter = about;
            this.setEnabledAboutMenu(true);
            this.addAboutMenuItem();
        }
        if (prefs != null) {
            this.prefser = prefs;
            this.setEnabledPreferencesMenu(true);
            this.addPreferencesMenuItem();
        }
        this.printer = print;
        this.shutter = shut;
    }

    public void register() {
        this.addApplicationListener(this.appListener);
    }

    class MyAppEventHandler
    implements ApplicationListener {
        MyAppEventHandler() {
        }

        public void handleAbout(ApplicationEvent event) {
            MacOSAppAdapter.this.abouter.showAboutBox(MacOSAppAdapter.this.parent);
            event.setHandled(true);
        }

        public void handlePreferences(ApplicationEvent event) {
            if (MacOSAppAdapter.this.prefser != null) {
                MacOSAppAdapter.this.prefser.showPrefsDialog(MacOSAppAdapter.this.parent);
            }
            event.setHandled(true);
        }

        public void handlePrint(ApplicationEvent event) {
            if (MacOSAppAdapter.this.printer != null) {
                MacOSAppAdapter.this.printer.doPrint(MacOSAppAdapter.this.parent);
            }
            event.setHandled(true);
        }

        public void handleQuit(ApplicationEvent event) {
            if (MacOSAppAdapter.this.shutter != null) {
                MacOSAppAdapter.this.shutter.shutdown(MacOSAppAdapter.this.parent);
            }
            System.exit(0);
        }

        public void handleOpenApplication(ApplicationEvent arg0) {
        }

        public void handleOpenFile(ApplicationEvent arg0) {
        }

        public void handlePrintFile(ApplicationEvent arg0) {
        }

        public void handleReOpenApplication(ApplicationEvent arg0) {
        }
    }
}

