/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.OptionArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class NUp
extends AbstractTool {
    public NUp() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to N-up", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The resulting PDF", true, new PdfFilter()));
        OptionArgument optionArgument = new OptionArgument(this, "pow2", "The number of pages you want to copy to 1 page");
        optionArgument.addOption("2", "1");
        optionArgument.addOption("4", "2");
        optionArgument.addOption("8", "3");
        optionArgument.addOption("16", "4");
        optionArgument.addOption("32", "5");
        optionArgument.addOption("64", "6");
        this.arguments.add(optionArgument);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("N-up", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== N-up OPENED ===");
    }

    public void execute() {
        try {
            int n;
            int n2;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            try {
                n2 = Integer.parseInt((String)this.getValue("pow2"));
            }
            catch (Exception exception) {
                n2 = 1;
            }
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            int n3 = pdfReader.getNumberOfPages();
            System.out.println("There are " + n3 + " pages in the original file.");
            Rectangle rectangle = pdfReader.getPageSize(1);
            Rectangle rectangle2 = n2 % 2 == 0 ? new Rectangle(rectangle.width(), rectangle.height()) : new Rectangle(rectangle.height(), rectangle.width());
            Rectangle rectangle3 = new Rectangle(rectangle.width(), rectangle.height());
            for (n = 0; n < n2; ++n) {
                rectangle3 = new Rectangle(rectangle3.height() / 2.0f, rectangle3.width());
            }
            n = (int)Math.pow(2.0, n2);
            int n4 = (int)Math.pow(2.0, n2 / 2);
            int n5 = n / n4;
            Document document = new Document(rectangle2, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file2));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            for (int i = 0; i < n3; ++i) {
                if (i % n == 0) {
                    document.newPage();
                }
                int n6 = i + 1;
                float f = rectangle3.width() * (float)(i % n % n5);
                float f2 = rectangle2.height() - rectangle3.height() * (float)(i % n / n5 + 1);
                Rectangle rectangle4 = pdfReader.getPageSize(n6);
                float f3 = Math.min(rectangle3.width() / rectangle4.width(), rectangle3.height() / rectangle4.height());
                PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n6);
                pdfContentByte.addTemplate(pdfImportedPage, f3, 0.0f, 0.0f, f3, f += (rectangle3.width() - rectangle4.width() * f3) / 2.0f, f2 += (rectangle3.height() - rectangle4.height() * f3) / 2.0f);
            }
            document.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        NUp nUp = new NUp();
        if (stringArray.length < 2) {
            System.err.println(nUp.getUsage());
        }
        nUp.setArguments(stringArray);
        nUp.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        NUp.addVersion("$Id: NUp.java,v 1.6 2005/11/29 21:05:02 blowagie Exp $");
    }
}

