/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DBConnection;
import ca.sqlpower.util.Cache;
import ca.sqlpower.util.LabelValueBean;
import ca.sqlpower.util.LeastRecentlyUsedCache;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SQL {
    private static Cache colTypeCache = new LeastRecentlyUsedCache(20);

    private SQL() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int columnType(Connection con, String owner, String table, String column) throws SQLException {
        String cacheKey = con.getMetaData().getURL() + owner + "." + table + "." + column;
        Integer colType = (Integer)colTypeCache.get(cacheKey);
        if (colType == null) {
            Statement stmt = null;
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT ").append(column);
                sql.append(" FROM ");
                if (owner != null) {
                    sql.append(owner).append(".");
                }
                sql.append(table);
                sql.append(" WHERE 0=1");
                stmt = con.createStatement();
                ResultSet rs = stmt.executeQuery(sql.toString());
                ResultSetMetaData rsmd = rs.getMetaData();
                colType = new Integer(rsmd.getColumnType(1));
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            colTypeCache.put(cacheKey, colType);
        }
        return colType;
    }

    public static String quote(String string) {
        if (string == null) {
            return "NULL";
        }
        return "'" + SQL.escapeStatement(string) + "'";
    }

    public static String quote(char myChar) {
        String string = String.valueOf(myChar);
        return "'" + SQL.escapeStatement(string) + "'";
    }

    public static String quoteList(List strings) {
        return SQL.quoteCollection(strings);
    }

    public static String quoteCollection(Collection strings) {
        StringBuffer outputString = new StringBuffer(100);
        boolean firstItem = true;
        Iterator it = strings.iterator();
        while (it.hasNext()) {
            Object item;
            if (!firstItem) {
                outputString.append(", ");
            }
            outputString.append((item = it.next()) == null ? "NULL" : SQL.quote(item.toString()));
            firstItem = false;
        }
        return outputString.toString();
    }

    public static String in(String colName, Collection values) {
        if (colName == null) {
            throw new NullPointerException("colName argument must be non-null");
        }
        boolean foundNull = false;
        StringBuffer outputString = new StringBuffer(100);
        boolean firstItem = true;
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item == null) {
                foundNull = true;
                continue;
            }
            if (!firstItem) {
                outputString.append(", ");
            }
            outputString.append(SQL.quote(item.toString()));
            firstItem = false;
        }
        if (firstItem) {
            if (foundNull) {
                return colName + " IS NULL";
            }
            return "1=1";
        }
        if (foundNull) {
            return "(" + colName + " IN(" + outputString + ") OR " + colName + " IS NULL)";
        }
        return colName + " IN(" + outputString + ")";
    }

    public static String nvl(String string) {
        if (string == null || string.equals("")) {
            return "NULL";
        }
        return string;
    }

    public static String ifnull(Connection con, String sqlExpr, String valueWhenNull) {
        if (DBConnection.isOracle(con)) {
            return "NVL(" + sqlExpr + "," + valueWhenNull + ")";
        }
        if (DBConnection.isPostgres(con)) {
            return "COALESCE(" + sqlExpr + "," + valueWhenNull + ")";
        }
        return "{fn IFNULL(" + sqlExpr + "," + valueWhenNull + ")}";
    }

    public static String initcap(String string) {
        String newString = "";
        if (string == null || string.equals("")) {
            return "";
        }
        newString = string.substring(0, 1).toUpperCase();
        newString = newString.concat(string.substring(1).toLowerCase());
        return newString;
    }

    public static String escapeStatement(String old) {
        if (old == null) {
            return "null";
        }
        if (old.lastIndexOf(39) == -1) {
            return old;
        }
        StringBuffer escaped = new StringBuffer(old);
        for (int i = 0; i < escaped.length(); ++i) {
            if (escaped.charAt(i) != '\'') continue;
            escaped.insert(i, '\'');
            ++i;
        }
        return escaped.toString();
    }

    public static String escapeDate(Connection con, Date date) throws SQLException {
        if (date == null) {
            return "null";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (DBConnection.isOracle(con)) {
            return "TO_DATE('" + df.format(date) + "','YYYY-MM-DD')";
        }
        return "{d '" + df.format(date) + "'}";
    }

    public static String escapeDateTime(Connection con, Date date) throws SQLException {
        if (date == null) {
            return "null";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (DBConnection.isOracle(con)) {
            return "TO_DATE('" + df.format(date) + "','YYYY-MM-DD HH24:MI:SS')";
        }
        return "{ts '" + df.format(date) + "'}";
    }

    public static boolean decodeInd(String indicator) {
        return indicator != null && indicator.charAt(0) == 'Y';
    }

    public static List makeListFromRS(ResultSet rs) throws SQLException {
        LinkedList<LabelValueBean> list = new LinkedList<LabelValueBean>();
        while (rs.next()) {
            list.add(new LabelValueBean(rs.getString(1), rs.getString(2)));
        }
        return list;
    }

    public static List findPrimaryKey(Connection con, String tableName) throws SQLException {
        return SQL.findPrimaryKey(con, "", tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List findPrimaryKey(Connection con, String schemaName, String tableName) throws SQLException {
        ResultSet rs = null;
        try {
            rs = con.getMetaData().getPrimaryKeys("", schemaName, tableName);
            LinkedList<String> prikey = new LinkedList<String>();
            while (rs.next()) {
                prikey.add(rs.getString("COLUMN_NAME"));
            }
            LinkedList<String> linkedList = prikey;
            return linkedList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDatabaseOwners(Connection con) throws SQLException {
        Statement stmt = null;
        LinkedList<String> list = new LinkedList<String>();
        try {
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT DISTINCT owner FROM pl_tables ORDER BY owner");
            while (rs.next()) {
                list.add(rs.getString("OWNER"));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDatabaseTables(Connection con, String owner) throws SQLException {
        Statement stmt = null;
        LinkedList<String> list = new LinkedList<String>();
        try {
            StringBuffer sql = new StringBuffer();
            stmt = con.createStatement();
            sql.append("SELECT DISTINCT table_name");
            sql.append(" FROM pl_tables");
            if (owner != null || owner.length() > 0) {
                sql.append(" WHERE owner=").append(SQL.quote(owner));
            }
            sql.append(" ORDER BY table_name");
            ResultSet rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                list.add(rs.getString("TABLE_NAME"));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDatabaseColumns(Connection con, String owner, String table, List notLike, List like) throws SQLException {
        Statement stmt = null;
        LinkedList<String> list = new LinkedList<String>();
        if (owner == null) {
            throw new NullPointerException("owner must be non-null");
        }
        if (table == null) {
            throw new NullPointerException("table must be non-null");
        }
        try {
            StringBuffer sql = new StringBuffer();
            stmt = con.createStatement();
            sql.append("SELECT DISTINCT column_name");
            sql.append(" FROM pl_tab_columns");
            sql.append(" WHERE owner=").append(SQL.quote(owner));
            sql.append(" AND table_name=").append(SQL.quote(table));
            Iterator it = notLike.iterator();
            while (it.hasNext()) {
                sql.append(" AND column_name NOT LIKE ").append(SQL.quote((String)it.next()));
            }
            it = like.iterator();
            while (it.hasNext()) {
                sql.append(" AND column_name LIKE ").append(SQL.quote((String)it.next()));
            }
            sql.append(" ORDER BY column_name");
            ResultSet rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                list.add(rs.getString("COLUMN_NAME").toUpperCase());
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return list;
    }
}

