/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.security;

import ca.sqlpower.security.LicenseReadException;
import ca.sqlpower.util.ByteColonFormat;
import ca.sqlpower.util.Version;
import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class License
implements Serializable {
    private static final Logger logger = Logger.getLogger((Class)(class$ca$sqlpower$security$License == null ? (class$ca$sqlpower$security$License = License.class$("ca.sqlpower.security.License")) : class$ca$sqlpower$security$License));
    protected String licenseeName;
    protected String productName;
    protected Version minVersion;
    protected Version maxVersion;
    protected Date issueDate;
    protected Date expiryDate;
    protected Properties limits;
    static /* synthetic */ Class class$ca$sqlpower$security$License;

    public License(InputStream xmlStream, InputStream licenseStream) throws LicenseReadException {
        this.parseFile(xmlStream, licenseStream);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Loaded SQLPower product license.");
            logger.info((Object)("For " + this.productName + " versions " + this.minVersion + " to " + this.maxVersion));
            logger.info((Object)("Licensed exclusively to " + this.licenseeName));
            logger.info((Object)("Issued " + this.issueDate));
            logger.info((Object)(this.expiryDate == null ? "Never Expires" : "Expires " + this.expiryDate));
            logger.info((Object)"License terms:");
            this.limits.list(System.out);
        }
    }

    protected void parseFile(InputStream xmlStream, InputStream licenseStream) throws LicenseReadException {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        ByteColonFormat bcf = new ByteColonFormat();
        try {
            short[] n = new short[]{235, 156, 165, 232, 147, 108, 6, 156, 151, 155, 54, 208, 55, 141, 67, 239, 235, 243, 69, 207, 64, 129, 200, 163, 63, 112, 9, 11, 17, 202};
            MessageDigest md = MessageDigest.getInstance("MD5");
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            db.setEntityResolver(new LicenseDTDResolver(licenseStream));
            Document d = db.parse(xmlStream);
            Element de = d.getDocumentElement();
            Element elem = (Element)de.getElementsByTagName("licensee").item(0);
            this.licenseeName = elem.getFirstChild().getNodeValue();
            md.update(this.licenseeName.getBytes());
            md.update((byte)n[this.licenseeName.length() % n.length]);
            elem = (Element)de.getElementsByTagName("product").item(0);
            this.productName = elem.getFirstChild().getNodeValue();
            this.minVersion = new Version(elem.getAttribute("min-version"));
            this.maxVersion = new Version(elem.getAttribute("max-version"));
            md.update(this.productName.getBytes());
            md.update((byte)this.minVersion.getMajor());
            md.update((byte)this.minVersion.getMinor());
            md.update((byte)this.minVersion.getTiny());
            md.update((byte)this.maxVersion.getMajor());
            md.update((byte)this.maxVersion.getMinor());
            md.update((byte)this.maxVersion.getTiny());
            md.update((byte)n[(this.minVersion.getMajor() + this.minVersion.getMinor() + this.minVersion.getTiny()) * this.productName.length() % n.length]);
            md.update((byte)n[(this.maxVersion.getMajor() + this.maxVersion.getMinor() + this.maxVersion.getTiny()) * this.productName.length() % n.length]);
            elem = (Element)de.getElementsByTagName("issued").item(0);
            int year = Integer.parseInt(elem.getAttribute("year"));
            int month = Integer.parseInt(elem.getAttribute("month"));
            int day = Integer.parseInt(elem.getAttribute("day"));
            this.issueDate = new GregorianCalendar(year, month - 1, day, 0, 0).getTime();
            md.update(df.format(this.issueDate).getBytes());
            elem = (Element)de.getElementsByTagName("expires").item(0);
            if (elem != null) {
                year = Integer.parseInt(elem.getAttribute("year"));
                month = Integer.parseInt(elem.getAttribute("month"));
                day = Integer.parseInt(elem.getAttribute("day"));
                this.expiryDate = new GregorianCalendar(year, month - 1, day, 23, 59).getTime();
                md.update(df.format(this.expiryDate).getBytes());
            }
            elem = (Element)de.getElementsByTagName("key").item(0);
            String licenseKey = elem.getFirstChild().getNodeValue();
            byte[] k = bcf.parse(licenseKey);
            NodeList limitNodeList = d.getElementsByTagName("limit");
            this.limits = new Properties();
            for (int i = 0; i < limitNodeList.getLength(); ++i) {
                Element limitNode = (Element)limitNodeList.item(i);
                String propName = limitNode.getAttribute("property");
                String propValue = limitNode.getAttribute("value");
                this.limits.setProperty(propName, propValue);
                md.update(propName.getBytes());
                md.update(propValue.getBytes());
            }
            byte[] m = md.digest();
            if (!Arrays.equals(k, m)) {
                throw new LicenseReadException("Invalid key", null);
            }
        }
        catch (Exception e) {
            throw new LicenseReadException("Could not load product license descriptor", e);
        }
    }

    public String getLicenseeName() {
        return this.licenseeName;
    }

    public String getProductName() {
        return this.productName;
    }

    public Version getMinVersion() {
        return (Version)this.minVersion.clone();
    }

    public Version getMaxVersion() {
        return (Version)this.maxVersion.clone();
    }

    public Date getIssueDate() {
        return (Date)this.issueDate.clone();
    }

    public Date getExpiryDate() {
        if (this.expiryDate == null) {
            return null;
        }
        return (Date)this.expiryDate.clone();
    }

    public Properties getLimits() {
        return (Properties)this.limits.clone();
    }

    public String getLimit(String property) {
        return this.limits.getProperty(property);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class LicenseDTDResolver
    implements EntityResolver {
        InputStream stream;

        public LicenseDTDResolver(InputStream dtdStream) {
            this.stream = dtdStream;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId.equals("license.dtd") && this.stream != null) {
                return new InputSource(this.stream);
            }
            return null;
        }
    }
}

