/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.security;

import ca.sqlpower.security.PLGroup;
import ca.sqlpower.security.PLSecurityException;
import ca.sqlpower.security.PLSecurityManager;
import ca.sqlpower.security.PLUser;
import ca.sqlpower.sql.DatabaseObject;
import ca.sqlpower.sql.SQL;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;

public class EmailNotification
implements Serializable {
    public static void setPref(Connection con, PLSecurityManager sm, PLUser notifyUser, DatabaseObject notifyAbout, String viewKpi, String emailRed, String emailYellow, String emailGreen, Double kpiWeight) throws SQLException, PLSecurityException {
        sm.checkModify(con, notifyUser);
        EmailNotification.setPref(con, notifyUser.getUserId(), true, notifyAbout, viewKpi, emailRed, emailYellow, emailGreen, kpiWeight);
    }

    public static void setPref(Connection con, PLSecurityManager sm, PLGroup notifyGroup, DatabaseObject notifyAbout, String viewKpi, String emailRed, String emailYellow, String emailGreen, Double kpiWeight) throws SQLException, PLSecurityException {
        sm.checkModify(con, notifyGroup);
        EmailNotification.setPref(con, notifyGroup.getGroupName(), false, notifyAbout, viewKpi, emailRed, emailYellow, emailGreen, kpiWeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setPref(Connection con, String notifyName, boolean nameIsUser, DatabaseObject notifyAbout, String viewKpi, String emailRed, String emailYellow, String emailGreen, Double kpiWeight) throws SQLException {
        Statement stmt;
        block25: {
            stmt = null;
            ResultSet rs = null;
            boolean bFirst = true;
            try {
                stmt = con.createStatement();
                StringBuffer sql = new StringBuffer();
                sql.setLength(0);
                if (nameIsUser) {
                    sql.append("SELECT count(*) FROM pl_user_notification");
                    sql.append(" WHERE user_id=");
                } else {
                    sql.append("SELECT count(*) FROM pl_group_notification");
                    sql.append(" WHERE group_name=");
                }
                sql.append(SQL.quote(notifyName));
                sql.append(" AND object_type=").append(SQL.quote(notifyAbout.getObjectType()));
                sql.append(" AND object_name=").append(SQL.quote(notifyAbout.getObjectName()));
                rs = stmt.executeQuery(sql.toString());
                sql.setLength(0);
                if (rs.next()) {
                    int rowCount = rs.getInt(1);
                    if (rowCount > 0) {
                        if (nameIsUser) {
                            sql.append("UPDATE pl_user_notification");
                        } else {
                            sql.append("UPDATE pl_group_notification");
                        }
                        sql.append(" SET");
                        if (!viewKpi.equals("")) {
                            sql.append(" view_kpi_ind=").append(SQL.quote(viewKpi));
                            bFirst = false;
                        }
                        if (!emailRed.equals("")) {
                            if (!bFirst) {
                                sql.append(",");
                            }
                            sql.append(" email_red_ind=").append(SQL.quote(emailRed));
                            bFirst = false;
                        }
                        if (!emailYellow.equals("")) {
                            if (!bFirst) {
                                sql.append(",");
                            }
                            sql.append(" email_yellow_ind=").append(SQL.quote(emailYellow));
                            bFirst = false;
                        }
                        if (!emailGreen.equals("")) {
                            if (!bFirst) {
                                sql.append(",");
                            }
                            sql.append(" email_green_ind=").append(SQL.quote(emailGreen));
                            bFirst = false;
                        }
                        if (kpiWeight > 0.0) {
                            if (!bFirst) {
                                sql.append(",");
                            }
                            sql.append(" kpi_weight=").append(kpiWeight);
                            bFirst = false;
                        }
                        if (nameIsUser) {
                            sql.append(" WHERE user_id=");
                        } else {
                            sql.append(" WHERE group_name=");
                        }
                        sql.append(SQL.quote(notifyName));
                        sql.append(" AND object_type=").append(SQL.quote(notifyAbout.getObjectType()));
                        sql.append(" AND object_name=").append(SQL.quote(notifyAbout.getObjectName()));
                    } else {
                        if (nameIsUser) {
                            sql.append("INSERT INTO pl_user_notification(user_id,");
                        } else {
                            sql.append("INSERT INTO pl_group_notification(group_name,");
                        }
                        sql.append(" object_type, object_name, view_kpi_ind, kpi_weight,");
                        sql.append(" email_red_ind, email_yellow_ind, email_green_ind)");
                        sql.append(" VALUES( ");
                        sql.append(SQL.quote(notifyName)).append(",");
                        sql.append(SQL.quote(notifyAbout.getObjectType())).append(",");
                        sql.append(SQL.quote(notifyAbout.getObjectName())).append(",");
                        sql.append(SQL.quote(viewKpi)).append(",");
                        sql.append(kpiWeight).append(",");
                        sql.append(SQL.quote(emailRed)).append(",");
                        sql.append(SQL.quote(emailYellow)).append(",");
                        sql.append(SQL.quote(emailGreen)).append(")");
                    }
                }
                stmt.executeUpdate(sql.toString());
                Object var15_14 = null;
                if (rs == null) break block25;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
    }

    public static boolean checkUserStatus(Connection con, PLUser user, DatabaseObject dbObj, String runStatus) throws SQLException {
        return EmailNotification.checkStatus(con, user.getUserId(), true, dbObj, runStatus);
    }

    public static boolean checkStatus(Connection con, PLUser user, DatabaseObject dbObj, String runStatus) throws SQLException {
        if (EmailNotification.checkStatus(con, user.getUserId(), true, dbObj, runStatus)) {
            return true;
        }
        Iterator groups = user.getGroups(con).iterator();
        while (groups.hasNext()) {
            PLGroup g = (PLGroup)groups.next();
            if (!EmailNotification.checkStatus(con, g.getGroupName(), false, dbObj, runStatus)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkStatus(Connection con, PLGroup group, DatabaseObject dbObj, String runStatus) throws SQLException {
        return EmailNotification.checkStatus(con, group.getGroupName(), false, dbObj, runStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean checkStatus(Connection con, String name, boolean nameIsUser, DatabaseObject dbObj, String runStatus) throws SQLException {
        Statement stmt = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT run_status");
            if (nameIsUser) {
                sql.append(" FROM pl_user_notification");
                sql.append(" WHERE user_id=").append(SQL.quote(name));
            } else {
                sql.append(" FROM pl_group_notification");
                sql.append(" WHERE group_name=").append(SQL.quote(name));
            }
            sql.append(" AND object_type=").append(SQL.quote(dbObj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(dbObj.getObjectName()));
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                String prefStatus = rs.getString(1);
                if (prefStatus == null || !prefStatus.equals(runStatus)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDatabaseObject(Connection con, PLSecurityManager sm, DatabaseObject obj) throws PLSecurityException, SQLException {
        sm.checkDelete(con, obj);
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("DELETE FROM pl_user_notification WHERE object_type=");
            sql.append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("DELETE FROM pl_user_notification_log WHERE object_type=");
            sql.append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("DELETE FROM pl_group_notification");
            sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameDatabaseObject(Connection con, PLSecurityManager sm, DatabaseObject obj, String newName) throws PLSecurityException, SQLException {
        sm.checkModify(con, obj);
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE pl_user_notification SET object_name=").append(SQL.quote(newName));
            sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("UPDATE pl_user_notification_log SET object_name=").append(SQL.quote(newName));
            sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("UPDATE pl_group_notification SET object_name=").append(SQL.quote(newName));
            sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }
}

