/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.undo;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.event.PlayPenComponentEvent;
import ca.sqlpower.architect.swingui.event.PlayPenComponentListener;
import ca.sqlpower.architect.undo.ArchitectPropertyChangeUndoableEdit;
import ca.sqlpower.architect.undo.SQLObjectInsertChildren;
import ca.sqlpower.architect.undo.SQLObjectRemoveChildren;
import ca.sqlpower.architect.undo.TablePaneLocationEdit;
import ca.sqlpower.architect.undo.UndoCompoundEvent;
import ca.sqlpower.architect.undo.UndoCompoundEventListener;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.apache.log4j.Logger;

public class UndoManager
extends javax.swing.undo.UndoManager {
    private static final Logger logger = Logger.getLogger(UndoManager.class);
    private SQLObjectUndoableEventAdapter eventAdapter = new SQLObjectUndoableEventAdapter();
    private boolean undoing;
    private boolean redoing;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public UndoManager(PlayPen playPen) throws ArchitectException {
        this.init(playPen, playPen.getDatabase());
    }

    public UndoManager(SQLObject sqlObjectRoot) throws ArchitectException {
        this.init(null, sqlObjectRoot);
    }

    private final void init(PlayPen playPen, SQLObject sqlObjectRoot) throws ArchitectException {
        ArchitectUtils.listenToHierarchy((SQLObjectListener)this.eventAdapter, sqlObjectRoot);
        ArchitectUtils.addUndoListenerToHierarchy((UndoCompoundEventListener)this.eventAdapter, sqlObjectRoot);
        if (playPen != null) {
            playPen.addUndoEventListener(this.eventAdapter);
            playPen.getPlayPenContentPane().addPlayPenComponentListener(this.eventAdapter);
        }
    }

    public synchronized boolean addEdit(UndoableEdit anEdit) {
        if (!this.isUndoing() && !this.isRedoing()) {
            logger.debug((Object)("Added new undoableEdit to undo manager " + anEdit));
            boolean success = super.addEdit(anEdit);
            this.fireStateChanged();
            return success;
        }
        return true;
    }

    public synchronized void undo() throws CannotUndoException {
        this.undoing = true;
        super.undo();
        this.fireStateChanged();
        this.undoing = false;
    }

    public synchronized void redo() throws CannotRedoException {
        this.redoing = true;
        super.redo();
        this.fireStateChanged();
        this.redoing = false;
    }

    public synchronized boolean canUndo() {
        return super.canUndo() && this.eventAdapter.canUndoOrRedo();
    }

    public synchronized boolean canRedo() {
        return super.canRedo() && this.eventAdapter.canUndoOrRedo();
    }

    public int getUndoableEditCount() {
        if (this.editToBeUndone() == null) {
            return 0;
        }
        int count = this.edits.indexOf(this.editToBeUndone()) + 1;
        return count;
    }

    public int getRedoableEditCount() {
        if (this.editToBeRedone() == null) {
            return 0;
        }
        int count = this.edits.size() - this.edits.indexOf(this.editToBeRedone());
        return count;
    }

    public boolean isRedoing() {
        return this.redoing;
    }

    public boolean isUndoing() {
        return this.undoing;
    }

    public boolean isUndoOrRedoing() {
        return this.undoing || this.redoing;
    }

    public SQLObjectUndoableEventAdapter getEventAdapter() {
        return this.eventAdapter;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(event);
        }
    }

    public String printUndoVector() {
        StringBuffer sb = new StringBuffer();
        for (Object o : this.edits) {
            sb.append(o).append("\n");
        }
        return sb.toString();
    }

    public class SQLObjectUndoableEventAdapter
    implements UndoCompoundEventListener,
    SQLObjectListener,
    PropertyChangeListener,
    PlayPenComponentListener {
        private CompoundEdit ce = null;
        private int compoundEditStackCount = 0;
        private HashMap<PlayPenComponent, Point> newPositions = new HashMap();
        private HashMap<PlayPenComponent, Point> originalPositions = new HashMap();

        public boolean canUndoOrRedo() {
            return this.ce == null;
        }

        private void compoundGroupStart(String toolTip) {
            if (UndoManager.this.isUndoOrRedoing()) {
                return;
            }
            ++this.compoundEditStackCount;
            if (this.compoundEditStackCount == 1) {
                this.ce = new CompEdit(toolTip);
                UndoManager.this.fireStateChanged();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("compoundGroupStart: edit stack =" + this.compoundEditStackCount));
            }
        }

        private void compoundGroupEnd() {
            if (UndoManager.this.isUndoOrRedoing()) {
                return;
            }
            if (this.compoundEditStackCount <= 0) {
                throw new IllegalStateException("No compound edit in progress");
            }
            --this.compoundEditStackCount;
            if (this.compoundEditStackCount == 0) {
                this.returnToEditState();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("compoundGroupEnd: edit stack =" + this.compoundEditStackCount + " ce=" + this.ce));
            }
        }

        private void addEdit(UndoableEdit undoEdit) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding new edit: " + undoEdit));
            }
            if (this.compoundEditStackCount == 0) {
                UndoManager.this.addEdit(undoEdit);
            } else {
                this.ce.addEdit(undoEdit);
            }
        }

        public void dbChildrenInserted(SQLObjectEvent e) {
            if (UndoManager.this.isUndoOrRedoing()) {
                return;
            }
            SQLObjectInsertChildren undoEvent = new SQLObjectInsertChildren();
            undoEvent.createEditFromEvent(e);
            this.addEdit(undoEvent);
            try {
                ArchitectUtils.listenToHierarchy((SQLObjectListener)this, e.getChildren());
                ArchitectUtils.addUndoListenerToHierarchy((UndoCompoundEventListener)this, e.getChildren());
            }
            catch (ArchitectException ex) {
                logger.error((Object)"SQLObjectUndoableEventAdapter cannot attach to new children", (Throwable)ex);
            }
        }

        public void dbChildrenRemoved(SQLObjectEvent e) {
            if (UndoManager.this.isUndoOrRedoing()) {
                return;
            }
            SQLObjectRemoveChildren undoEvent = new SQLObjectRemoveChildren();
            undoEvent.createEditFromEvent(e);
            this.addEdit(undoEvent);
        }

        public void dbObjectChanged(SQLObjectEvent e) {
            if (UndoManager.this.isUndoOrRedoing()) {
                return;
            }
            if (!(e.getSource() instanceof SQLDatabase) || !e.getPropertyName().equals("shortDisplayName")) {
                ArchitectPropertyChangeUndoableEdit undoEvent = new ArchitectPropertyChangeUndoableEdit(e);
                this.addEdit(undoEvent);
            }
        }

        public void dbStructureChanged(SQLObjectEvent e) {
            logger.error((Object)"Unexpected structure change event");
            UndoManager.this.discardAllEdits();
        }

        private void returnToEditState() {
            if (this.compoundEditStackCount != 0) {
                throw new IllegalStateException("The compound edit stack (" + this.compoundEditStackCount + ") should be 0");
            }
            ArrayList<PlayPenComponentEvent> condensedMoveEvents = new ArrayList<PlayPenComponentEvent>();
            for (Map.Entry<PlayPenComponent, Point> ent : this.newPositions.entrySet()) {
                PlayPenComponent ppc = ent.getKey();
                Point oldPos = this.originalPositions.get(ppc);
                Point newPos = ent.getValue();
                condensedMoveEvents.add(new PlayPenComponentEvent(ppc, oldPos, newPos));
            }
            if (this.ce != null) {
                if (condensedMoveEvents.size() > 0) {
                    TablePaneLocationEdit tableEdit = new TablePaneLocationEdit(condensedMoveEvents);
                    this.ce.addEdit(tableEdit);
                }
                this.ce.end();
                this.newPositions.clear();
                if (this.ce.canUndo()) {
                    logger.debug((Object)("Adding compound edit " + this.ce + " to undo manager"));
                    UndoManager.this.addEdit(this.ce);
                } else {
                    logger.debug((Object)("Compound edit " + this.ce + " is not undoable so we are not adding it"));
                }
                this.ce = null;
            } else {
                if (condensedMoveEvents.size() > 0) {
                    UndoManager.this.addEdit(new TablePaneLocationEdit(condensedMoveEvents));
                }
                this.newPositions.clear();
            }
            UndoManager.this.fireStateChanged();
            logger.debug((Object)"Returning to regular state");
        }

        public void componentMoved(PlayPenComponentEvent e) {
            if (UndoManager.this.isUndoOrRedoing()) {
                return;
            }
            if (e.getSource() instanceof Relationship) {
                return;
            }
            if (this.newPositions.put(e.getPPComponent(), e.getNewPoint()) == null) {
                this.originalPositions.put(e.getPPComponent(), e.getOldPoint());
            }
            if (this.ce == null) {
                this.returnToEditState();
            }
        }

        public void componentResized(PlayPenComponentEvent e) {
            if (UndoManager.this.isUndoOrRedoing()) {
                return;
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (UndoManager.this.isUndoOrRedoing()) {
                return;
            }
        }

        public void compoundEditStart(UndoCompoundEvent e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("compoundEditStart with event: " + e.toString()));
            }
            this.compoundGroupStart(e.getMessage());
        }

        public void compoundEditEnd(UndoCompoundEvent e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("compoundEditEnd with event: " + e.toString()));
            }
            this.compoundGroupEnd();
        }

        private final class CompEdit
        extends CompoundEdit {
            String toolTip;

            public CompEdit(String toolTip) {
                this.toolTip = toolTip;
            }

            public String getPresentationName() {
                return this.toolTip;
            }

            public String getUndoPresentationName() {
                return "Undo " + this.getPresentationName();
            }

            public String getRedoPresentationName() {
                return "Redo " + this.getPresentationName();
            }

            public boolean canUndo() {
                return super.canUndo() && this.edits.size() > 0;
            }

            public boolean canRedo() {
                return super.canRedo() && this.edits.size() > 0;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                for (Object o : this.edits) {
                    sb.append(o).append("\n");
                }
                return sb.toString();
            }
        }
    }
}

