/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.undo;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.CreateRelationshipAction;
import ca.sqlpower.architect.undo.UndoCompoundEvent;
import ca.sqlpower.architect.undo.UndoManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import junit.framework.TestCase;

public class TestUndoManager
extends TestCase {
    UndoManager undoManager;
    PlayPen pp;
    SQLTable fkTable;
    SQLTable pkTable;
    TablePane tp2;

    protected void setUp() throws Exception {
        super.setUp();
        System.out.println("-----------------Start setup for " + this.getName() + "----------------");
        SQLDatabase db = new SQLDatabase();
        this.pp = new PlayPen(db);
        this.fkTable = new SQLTable(db, true);
        this.fkTable.setName("child");
        TablePane tp = new TablePane(this.fkTable, this.pp);
        this.pp.addTablePane(tp, new Point(1, 1));
        this.pkTable = new SQLTable(db, true);
        this.pkTable.setName("parent");
        this.tp2 = new TablePane(this.pkTable, this.pp);
        this.pp.addTablePane(this.tp2, new Point(1, 1));
        this.undoManager = new UndoManager(this.pp);
        this.pkTable.addColumn(new SQLColumn());
        this.pkTable.addColumn(new SQLColumn());
        this.pkTable.getColumn(0).setPrimaryKeySeq(1);
        this.pkTable.getColumn(0).setName("pk1");
        this.pkTable.getColumn(0).setType(4);
        this.pkTable.getColumn(1).setPrimaryKeySeq(1);
        this.pkTable.getColumn(1).setName("pk2");
        this.pkTable.getColumn(1).setType(4);
        db.addChild(this.pkTable);
        db.addChild(this.fkTable);
        System.out.println("-----------------End setup for " + this.getName() + "----------------");
    }

    public void testUndoManagerActionUpdates() throws ArchitectException {
        this.undoManager = new UndoManager(this.pp);
        AbstractUndoableEdit stubEdit = new AbstractUndoableEdit(){

            public String getPresentationName() {
                return "cows";
            }
        };
        CL cl = new CL();
        this.undoManager.addChangeListener(cl);
        this.undoManager.addEdit(stubEdit);
        TestUndoManager.assertEquals((String)"cows", (String)this.undoManager.getPresentationName());
        TestUndoManager.assertEquals((String)"Change listener wasn't notified", (int)1, (int)cl.getChangeCount());
        TestUndoManager.assertTrue((boolean)this.undoManager.canUndo());
        this.undoManager.undo();
        TestUndoManager.assertEquals((String)"Change listener wasn't notified", (int)2, (int)cl.getChangeCount());
        TestUndoManager.assertTrue((boolean)this.undoManager.canRedo());
        TestUndoManager.assertFalse((boolean)this.undoManager.canUndo());
    }

    public void testAllowCompoundEdit() {
        AbstractUndoableEdit stubEdit1 = new AbstractUndoableEdit();
        AbstractUndoableEdit stubEdit2 = new AbstractUndoableEdit();
        AbstractUndoableEdit stubEdit3 = new AbstractUndoableEdit();
        CompoundEdit ce = new CompoundEdit();
        ce.addEdit(stubEdit1);
        ce.addEdit(stubEdit2);
        ce.addEdit(stubEdit3);
        ce.end();
        this.undoManager.addEdit(ce);
        TestUndoManager.assertTrue((boolean)this.undoManager.canUndo());
    }

    public void testNestedCompoundEdits() {
        this.pkTable.setName("old");
        this.fkTable.setName("old");
        this.pkTable.setRemarks("old");
        this.fkTable.setRemarks("old");
        this.undoManager.getEventAdapter().compoundEditStart(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_START, "Starting compoundedit"));
        this.pkTable.setName("one");
        this.undoManager.getEventAdapter().compoundEditStart(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_START, "Starting nested compoundedit"));
        this.fkTable.setName("two");
        this.undoManager.getEventAdapter().compoundEditEnd(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_END, "Ending nested compoundedit"));
        this.pkTable.setRemarks("three");
        this.undoManager.getEventAdapter().compoundEditEnd(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_END, "Ending compoundedit"));
        this.fkTable.setRemarks("four");
        TestUndoManager.assertEquals((String)"one", (String)this.pkTable.getName());
        TestUndoManager.assertEquals((String)"two", (String)this.fkTable.getName());
        TestUndoManager.assertEquals((String)"three", (String)this.pkTable.getRemarks());
        TestUndoManager.assertEquals((String)"four", (String)this.fkTable.getRemarks());
        this.undoManager.undo();
        TestUndoManager.assertEquals((String)"one", (String)this.pkTable.getName());
        TestUndoManager.assertEquals((String)"two", (String)this.fkTable.getName());
        TestUndoManager.assertEquals((String)"three", (String)this.pkTable.getRemarks());
        TestUndoManager.assertEquals((String)"old", (String)this.fkTable.getRemarks());
        this.undoManager.undo();
        TestUndoManager.assertEquals((String)"old", (String)this.pkTable.getName());
        TestUndoManager.assertEquals((String)"old", (String)this.fkTable.getName());
        TestUndoManager.assertEquals((String)"old", (String)this.pkTable.getRemarks());
        TestUndoManager.assertEquals((String)"old", (String)this.fkTable.getRemarks());
    }

    public void testCompoundEditsUndoInCorrectOrder() {
        UndoTester myTester = new UndoTester();
        UndoManager.SQLObjectUndoableEventAdapter adapter = this.undoManager.getEventAdapter();
        myTester.addUndoEventListener(adapter);
        myTester.startCompoundEdit("Test Compound undo");
        adapter.dbObjectChanged(new SQLObjectEvent(myTester, "foo", new Integer(0), new Integer(1)));
        adapter.dbObjectChanged(new SQLObjectEvent(myTester, "foo", new Integer(1), new Integer(2)));
        adapter.dbObjectChanged(new SQLObjectEvent(myTester, "foo", new Integer(2), new Integer(3)));
        myTester.endCompoundEdit("Test Compound undo");
        this.undoManager.undo();
        TestUndoManager.assertEquals((Object)new Integer(2), (Object)myTester.history.get(0));
        TestUndoManager.assertEquals((Object)new Integer(1), (Object)myTester.history.get(1));
        TestUndoManager.assertEquals((Object)new Integer(0), (Object)myTester.history.get(2));
    }

    public void testUndoCreateRelationship() throws ArchitectException {
        TestUndoManager.assertEquals((String)"Oops started out with relationships", (int)0, (int)this.pkTable.getExportedKeys().size());
        TestUndoManager.assertEquals((String)"Oops started out with relationships", (int)0, (int)this.fkTable.getImportedKeys().size());
        CreateRelationshipAction.doCreateRelationship(this.pkTable, this.fkTable, this.pp, false);
        TestUndoManager.assertEquals((String)"Wrong number of relationships created", (int)1, (int)this.pp.getRelationships().size());
        TestUndoManager.assertEquals((String)"Did the relationship create the columns in the fkTable", (int)2, (int)this.fkTable.getColumns().size());
        TestUndoManager.assertNull((String)"First column should not be in PK", (Object)this.fkTable.getColumns().get(0).getPrimaryKeySeq());
        TestUndoManager.assertNull((String)"Second column should not be in PK", (Object)this.fkTable.getColumns().get(1).getPrimaryKeySeq());
        TestUndoManager.assertEquals((String)"first column should be called 'pk1'", (String)"pk1", (String)this.fkTable.getColumns().get(0).getName());
        TestUndoManager.assertEquals((String)"second column should be called 'pk2'", (String)"pk2", (String)this.fkTable.getColumns().get(1).getName());
        TestUndoManager.assertTrue((String)"Not registering create action with the undo manager", (boolean)this.undoManager.canUndo());
        System.out.println(this.undoManager.toString());
        System.out.println("==UNDOING==");
        this.undoManager.undo();
        TestUndoManager.assertEquals((String)"Relationship still attached to parent", (int)0, (int)this.pkTable.getExportedKeys().size());
        TestUndoManager.assertEquals((String)"Relationship still attached to child", (int)0, (int)this.fkTable.getImportedKeys().size());
        TestUndoManager.assertNull((String)"Orphaned imported key", (Object)this.fkTable.getColumnByName("pk1"));
        TestUndoManager.assertNull((String)"Orphaned imported key", (Object)this.fkTable.getColumnByName("pk2"));
        TestUndoManager.assertNotNull((String)"Missing exported key", (Object)this.pkTable.getColumnByName("pk1"));
        TestUndoManager.assertNotNull((String)"Missing exported key", (Object)this.pkTable.getColumnByName("pk2"));
    }

    public void testRedoCreateRelationship() throws ArchitectException {
        this.testUndoCreateRelationship();
        System.out.println("==REDOING==");
        this.undoManager.redo();
        TestUndoManager.assertEquals((String)"Wrong number of relationships created", (int)1, (int)this.pp.getRelationships().size());
        TestUndoManager.assertEquals((String)"key didn't get re-added to pktable", (int)1, (int)this.pkTable.getExportedKeys().size());
        TestUndoManager.assertEquals((String)"key didn't get re-added to fktable", (int)1, (int)this.fkTable.getImportedKeys().size());
        List<SQLColumn> columns = this.fkTable.getColumns();
        TestUndoManager.assertEquals((String)"Wrong number of columns in the fkTable", (int)2, (int)columns.size());
        TestUndoManager.assertEquals((String)"Is the first column pk1?", (String)"pk1", (String)columns.get(0).getName());
        TestUndoManager.assertNull((String)"Is the first column a key column?", (Object)columns.get(0).getPrimaryKeySeq());
        TestUndoManager.assertEquals((String)"redo left incorrect reference count on pk1", (int)1, (int)columns.get(0).getReferenceCount());
        TestUndoManager.assertEquals((String)"Is the second column pk2?", (String)"pk2", (String)columns.get(1).getName());
        TestUndoManager.assertNull((String)"Is the second column a key column?", (Object)columns.get(1).getPrimaryKeySeq());
        TestUndoManager.assertEquals((String)"redo left incorrect reference count on pk2", (int)1, (int)columns.get(1).getReferenceCount());
    }

    public void testUndoRedoCreateRelationship() throws ArchitectException {
        this.testRedoCreateRelationship();
        System.out.println("==UNDOING the redo==");
        this.undoManager.undo();
        TestUndoManager.assertEquals((String)"Relationship still attached to parent", (int)0, (int)this.pkTable.getExportedKeys().size());
        TestUndoManager.assertEquals((String)"Relationship still attached to child", (int)0, (int)this.fkTable.getImportedKeys().size());
        TestUndoManager.assertNull((String)"Orphaned imported key", (Object)this.fkTable.getColumnByName("pk1"));
        TestUndoManager.assertNull((String)"Orphaned imported key", (Object)this.fkTable.getColumnByName("pk2"));
        TestUndoManager.assertNotNull((String)"Missing exported key", (Object)this.pkTable.getColumnByName("pk1"));
        TestUndoManager.assertNotNull((String)"Missing exported key", (Object)this.pkTable.getColumnByName("pk2"));
    }

    public void testUndoRelationshipPkAttributeChange() throws ArchitectException {
        CreateRelationshipAction.doCreateRelationship(this.pkTable, this.fkTable, this.pp, false);
        SQLColumn pk1 = this.pkTable.getColumnByName("pk1");
        TestUndoManager.assertEquals((String)"pk1 was already the new type.. makes testing silly", (int)pk1.getType(), (int)4);
        SQLColumn fk1 = this.fkTable.getColumnByName("pk1");
        TestUndoManager.assertNotNull((String)"fk column not in fkTable", (Object)fk1);
        TestUndoManager.assertEquals((String)"pk and fk must start out with same datatype", (int)pk1.getType(), (int)fk1.getType());
        pk1.setType(-2);
        TestUndoManager.assertEquals((String)"fkTable not updated when the pktable was updated", (int)-2, (int)fk1.getType());
        this.undoManager.undo();
        TestUndoManager.assertEquals((String)"fk1 didn't go back to old type", (int)4, (int)fk1.getType());
        TestUndoManager.assertEquals((String)"pk1 didn't go back to old type", (int)4, (int)pk1.getType());
    }

    public void testUndoMovement() {
        Point oldLoc = this.tp2.getLocation();
        this.pp.startCompoundEdit("start move");
        this.tp2.setLocation(123, 456);
        this.tp2.setLocation(333, 444);
        this.tp2.setLocation(333, 344);
        this.pp.endCompoundEdit("end move");
        TestUndoManager.assertEquals((Object)new Point(333, 344), (Object)this.tp2.getLocation());
        this.undoManager.undo();
        TestUndoManager.assertEquals((Object)oldLoc, (Object)this.tp2.getLocation());
    }

    private static class CL
    implements ChangeListener {
        int changeCount;

        private CL() {
        }

        public void stateChanged(ChangeEvent e) {
            ++this.changeCount;
        }

        public int getChangeCount() {
            return this.changeCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UndoTester
    extends SQLObject {
        public List<Integer> history = new ArrayList<Integer>();

        public void setFoo(Integer v) {
            this.history.add(v);
        }

        @Override
        public SQLObject getParent() {
            return null;
        }

        @Override
        protected void setParent(SQLObject parent) {
        }

        @Override
        protected void populate() throws ArchitectException {
        }

        @Override
        public String getShortDisplayName() {
            return "test object";
        }

        @Override
        public boolean allowsChildren() {
            return false;
        }

        @Override
        public Class<? extends SQLObject> getChildType() {
            return null;
        }
    }
}

