/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.undo;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.undo.UndoManager;
import junit.framework.TestCase;

public class TestArchitectPropertyChangeUndoableEdit
extends TestCase {
    private UndoManager undoManager;
    private TestSQLObject testObject;

    protected void setUp() throws Exception {
        super.setUp();
        this.testObject = new TestSQLObject();
        this.undoManager = new UndoManager(this.testObject);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testUndoAdded() {
        TestArchitectPropertyChangeUndoableEdit.assertFalse((boolean)this.undoManager.canUndo());
        this.testObject.setFoo(1);
        this.testObject.setBar("New string");
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"Wrong number of undoable edits added to undo manager", (int)2, (int)this.undoManager.getUndoableEditCount());
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"Unexpected redoable", (int)0, (int)this.undoManager.getRedoableEditCount());
    }

    public void testUndoIntProperty() {
        this.testObject.setFoo(1);
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"foo setter didn't work!", (int)1, (int)this.testObject.getFoo());
        this.undoManager.undo();
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"undo didn't work!", (int)0, (int)this.testObject.getFoo());
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"wrong redo size", (int)1, (int)this.undoManager.getRedoableEditCount());
    }

    public void testUndoStringPropertyToNull() {
        String newBarValue = "cows often say moo";
        this.testObject.setBar("cows often say moo");
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"bar setter didn't work!", (String)"cows often say moo", (String)this.testObject.getBar());
        this.undoManager.undo();
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"undo didn't work!", null, (String)this.testObject.getBar());
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"wrong redo size", (int)1, (int)this.undoManager.getRedoableEditCount());
    }

    public void testUndoStringPropertyToNonNull() {
        String newBarValue1 = "cows often say moo";
        String newBarValue2 = "chickens don't often say moo";
        this.testObject.setBar("cows often say moo");
        this.testObject.setBar("chickens don't often say moo");
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"bar setter didn't work!", (String)"chickens don't often say moo", (String)this.testObject.getBar());
        this.undoManager.undo();
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"undo didn't work!", (String)"cows often say moo", (String)this.testObject.getBar());
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"wrong redo size", (int)1, (int)this.undoManager.getRedoableEditCount());
    }

    public void testRedoIntProperty() {
        this.testObject.setFoo(1);
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"foo setter didn't work!", (int)1, (int)this.testObject.getFoo());
        this.undoManager.undo();
        TestArchitectPropertyChangeUndoableEdit.assertTrue((boolean)this.undoManager.canRedo());
        this.undoManager.redo();
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"redo didn't work!", (int)1, (int)this.testObject.getFoo());
    }

    public void testRedoStringPropertyToNull() {
        String newBarValue = "cows often say moo";
        this.testObject.setBar("cows often say moo");
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"bar setter didn't work!", (String)"cows often say moo", (String)this.testObject.getBar());
        this.undoManager.undo();
        TestArchitectPropertyChangeUndoableEdit.assertTrue((boolean)this.undoManager.canRedo());
        this.undoManager.redo();
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"redo bar didn't work!", (String)"cows often say moo", (String)this.testObject.getBar());
    }

    public void testRedoStringPropertyToNonNull() {
        String newBarValue1 = "cows often say moo";
        String newBarValue2 = "chickens don't often say moo";
        this.testObject.setBar("cows often say moo");
        this.testObject.setBar("chickens don't often say moo");
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"bar setter didn't work!", (String)"chickens don't often say moo", (String)this.testObject.getBar());
        this.undoManager.undo();
        TestArchitectPropertyChangeUndoableEdit.assertTrue((boolean)this.undoManager.canRedo());
        this.undoManager.redo();
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"redo bar change didn't work!", (String)"chickens don't often say moo", (String)this.testObject.getBar());
    }

    public void testMultipleUndoRedo() {
        this.testObject.setFoo(1);
        this.testObject.setFoo(2);
        this.testObject.setFoo(3);
        this.testObject.setFoo(4);
        this.testObject.setFoo(5);
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"wrong number of edits", (int)5, (int)this.undoManager.getUndoableEditCount());
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"wrong number of edits", (int)0, (int)this.undoManager.getRedoableEditCount());
        this.undoManager.undo();
        this.undoManager.undo();
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"wrong number of edits", (int)3, (int)this.undoManager.getUndoableEditCount());
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"wrong number of edits", (int)2, (int)this.undoManager.getRedoableEditCount());
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"Foo has wrong value", (int)3, (int)this.testObject.getFoo());
        TestArchitectPropertyChangeUndoableEdit.assertTrue((boolean)this.undoManager.canRedo());
        this.undoManager.redo();
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"wrong number of edits", (int)4, (int)this.undoManager.getUndoableEditCount());
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"wrong number of edits", (int)1, (int)this.undoManager.getRedoableEditCount());
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"Foo has wrong value", (int)4, (int)this.testObject.getFoo());
        TestArchitectPropertyChangeUndoableEdit.assertTrue((boolean)this.undoManager.canRedo());
        this.undoManager.redo();
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"wrong number of edits", (int)5, (int)this.undoManager.getUndoableEditCount());
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"wrong number of edits", (int)0, (int)this.undoManager.getRedoableEditCount());
        TestArchitectPropertyChangeUndoableEdit.assertEquals((String)"Foo has wrong value", (int)5, (int)this.testObject.getFoo());
    }

    public void testArchitectPropertyChangeUndoableEdit() {
    }

    public void testGetPresentationName() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestSQLObject
    extends SQLObject {
        private int foo;
        private String bar;

        @Override
        public String getName() {
            return null;
        }

        @Override
        public SQLObject getParent() {
            return null;
        }

        @Override
        protected void setParent(SQLObject parent) {
        }

        @Override
        protected void populate() throws ArchitectException {
        }

        @Override
        public String getShortDisplayName() {
            return null;
        }

        @Override
        public boolean allowsChildren() {
            return false;
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            String oldBar = this.bar;
            this.bar = bar;
            this.fireDbObjectChanged("bar", oldBar, bar);
        }

        public int getFoo() {
            return this.foo;
        }

        public void setFoo(int foo) {
            int oldFoo = this.foo;
            this.foo = foo;
            this.fireDbObjectChanged("foo", oldFoo, foo);
        }

        @Override
        public Class<? extends SQLObject> getChildType() {
            return null;
        }
    }
}

