/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.table;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableUtils {
    public static void fitColumnWidth(JTable table, int colIndex, int padding) {
        TableUtils.fitColumnWidth(table, colIndex, -1, padding);
    }

    public static void fitColumnWidth(JTable table, int colIndex, int maxWidth, int padding) {
        TableColumn column = null;
        Component comp = null;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        column = table.getColumnModel().getColumn(colIndex);
        comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
        cellWidth = comp.getPreferredSize().width + 2;
        int j = 0;
        while (j < table.getRowCount()) {
            comp = table.getCellRenderer(j, colIndex).getTableCellRendererComponent(table, table.getValueAt(j, colIndex), false, false, j, colIndex);
            cellWidth = Math.max(cellWidth, comp.getPreferredSize().width + 1);
            if (maxWidth > 0 && cellWidth >= maxWidth) {
                cellWidth = maxWidth;
                break;
            }
            ++j;
        }
        column.setPreferredWidth(cellWidth + padding);
    }

    public static void fitColumnWidths(JTable table, int maxColumnWidth, int padding) {
        table.setAutoResizeMode(0);
        int colIndex = 0;
        while (colIndex < table.getColumnCount()) {
            TableUtils.fitColumnWidth(table, colIndex, maxColumnWidth, padding);
            ++colIndex;
        }
    }

    public static void fitColumnWidths(JTable table, int padding) {
        TableUtils.fitColumnWidths(table, -1, padding);
    }
}

