/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.ProfileColumn;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.CommonCloseAction;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.JDefaultButton;
import ca.sqlpower.architect.swingui.ProfilePanel;
import ca.sqlpower.architect.swingui.ProgressWatcher;
import ca.sqlpower.architect.swingui.action.SaveProfileAction;
import ca.sqlpower.architect.swingui.table.ProfileTable;
import ca.sqlpower.architect.swingui.table.ProfileTableModel;
import ca.sqlpower.architect.swingui.table.TableModelColumnAutofit;
import ca.sqlpower.architect.swingui.table.TableModelSearchDecorator;
import ca.sqlpower.architect.swingui.table.TableModelSortDecorator;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ProfilePanelAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(ProfilePanelAction.class);
    protected DBTree dbTree;
    protected ProfileManager profileManager;
    private JDialog dialog;

    public ProfilePanelAction() {
        super("Profile...", ASUtils.createJLFIcon("general/Information", "Information", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "Profile Tables");
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dbTree == null) {
            logger.debug((Object)"dbtree was null when actionPerformed called");
            return;
        }
        if (this.dbTree.getSelectionPaths() == null) {
            logger.debug((Object)"dbtree path selection was null when actionPerformed called");
            return;
        }
        TreePath targetDBPath = this.dbTree.getPathForRow(0);
        TreePath[] treePathArray = this.dbTree.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            TreePath path = treePathArray[n];
            if (path.isDescendant(targetDBPath)) {
                int answer = JOptionPane.showConfirmDialog(this.dialog, "Cannot perform profiling on the project database.\nDo you want to continue profiling?", "Continue Profiling", 2);
                if (answer != 2) break;
                return;
            }
            ++n;
        }
        try {
            HashSet<SQLObject> sqlObject = new HashSet<SQLObject>();
            TreePath[] answer = this.dbTree.getSelectionPaths();
            n2 = 0;
            int n3 = answer.length;
            while (n2 < n3) {
                TreePath tp = answer[n2];
                if (!tp.isDescendant(targetDBPath)) {
                    SQLDatabase db;
                    SQLCatalog cat;
                    SQLSchema sch;
                    SQLTable tab;
                    if (tp.getLastPathComponent() instanceof SQLDatabase) {
                        sqlObject.add((SQLDatabase)tp.getLastPathComponent());
                    } else if (tp.getLastPathComponent() instanceof SQLCatalog) {
                        SQLCatalog cat2 = (SQLCatalog)tp.getLastPathComponent();
                        sqlObject.add(cat2);
                        SQLDatabase db2 = ArchitectUtils.getAncestor(cat2, SQLDatabase.class);
                        if (db2 != null && sqlObject.contains(db2)) {
                            sqlObject.remove(db2);
                        }
                    } else if (tp.getLastPathComponent() instanceof SQLSchema) {
                        SQLDatabase db3;
                        SQLSchema sch2 = (SQLSchema)tp.getLastPathComponent();
                        sqlObject.add(sch2);
                        SQLCatalog cat3 = ArchitectUtils.getAncestor(sch2, SQLCatalog.class);
                        if (cat3 != null && sqlObject.contains(cat3)) {
                            sqlObject.remove(cat3);
                        }
                        if ((db3 = ArchitectUtils.getAncestor(sch2, SQLDatabase.class)) != null && sqlObject.contains(db3)) {
                            sqlObject.remove(db3);
                        }
                    } else if (tp.getLastPathComponent() instanceof SQLTable) {
                        tab = (SQLTable)tp.getLastPathComponent();
                        sqlObject.add(tab);
                        sch = ArchitectUtils.getAncestor(tab, SQLSchema.class);
                        if (sch != null && sqlObject.contains(sch)) {
                            sqlObject.remove(sch);
                        }
                        if ((cat = ArchitectUtils.getAncestor(sch, SQLCatalog.class)) != null && sqlObject.contains(cat)) {
                            sqlObject.remove(cat);
                        }
                        if ((db = ArchitectUtils.getAncestor(sch, SQLDatabase.class)) != null && sqlObject.contains(db)) {
                            sqlObject.remove(db);
                        }
                    } else if (tp.getLastPathComponent() instanceof SQLTable.Folder) {
                        tab = ArchitectUtils.getAncestor((SQLTable.Folder)tp.getLastPathComponent(), SQLTable.class);
                        sqlObject.add(tab);
                        sch = ArchitectUtils.getAncestor(tab, SQLSchema.class);
                        if (sch != null && sqlObject.contains(sch)) {
                            sqlObject.remove(sch);
                        }
                        if ((cat = ArchitectUtils.getAncestor(sch, SQLCatalog.class)) != null && sqlObject.contains(cat)) {
                            sqlObject.remove(cat);
                        }
                        if ((db = ArchitectUtils.getAncestor(sch, SQLDatabase.class)) != null && sqlObject.contains(db)) {
                            sqlObject.remove(db);
                        }
                    } else if (tp.getLastPathComponent() instanceof SQLColumn) {
                        tab = ((SQLColumn)tp.getLastPathComponent()).getParentTable();
                        sqlObject.add((SQLColumn)tp.getLastPathComponent());
                        sch = ArchitectUtils.getAncestor(tab, SQLSchema.class);
                        if (sch != null && sqlObject.contains(sch)) {
                            sqlObject.remove(sch);
                        }
                        if ((cat = ArchitectUtils.getAncestor(sch, SQLCatalog.class)) != null && sqlObject.contains(cat)) {
                            sqlObject.remove(cat);
                        }
                        if ((db = ArchitectUtils.getAncestor(sch, SQLDatabase.class)) != null && sqlObject.contains(db)) {
                            sqlObject.remove(db);
                        }
                    }
                }
                ++n2;
            }
            ArrayList<SQLObject> filter = new ArrayList<SQLObject>();
            final HashSet<SQLTable> tables = new HashSet<SQLTable>();
            for (SQLObject o : sqlObject) {
                if (o instanceof SQLColumn) {
                    tables.add(((SQLColumn)o).getParentTable());
                } else {
                    tables.addAll(ArchitectUtils.tablesUnder(o));
                }
                if (o instanceof SQLTable.Folder) continue;
                filter.add(o);
            }
            this.profileManager.setCancelled(false);
            JDialog d = new JDialog((Frame)ArchitectFrame.getMainInstance(), "Table Profiles");
            if (!this.dialog.isVisible()) {
                ArchitectFrame.getMainInstance().getProject().getFilter().clear();
            }
            ArchitectFrame.getMainInstance().getProject().getFilter().addAll(filter);
            final CommonCloseAction commonCloseAction = new CommonCloseAction(this.dialog);
            AbstractAction closeAction = new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                    ProfilePanelAction.this.profileManager.setCancelled(true);
                    commonCloseAction.actionPerformed(evt);
                }
            };
            closeAction.putValue("Name", "Close");
            final JDefaultButton closeButton = new JDefaultButton(closeAction);
            final JPanel progressViewPanel = new JPanel(new BorderLayout());
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            buttonPanel.add(closeButton);
            progressViewPanel.add((Component)buttonPanel, "South");
            final JProgressBar progressBar = new JProgressBar();
            progressBar.setPreferredSize(new Dimension(450, 20));
            progressViewPanel.add((Component)progressBar, "Center");
            final JLabel workingOn = new JLabel("Profiling:");
            progressViewPanel.add((Component)workingOn, "North");
            ASUtils.makeJDialogCancellable(this.dialog, commonCloseAction);
            this.dialog.getRootPane().setDefaultButton(closeButton);
            this.dialog.setContentPane(progressViewPanel);
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(ArchitectFrame.getMainInstance());
            this.dialog.setVisible(true);
            new ProgressWatcher(progressBar, this.profileManager, workingOn);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        ArrayList<SQLTable> toBeProfiled = new ArrayList<SQLTable>();
                        for (SQLTable t : tables) {
                            if (ProfilePanelAction.this.profileManager.getResult(t) != null) continue;
                            toBeProfiled.add(t);
                            workingOn.setText("Adding " + t.getName() + "  (" + toBeProfiled.size() + ")");
                        }
                        ProfilePanelAction.this.profileManager.createProfiles(toBeProfiled, workingOn);
                        progressBar.setVisible(false);
                        JLabel status = new JLabel("Generating reports, Please wait......");
                        progressViewPanel.add((Component)status, "North");
                        status.setVisible(true);
                        JTabbedPane tabPane = new JTabbedPane();
                        ProfileTableModel tm = new ProfileTableModel();
                        for (SQLObject sqo : ArchitectFrame.getMainInstance().getProject().getFilter()) {
                            tm.addFilter(sqo);
                        }
                        tm.setProfileManager(ProfilePanelAction.this.profileManager);
                        TableModelSearchDecorator searchDecorator = new TableModelSearchDecorator(tm);
                        TableModelSortDecorator tableModelSortDecorator = new TableModelSortDecorator(searchDecorator);
                        final ProfileTable viewTable = new ProfileTable(tableModelSortDecorator);
                        searchDecorator.setTableTextConverter(viewTable);
                        TableModelColumnAutofit columnAutoFit = new TableModelColumnAutofit(tableModelSortDecorator, viewTable);
                        JTableHeader tableHeader = viewTable.getTableHeader();
                        tableModelSortDecorator.setTableHeader(tableHeader);
                        columnAutoFit.setTableHeader(tableHeader);
                        viewTable.setAutoResizeMode(4);
                        ProfilePanelMouseListener profilePanelMouseListener = new ProfilePanelMouseListener();
                        profilePanelMouseListener.setTabPane(tabPane);
                        viewTable.addMouseListener(profilePanelMouseListener);
                        JScrollPane editorScrollPane = new JScrollPane(viewTable);
                        editorScrollPane.setVerticalScrollBarPolicy(22);
                        editorScrollPane.setPreferredSize(new Dimension(800, 600));
                        editorScrollPane.setMinimumSize(new Dimension(10, 10));
                        viewTable.initColumnSizes();
                        JPanel tableViewPane = new JPanel(new BorderLayout());
                        tableViewPane.add((Component)editorScrollPane, "Center");
                        JLabel searchLabel = new JLabel("Search:");
                        JTextField searchField = new JTextField(searchDecorator.getDoc(), "", 25);
                        searchField.setEditable(true);
                        JPanel searchPanel = new JPanel(new FlowLayout(2));
                        searchPanel.add(searchLabel);
                        searchPanel.add(searchField);
                        tableViewPane.add((Component)searchPanel, "North");
                        ButtonBarBuilder buttonBuilder = new ButtonBarBuilder();
                        JButton save = new JButton(new SaveProfileAction(ProfilePanelAction.this.dialog, viewTable, ProfilePanelAction.this.profileManager));
                        JButton refresh = new JButton(new AbstractAction("Refresh"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                int i;
                                HashSet<SQLTable> uniqueTables = new HashSet<SQLTable>();
                                if (viewTable.getSelectedRowCount() == 0) {
                                    i = 0;
                                    while (i < viewTable.getRowCount()) {
                                        this.refreshProfileTable(viewTable, uniqueTables, i);
                                        ++i;
                                    }
                                } else {
                                    int[] nArray = viewTable.getSelectedRows();
                                    int n = 0;
                                    int n2 = nArray.length;
                                    while (n < n2) {
                                        i = nArray[n];
                                        this.refreshProfileTable(viewTable, uniqueTables, i);
                                        ++n;
                                    }
                                }
                                try {
                                    (this).ProfilePanelAction.this.profileManager.setCancelled(false);
                                    (this).ProfilePanelAction.this.profileManager.createProfiles(uniqueTables);
                                }
                                catch (SQLException e1) {
                                    throw new RuntimeException(e1);
                                }
                                catch (ArchitectException e1) {
                                    throw new ArchitectRuntimeException(e1);
                                }
                            }

                            private void refreshProfileTable(ProfileTable viewTable2, Set<SQLTable> uniqueTables, int i) {
                                Object o = viewTable2.getValueAt(i, viewTable2.convertColumnIndexToView(ProfileColumn.valueOf("TABLE").ordinal()));
                                SQLTable table = (SQLTable)o;
                                uniqueTables.add(table);
                            }
                        });
                        JButton delete = new JButton(new AbstractAction("Delete"){

                            public void actionPerformed(ActionEvent e) {
                                int[] killMe = viewTable.getSelectedRows();
                                Arrays.sort(killMe);
                                int i = killMe.length - 1;
                                while (i >= 0) {
                                    logger.debug((Object)("Deleting row " + killMe[i] + ": " + viewTable.getValueAt(killMe[i], viewTable.convertColumnIndexToView(ProfileColumn.valueOf("COLUMN").ordinal()))));
                                    SQLColumn col = (SQLColumn)viewTable.getValueAt(killMe[i], viewTable.convertColumnIndexToView(ProfileColumn.valueOf("COLUMN").ordinal()));
                                    try {
                                        (this).ProfilePanelAction.this.profileManager.remove(col);
                                    }
                                    catch (ArchitectException e1) {
                                        ASUtils.showExceptionDialog(ProfilePanelAction.this.dialog, "Could delete row of:" + col.getName(), e1, new ArchitectExceptionReportFactory());
                                    }
                                    --i;
                                }
                            }
                        });
                        JButton deleteAll = new JButton(new AbstractAction("Delete All"){

                            public void actionPerformed(ActionEvent e) {
                                while (viewTable.getRowCount() > 0) {
                                    SQLColumn col = (SQLColumn)viewTable.getValueAt(0, viewTable.convertColumnIndexToView(ProfileColumn.valueOf("COLUMN").ordinal()));
                                    try {
                                        (this).ProfilePanelAction.this.profileManager.remove(col);
                                    }
                                    catch (ArchitectException e1) {
                                        ASUtils.showExceptionDialog(ProfilePanelAction.this.dialog, "Could delete row of:" + col.getName(), e1, new ArchitectExceptionReportFactory());
                                    }
                                }
                            }
                        });
                        JButton[] buttonArray = new JButton[]{refresh, delete, deleteAll, save, closeButton};
                        buttonBuilder.addGriddedButtons(buttonArray);
                        tableViewPane.add((Component)buttonBuilder.getPanel(), "South");
                        tabPane.addTab("Table View", tableViewPane);
                        ProfilePanel p = new ProfilePanel(ProfilePanelAction.this.profileManager);
                        p.setViewTable(viewTable);
                        p.setTabPane(tabPane);
                        p.setTableModel(tm);
                        tabPane.addTab("Graph View", p);
                        profilePanelMouseListener.setProfilePanel(p);
                        p.setChartType(ProfilePanel.ChartTypes.PIE);
                        if (viewTable.getRowCount() > 0) {
                            SQLColumn col = (SQLColumn)viewTable.getValueAt(0, viewTable.convertColumnIndexToView(ProfileColumn.valueOf("COLUMN").ordinal()));
                            p.getTableSelector().setSelectedItem(col.getParentTable());
                            p.getColumnSelector().setSelectedValue(col, true);
                        }
                        ProfilePanelAction.this.dialog.setVisible(false);
                        ProfilePanelAction.this.dialog.remove(progressViewPanel);
                        ProfilePanelAction.this.dialog.setContentPane(tabPane);
                        ProfilePanelAction.this.dialog.pack();
                        ProfilePanelAction.this.dialog.setLocationRelativeTo(ArchitectFrame.getMainInstance());
                        ProfilePanelAction.this.dialog.setVisible(true);
                    }
                    catch (SQLException e) {
                        logger.error((Object)"Error in Profile Action ", (Throwable)e);
                        ASUtils.showExceptionDialogNoReport(ProfilePanelAction.this.dbTree, "Error during profile run", e);
                    }
                    catch (ArchitectException e) {
                        logger.error((Object)"Error in Profile Action", (Throwable)e);
                        ASUtils.showExceptionDialog(ProfilePanelAction.this.dbTree, "Error during profile run", e, new ArchitectExceptionReportFactory());
                    }
                }
            }).start();
        }
        catch (Exception ex) {
            logger.error((Object)"Error in Profile Action ", (Throwable)ex);
            ASUtils.showExceptionDialog(this.dbTree, "Error during profile run", ex, new ArchitectExceptionReportFactory());
        }
    }

    public void setDBTree(DBTree dbTree) {
        this.dbTree = dbTree;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public void setProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    protected class ProfilePanelMouseListener
    implements MouseListener {
        private ProfilePanel profilePanel;
        private JTabbedPane tabPane;

        protected ProfilePanelMouseListener() {
        }

        public ProfilePanel getProfilePanel() {
            return this.profilePanel;
        }

        public void setProfilePanel(ProfilePanel profilePanel) {
            this.profilePanel = profilePanel;
        }

        public void mouseClicked(MouseEvent evt) {
            Object obj = evt.getSource();
            if (evt.getClickCount() == 2 && obj instanceof JTable) {
                JTable t = (JTable)obj;
                SQLColumn col = (SQLColumn)t.getValueAt(t.getSelectedRow(), t.convertColumnIndexToView(ProfileColumn.valueOf("COLUMN").ordinal()));
                this.profilePanel.getTableSelector().setSelectedItem(col.getParentTable());
                this.profilePanel.getColumnSelector().setSelectedValue(col, true);
                this.tabPane.setSelectedIndex(1);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public JTabbedPane getTabPane() {
            return this.tabPane;
        }

        public void setTabPane(JTabbedPane tabPane) {
            this.tabPane = tabPane;
        }
    }
}

