/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.JDBCDriverPanel;
import ca.sqlpower.architect.swingui.JDefaultButton;
import ca.sqlpower.architect.swingui.PreferencesPanel;
import ca.sqlpower.architect.swingui.action.EditTableAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class PreferencesAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(EditTableAction.class);
    protected ArchitectFrame af;

    public PreferencesAction() {
        super("User Preferences...");
        this.putValue("ShortDescription", "User Preferences");
    }

    public void actionPerformed(ActionEvent evt) {
        this.showPreferencesDialog();
    }

    public void showPreferencesDialog() {
        logger.debug((Object)"showPreferencesDialog");
        final JDialog d = new JDialog((Frame)this.af, "User Preferences");
        JPanel cp = new JPanel(new BorderLayout(12, 12));
        JTabbedPane tp = new JTabbedPane();
        cp.add((Component)tp, "Center");
        cp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        final PreferencesPanel prefPanel = new PreferencesPanel(this.af.getUserSettings());
        tp.add("General", prefPanel);
        final JDBCDriverPanel jdbcPanel = new JDBCDriverPanel(this.af.getArchitectSession());
        tp.add("JDBC Drivers", jdbcPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JDefaultButton okButton = new JDefaultButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                prefPanel.applyChanges();
                jdbcPanel.applyChanges();
                d.setVisible(false);
            }
        });
        buttonPanel.add(okButton);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                prefPanel.discardChanges();
                jdbcPanel.discardChanges();
                d.setVisible(false);
            }
        };
        cancelAction.putValue("Name", "Cancel");
        JButton cancelButton = new JButton(cancelAction);
        buttonPanel.add(cancelButton);
        ASUtils.makeJDialogCancellable(d, cancelAction);
        d.getRootPane().setDefaultButton(okButton);
        cp.add((Component)buttonPanel, "South");
        d.setContentPane(cp);
        d.pack();
        d.setLocationRelativeTo(ArchitectFrame.getMainInstance());
        d.setVisible(true);
    }

    public void setArchitectFrame(ArchitectFrame af) {
        this.af = af;
    }
}

