/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.ArchitectTestCase;
import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.CompareDMSettings;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.DBTreeModel;
import ca.sqlpower.architect.swingui.MockProgressMonitor;
import ca.sqlpower.architect.swingui.SwingUIProject;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSwingUIProject
extends ArchitectTestCase {
    private SwingUIProject project;
    private static final String ENCODING = "UTF-8";
    private boolean deleteOnExit = true;
    private final String testData = "<?xml version='1.0'?><architect-project version='0.1'> <project-name>TestSwingUIProject</project-name> <project-data-sources>  <data-source id='DS0'>   <property key='Logical' value='Not Configured' />  </data-source> </project-data-sources> <source-databases> </source-databases> <target-database dbcs-ref='DS0'>  <table id='TAB0' populated='true' primaryKeyName='id' remarks='' name='Customers' >   <folder id='FOL1' populated='true' name='Columns' type='1' >    <column id='COL2' populated='true' autoIncrement='false' name='id' defaultValue='' nullable='0' precision='10' primaryKeySeq='0' referenceCount='1' remarks='' scale='0' type='4' />    <column id='COL3' populated='true' autoIncrement='false' name='name' defaultValue='' nullable='0' precision='10' referenceCount='1' remarks='' scale='0' type='4' />   </folder>   <folder id='FOL4' populated='true' name='Exported Keys' type='3' >   </folder>   <folder id='FOL5' populated='true' name='Imported Keys' type='2' >   </folder>  </table>  <table id='TAB6' populated='true' primaryKeyName='id' remarks='' name='Orders' >   <folder id='FOL7' populated='true' name='Columns' type='1' >    <column id='COL8' populated='true' autoIncrement='false' name='i&amp;d' defaultValue=''     remarks=\"This isn't a problem\" nullable='0' precision='10' primaryKeySeq='0' referenceCount='1' scale='0' type='4' />    <column id='COL9' populated='true' autoIncrement='false' name='customer&lt;id' defaultValue='' nullable='0' precision='10' referenceCount='1' remarks='' scale='0' type='4' />   </folder>   <folder id='FOL10' populated='true' name='Exported Keys' type='3' >   </folder>   <folder id='FOL11' populated='true' name='Imported Keys' type='2' >   </folder>  </table>  <relationships>   <relationship id='REL12' populated='true' deferrability='0' deleteRule='0' fk-table-ref='TAB0' fkCardinality='6' identifying='true' name='Orders_Customers_fk' pk-table-ref='TAB6' pkCardinality='2' updateRule='0' >    <column-mapping id='CMP13' populated='true' fk-column-ref='COL2' pk-column-ref='COL8' />   </relationship>   <reference ref-id='REL12' />  </relationships> </target-database> <ddl-generator type='ca.sqlpower.architect.ddl.GenericDDLGenerator' allow-connection='true'> </ddl-generator> <compare-dm-settings sqlScriptFormat='SQLServer 2000' outputFormatAsString='ENGLISH'> <source-stuff datastoreTypeAsString='PROJECT' connectName='Arthur_test'  schema='ARCHITECT_REGRESS' filepath='' /><target-stuff datastoreTypeAsString='FILE' filePath='Testpath' /> </compare-dm-settings> <play-pen>  <table-pane table-ref='TAB0' x='85' y='101' />  <table-pane table-ref='TAB6' x='196' y='38' />  <table-link relationship-ref='REL12' pk-x='76' pk-y='60' fk-x='114' fk-y='30' /> </play-pen></architect-project>";

    public void setUp() throws Exception {
        this.project = new SwingUIProject("test");
    }

    public void testLoad() throws Exception {
        ByteArrayInputStream r = new ByteArrayInputStream("<?xml version='1.0'?><architect-project version='0.1'> <project-name>TestSwingUIProject</project-name> <project-data-sources>  <data-source id='DS0'>   <property key='Logical' value='Not Configured' />  </data-source> </project-data-sources> <source-databases> </source-databases> <target-database dbcs-ref='DS0'>  <table id='TAB0' populated='true' primaryKeyName='id' remarks='' name='Customers' >   <folder id='FOL1' populated='true' name='Columns' type='1' >    <column id='COL2' populated='true' autoIncrement='false' name='id' defaultValue='' nullable='0' precision='10' primaryKeySeq='0' referenceCount='1' remarks='' scale='0' type='4' />    <column id='COL3' populated='true' autoIncrement='false' name='name' defaultValue='' nullable='0' precision='10' referenceCount='1' remarks='' scale='0' type='4' />   </folder>   <folder id='FOL4' populated='true' name='Exported Keys' type='3' >   </folder>   <folder id='FOL5' populated='true' name='Imported Keys' type='2' >   </folder>  </table>  <table id='TAB6' populated='true' primaryKeyName='id' remarks='' name='Orders' >   <folder id='FOL7' populated='true' name='Columns' type='1' >    <column id='COL8' populated='true' autoIncrement='false' name='i&amp;d' defaultValue=''     remarks=\"This isn't a problem\" nullable='0' precision='10' primaryKeySeq='0' referenceCount='1' scale='0' type='4' />    <column id='COL9' populated='true' autoIncrement='false' name='customer&lt;id' defaultValue='' nullable='0' precision='10' referenceCount='1' remarks='' scale='0' type='4' />   </folder>   <folder id='FOL10' populated='true' name='Exported Keys' type='3' >   </folder>   <folder id='FOL11' populated='true' name='Imported Keys' type='2' >   </folder>  </table>  <relationships>   <relationship id='REL12' populated='true' deferrability='0' deleteRule='0' fk-table-ref='TAB0' fkCardinality='6' identifying='true' name='Orders_Customers_fk' pk-table-ref='TAB6' pkCardinality='2' updateRule='0' >    <column-mapping id='CMP13' populated='true' fk-column-ref='COL2' pk-column-ref='COL8' />   </relationship>   <reference ref-id='REL12' />  </relationships> </target-database> <ddl-generator type='ca.sqlpower.architect.ddl.GenericDDLGenerator' allow-connection='true'> </ddl-generator> <compare-dm-settings sqlScriptFormat='SQLServer 2000' outputFormatAsString='ENGLISH'> <source-stuff datastoreTypeAsString='PROJECT' connectName='Arthur_test'  schema='ARCHITECT_REGRESS' filepath='' /><target-stuff datastoreTypeAsString='FILE' filePath='Testpath' /> </compare-dm-settings> <play-pen>  <table-pane table-ref='TAB0' x='85' y='101' />  <table-pane table-ref='TAB6' x='196' y='38' />  <table-link relationship-ref='REL12' pk-x='76' pk-y='60' fk-x='114' fk-y='30' /> </play-pen></architect-project>".getBytes());
        this.project.load(r);
        TestSwingUIProject.assertFalse((String)"Project starts out with undo history", (boolean)this.project.getUndoManager().canUndoOrRedo());
        DBTree tree = this.project.getSourceDatabases();
        TestSwingUIProject.assertNotNull((Object)tree);
        TestSwingUIProject.assertEquals((int)tree.getComponentCount(), (int)1);
        SQLDatabase target = this.project.getTargetDatabase();
        TestSwingUIProject.assertNotNull((Object)target);
        TestSwingUIProject.assertEquals((String)target.getName(), (String)"Not Configured");
        TestSwingUIProject.assertEquals((int)target.getChildCount(), (int)2);
    }

    public void testLoadPK() throws Exception {
        this.testLoad();
        SQLDatabase target = this.project.getTargetDatabase();
        SQLTable t1 = (SQLTable)target.getChild(0);
        TestSwingUIProject.assertEquals((int)1, (int)t1.getPkSize());
        TestSwingUIProject.assertEquals((Object)new Integer(0), (Object)t1.getColumn(0).getPrimaryKeySeq());
        TestSwingUIProject.assertNull((Object)t1.getColumn(1).getPrimaryKeySeq());
    }

    private void subroutineForTestSaveLoadPK(SQLTable t) throws ArchitectException {
        TestSwingUIProject.assertEquals((int)2, (int)t.getPkSize());
        TestSwingUIProject.assertEquals((Object)new Integer(0), (Object)t.getColumn(0).getPrimaryKeySeq());
        TestSwingUIProject.assertEquals((Object)new Integer(1), (Object)t.getColumn(1).getPrimaryKeySeq());
        TestSwingUIProject.assertEquals(null, (Object)t.getColumn(2).getPrimaryKeySeq());
        TestSwingUIProject.assertFalse((boolean)t.getColumn(0).isDefinitelyNullable());
        TestSwingUIProject.assertFalse((boolean)t.getColumn(1).isDefinitelyNullable());
        TestSwingUIProject.assertTrue((boolean)t.getColumn(0).isPrimaryKey());
        TestSwingUIProject.assertTrue((boolean)t.getColumn(1).isPrimaryKey());
        TestSwingUIProject.assertFalse((boolean)t.getColumn(2).isPrimaryKey());
    }

    public void testSaveLoadPK() throws Exception {
        SQLDatabase target = this.project.getTargetDatabase();
        SQLTable t = new SQLTable(null, "test_pk", null, "TABLE", true);
        t.addColumn(new SQLColumn(t, "pk1", 1, 10, 0));
        t.addColumn(new SQLColumn(t, "pk2", 1, 10, 0));
        t.addColumn(new SQLColumn(t, "nonpk", 1, 10, 0));
        t.getColumn(0).setPrimaryKeySeq(0);
        t.getColumn(1).setPrimaryKeySeq(1);
        target.addChild(t);
        this.subroutineForTestSaveLoadPK(t);
        File tmp = File.createTempFile("test", ".architect");
        if (this.deleteOnExit) {
            tmp.deleteOnExit();
        } else {
            System.out.println("testSaveLoadPK: tmp file is " + tmp);
        }
        PrintWriter out = new PrintWriter(tmp, ENCODING);
        TestSwingUIProject.assertNotNull((Object)out);
        this.project.save(out, ENCODING);
        SwingUIProject project2 = new SwingUIProject("new test project");
        project2.load(new BufferedInputStream(new FileInputStream(tmp)));
        target = project2.getTargetDatabase();
        t = target.getTableByName("test_pk");
        this.subroutineForTestSaveLoadPK(t);
    }

    public void testSaveProgressMonitor() throws Exception {
        System.out.println("TestSwingUIProject.testSaveProgressMonitor()");
        MockProgressMonitor mockProgressMonitor = new MockProgressMonitor(null, "Hello", "Hello again", 0, 100);
        File file = File.createTempFile("test", "architect");
        this.project.setFile(file);
        this.project.save(mockProgressMonitor);
        SwingUIProject p2 = new SwingUIProject("test2");
        p2.load(new FileInputStream(file));
        File tmp2 = File.createTempFile("test2", ".architect");
        if (this.deleteOnExit) {
            tmp2.deleteOnExit();
        }
        p2.save(new PrintWriter(tmp2, ENCODING), ENCODING);
        TestSwingUIProject.assertEquals((long)file.length(), (long)tmp2.length());
    }

    public void testSavePrintWriter() throws Exception {
        this.testLoad();
        File tmp = File.createTempFile("test", ".architect");
        if (this.deleteOnExit) {
            tmp.deleteOnExit();
        }
        PrintWriter out = new PrintWriter(tmp, ENCODING);
        TestSwingUIProject.assertNotNull((Object)out);
        this.project.save(out, ENCODING);
        SwingUIProject p2 = new SwingUIProject("test2");
        p2.load(new FileInputStream(tmp));
        File tmp2 = File.createTempFile("test2", ".architect");
        if (this.deleteOnExit) {
            tmp2.deleteOnExit();
        }
        p2.save(new PrintWriter(tmp2, ENCODING), ENCODING);
        TestSwingUIProject.assertEquals((long)tmp.length(), (long)tmp2.length());
    }

    public void testSaveIsWellFormed() throws Exception {
        boolean validate = false;
        this.testLoad();
        File tmp = File.createTempFile("test", ".architect");
        if (this.deleteOnExit) {
            tmp.deleteOnExit();
        }
        PrintWriter out = new PrintWriter(tmp, ENCODING);
        TestSwingUIProject.assertNotNull((Object)out);
        this.project.setName("FOO<BAR");
        this.project.save(out, ENCODING);
        System.err.println("Parsing " + tmp + "...");
        String uri = "file:" + tmp.getAbsolutePath();
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        if (validate) {
            f.setValidating(true);
        }
        DocumentBuilder p = f.newDocumentBuilder();
        p.parse(uri);
        System.out.println("Parsed OK");
    }

    private static Map<String, Object> setAllInterestingProperties(SQLObject target, Set<String> propertiesToIgnore) throws Exception {
        PropertyDescriptor[] props = PropertyUtils.getPropertyDescriptors((Object)target);
        int i = 0;
        while (i < props.length) {
            Object oldVal = null;
            if (PropertyUtils.isReadable((Object)target, (String)props[i].getName()) && props[i].getReadMethod() != null && !propertiesToIgnore.contains(props[i].getName())) {
                oldVal = PropertyUtils.getProperty((Object)target, (String)props[i].getName());
            }
            if (PropertyUtils.isWriteable((Object)target, (String)props[i].getName()) && props[i].getWriteMethod() != null && !propertiesToIgnore.contains(props[i].getName())) {
                Object newVal;
                if (props[i].getPropertyType() == Integer.TYPE) {
                    newVal = (Integer)oldVal + 1;
                } else if (props[i].getPropertyType() == Integer.class) {
                    newVal = oldVal == null ? new Integer(1) : new Integer((Integer)oldVal + 1);
                } else if (props[i].getPropertyType() == String.class) {
                    newVal = "new " + oldVal;
                } else if (props[i].getPropertyType() == Boolean.TYPE) {
                    newVal = new Boolean((Boolean)oldVal == false);
                } else if (props[i].getPropertyType() == SQLColumn.class) {
                    newVal = new SQLColumn();
                    ((SQLColumn)newVal).setName("testing!");
                } else if (props[i].getPropertyType() == SQLIndex.IndexType.class) {
                    newVal = oldVal != SQLIndex.IndexType.HASHED ? SQLIndex.IndexType.HASHED : SQLIndex.IndexType.CLUSTERED;
                } else {
                    throw new RuntimeException("This test case lacks a value for " + props[i].getName() + " (type " + props[i].getPropertyType().getName() + ")");
                }
                PropertyUtils.setProperty((Object)target, (String)props[i].getName(), (Object)newVal);
            }
            ++i;
        }
        return TestSwingUIProject.getAllInterestingProperties(target, propertiesToIgnore);
    }

    private static Map<String, Object> getAllInterestingProperties(SQLObject target, Set<String> propertiesToIgnore) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        HashMap<String, Object> newDescription = new HashMap<String, Object>();
        PropertyDescriptor[] props = PropertyUtils.getPropertyDescriptors((Object)target);
        int i = 0;
        while (i < props.length) {
            if (PropertyUtils.isReadable((Object)target, (String)props[i].getName()) && props[i].getReadMethod() != null && !propertiesToIgnore.contains(props[i].getName())) {
                newDescription.put(props[i].getName(), PropertyUtils.getProperty((Object)target, (String)props[i].getName()));
            }
            ++i;
        }
        return newDescription;
    }

    public void testSaveCoversAllDatabaseProperties() throws Exception {
        this.testLoad();
        DBTree dbTree = this.project.getSourceDatabases();
        DBTreeModel dbTreeModel = (DBTreeModel)dbTree.getModel();
        ArchitectDataSource fakeDataSource = new ArchitectDataSource();
        SQLDatabase db = new SQLDatabase(){

            public Connection getConnection() throws ArchitectException {
                return null;
            }
        };
        db.setDataSource(fakeDataSource);
        db.setPopulated(true);
        ((SQLObject)dbTreeModel.getRoot()).addChild(db);
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        propertiesToIgnore.add("SQLObjectListeners");
        propertiesToIgnore.add("children");
        propertiesToIgnore.add("tables");
        propertiesToIgnore.add("parent");
        propertiesToIgnore.add("parentDatabase");
        propertiesToIgnore.add("class");
        propertiesToIgnore.add("childCount");
        propertiesToIgnore.add("connection");
        propertiesToIgnore.add("populated");
        propertiesToIgnore.add("secondaryChangeMode");
        propertiesToIgnore.add("dataSource");
        propertiesToIgnore.add("playPenDatabase");
        propertiesToIgnore.add("progressMonitor");
        propertiesToIgnore.add("zoomInAction");
        propertiesToIgnore.add("zoomOutAction");
        propertiesToIgnore.add("magicEnabled");
        Map<String, Object> oldDescription = TestSwingUIProject.setAllInterestingProperties(db, propertiesToIgnore);
        File tmp = File.createTempFile("test", ".architect");
        if (this.deleteOnExit) {
            tmp.deleteOnExit();
        }
        PrintWriter out = new PrintWriter(tmp, ENCODING);
        TestSwingUIProject.assertNotNull((Object)out);
        this.project.save(out, ENCODING);
        SwingUIProject project2 = new SwingUIProject("new test project");
        project2.load(new BufferedInputStream(new FileInputStream(tmp)));
        db = (SQLDatabase)project2.getSourceDatabases().getDatabaseList().get(1);
        Map<String, Object> newDescription = TestSwingUIProject.getAllInterestingProperties(db, propertiesToIgnore);
        TestSwingUIProject.assertEquals((String)"loaded-in version of database doesn't match the original!", (String)oldDescription.toString(), (String)newDescription.toString());
    }

    public void testSaveCoversAllCatalogProperties() throws Exception {
        ArchitectDataSource ds = new ArchitectDataSource();
        ds.setDisplayName("Schemaless Database");
        ds.setDriverClass("ca.sqlpower.architect.MockJDBCDriver");
        ds.setUser("fake");
        ds.setPass("fake");
        ds.setUrl("jdbc:mock:dbmd.catalogTerm=Catalog&catalogs=cat1,cat2,cat3");
        DBTreeModel dbTreeModel = null;
        this.testLoad();
        DBTree dbTree = this.project.getSourceDatabases();
        dbTreeModel = (DBTreeModel)dbTree.getModel();
        SQLDatabase db = new SQLDatabase();
        db.setDataSource(ds);
        db.setPopulated(true);
        ((SQLObject)dbTreeModel.getRoot()).addChild(db);
        SQLCatalog target = new SQLCatalog(db, "my test catalog");
        db.addChild(target);
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        propertiesToIgnore.add("SQLObjectListeners");
        propertiesToIgnore.add("children");
        propertiesToIgnore.add("parent");
        propertiesToIgnore.add("parentDatabase");
        propertiesToIgnore.add("class");
        propertiesToIgnore.add("childCount");
        propertiesToIgnore.add("secondaryChangeMode");
        propertiesToIgnore.add("populated");
        propertiesToIgnore.add("magicEnabled");
        Map<String, Object> oldDescription = TestSwingUIProject.setAllInterestingProperties(target, propertiesToIgnore);
        File tmp = File.createTempFile("test", ".architect");
        if (this.deleteOnExit) {
            tmp.deleteOnExit();
        }
        PrintWriter out = new PrintWriter(tmp, ENCODING);
        TestSwingUIProject.assertNotNull((Object)out);
        this.project.save(out, ENCODING);
        SwingUIProject project2 = new SwingUIProject("new test project");
        project2.load(new BufferedInputStream(new FileInputStream(tmp)));
        db = (SQLDatabase)project2.getSourceDatabases().getDatabaseList().get(1);
        target = (SQLCatalog)db.getChild(0);
        Map<String, Object> newDescription = TestSwingUIProject.getAllInterestingProperties(target, propertiesToIgnore);
        TestSwingUIProject.assertMapsEqual(oldDescription, newDescription);
    }

    public void testSaveCoversAllSchemaProperties() throws Exception {
        this.testLoad();
        DBTree dbTree = this.project.getSourceDatabases();
        DBTreeModel dbTreeModel = (DBTreeModel)dbTree.getModel();
        ArchitectDataSource fakeDataSource = new ArchitectDataSource();
        SQLDatabase db = new SQLDatabase();
        db.setDataSource(fakeDataSource);
        db.setPopulated(true);
        ((SQLObject)dbTreeModel.getRoot()).addChild(db);
        SQLSchema target = new SQLSchema(db, "my test schema", true);
        db.addChild(target);
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        propertiesToIgnore.add("SQLObjectListeners");
        propertiesToIgnore.add("children");
        propertiesToIgnore.add("parent");
        propertiesToIgnore.add("parentDatabase");
        propertiesToIgnore.add("class");
        propertiesToIgnore.add("childCount");
        propertiesToIgnore.add("populated");
        propertiesToIgnore.add("secondaryChangeMode");
        propertiesToIgnore.add("magicEnabled");
        Map<String, Object> oldDescription = TestSwingUIProject.setAllInterestingProperties(target, propertiesToIgnore);
        File tmp = File.createTempFile("test", ".architect");
        if (this.deleteOnExit) {
            tmp.deleteOnExit();
        }
        PrintWriter out = new PrintWriter(tmp, ENCODING);
        TestSwingUIProject.assertNotNull((Object)out);
        this.project.save(out, ENCODING);
        SwingUIProject project2 = new SwingUIProject("new test project");
        project2.load(new BufferedInputStream(new FileInputStream(tmp)));
        db = (SQLDatabase)project2.getSourceDatabases().getDatabaseList().get(1);
        target = (SQLSchema)db.getChild(0);
        Map<String, Object> newDescription = TestSwingUIProject.getAllInterestingProperties(target, propertiesToIgnore);
        TestSwingUIProject.assertMapsEqual(oldDescription, newDescription);
    }

    public void testSaveCoversAllTableProperties() throws Exception {
        this.testLoad();
        DBTree dbTree = this.project.getSourceDatabases();
        DBTreeModel dbTreeModel = (DBTreeModel)dbTree.getModel();
        ArchitectDataSource fakeDataSource = new ArchitectDataSource();
        SQLDatabase db = new SQLDatabase();
        db.setDataSource(fakeDataSource);
        db.setPopulated(true);
        ((SQLObject)dbTreeModel.getRoot()).addChild(db);
        SQLTable target = new SQLTable(db, true);
        db.addChild(target);
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        propertiesToIgnore.add("SQLObjectListeners");
        propertiesToIgnore.add("children");
        propertiesToIgnore.add("parent");
        propertiesToIgnore.add("parentDatabase");
        propertiesToIgnore.add("class");
        propertiesToIgnore.add("childCount");
        propertiesToIgnore.add("populated");
        propertiesToIgnore.add("columnsFolder");
        propertiesToIgnore.add("secondaryChangeMode");
        propertiesToIgnore.add("magicEnabled");
        Map<String, Object> oldDescription = TestSwingUIProject.setAllInterestingProperties(target, propertiesToIgnore);
        File tmp = File.createTempFile("test", ".architect");
        if (this.deleteOnExit) {
            tmp.deleteOnExit();
        }
        PrintWriter out = new PrintWriter(tmp, ENCODING);
        TestSwingUIProject.assertNotNull((Object)out);
        this.project.save(out, ENCODING);
        SwingUIProject project2 = new SwingUIProject("new test project");
        project2.load(new BufferedInputStream(new FileInputStream(tmp)));
        db = (SQLDatabase)project2.getSourceDatabases().getDatabaseList().get(1);
        target = (SQLTable)db.getChild(0);
        Map<String, Object> newDescription = TestSwingUIProject.getAllInterestingProperties(target, propertiesToIgnore);
        TestSwingUIProject.assertMapsEqual(oldDescription, newDescription);
    }

    public void testSaveCoversAllColumnProperties() throws Exception {
        String tableName = "harry";
        this.testLoad();
        SQLDatabase ppdb = this.project.getPlayPen().getDatabase();
        SQLTable table = new SQLTable(ppdb, true);
        table.setName("harry");
        SQLColumn target = new SQLColumn(table, "my cool test column", 4, 10, 10);
        ppdb.addChild(table);
        table.addColumn(target);
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        propertiesToIgnore.add("SQLObjectListeners");
        propertiesToIgnore.add("children");
        propertiesToIgnore.add("parent");
        propertiesToIgnore.add("parentTable");
        propertiesToIgnore.add("class");
        propertiesToIgnore.add("childCount");
        propertiesToIgnore.add("populated");
        propertiesToIgnore.add("undoEventListeners");
        propertiesToIgnore.add("secondaryChangeMode");
        propertiesToIgnore.add("magicEnabled");
        Map<String, Object> oldDescription = TestSwingUIProject.setAllInterestingProperties(target, propertiesToIgnore);
        DBTree dbTree = this.project.getSourceDatabases();
        DBTreeModel dbTreeModel = (DBTreeModel)dbTree.getModel();
        ArchitectDataSource fakeDataSource = new ArchitectDataSource();
        SQLDatabase db = new SQLDatabase();
        db.setDataSource(fakeDataSource);
        db.setPopulated(true);
        ((SQLObject)dbTreeModel.getRoot()).addChild(db);
        SQLTable sourceTable = new SQLTable(db, true);
        SQLColumn sourceColumn = new SQLColumn(sourceTable, "my cool source column", 4, 10, 10);
        sourceTable.addColumn(sourceColumn);
        db.addChild(sourceTable);
        target.setSourceColumn(sourceColumn);
        oldDescription.put("sourceColumn", sourceColumn);
        File tmp = File.createTempFile("test", ".architect");
        if (this.deleteOnExit) {
            tmp.deleteOnExit();
        } else {
            System.out.println("testSaveCoversAllColumnProperties: temp file is " + tmp.getAbsolutePath());
        }
        PrintWriter out = new PrintWriter(tmp, ENCODING);
        TestSwingUIProject.assertNotNull((Object)out);
        this.project.save(out, ENCODING);
        SwingUIProject project2 = new SwingUIProject("new test project");
        project2.load(new BufferedInputStream(new FileInputStream(tmp)));
        ppdb = project2.getPlayPen().getDatabase();
        target = ppdb.getTableByName("harry").getColumn(0);
        Map<String, Object> newDescription = TestSwingUIProject.getAllInterestingProperties(target, propertiesToIgnore);
        TestSwingUIProject.assertMapsEqual(oldDescription, newDescription);
    }

    public void testSaveCoversAllIndexProperties() throws Exception {
        String tableName = "rama_llama_dingdong";
        this.testLoad();
        SQLDatabase ppdb = this.project.getPlayPen().getDatabase();
        SQLTable table = new SQLTable(ppdb, true);
        table.setName("rama_llama_dingdong");
        SQLIndex target = new SQLIndex("testy index", false, null, null, null);
        ppdb.addChild(table);
        table.getIndicesFolder().addChild(target);
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        propertiesToIgnore.add("SQLObjectListeners");
        propertiesToIgnore.add("undoEventListeners");
        propertiesToIgnore.add("magicEnabled");
        propertiesToIgnore.add("children");
        propertiesToIgnore.add("parent");
        propertiesToIgnore.add("class");
        Map<String, Object> oldDescription = TestSwingUIProject.setAllInterestingProperties(target, propertiesToIgnore);
        File tmp = File.createTempFile("test", ".architect");
        if (this.deleteOnExit) {
            tmp.deleteOnExit();
        } else {
            System.out.println("testSaveCoversAllIndexProperties: temp file is " + tmp.getAbsolutePath());
        }
        PrintWriter out = new PrintWriter(tmp, ENCODING);
        TestSwingUIProject.assertNotNull((Object)out);
        this.project.save(out, ENCODING);
        SwingUIProject project2 = new SwingUIProject("new test project");
        project2.load(new BufferedInputStream(new FileInputStream(tmp)));
        ppdb = project2.getPlayPen().getDatabase();
        target = (SQLIndex)ppdb.getTableByName("rama_llama_dingdong").getIndicesFolder().getChild(0);
        Map<String, Object> newDescription = TestSwingUIProject.getAllInterestingProperties(target, propertiesToIgnore);
        TestSwingUIProject.assertMapsEqual(oldDescription, newDescription);
    }

    public void testSaveCoversAllIndexColumnProperties() throws Exception {
        SQLIndex index;
        String tableName = "delicatessen";
        this.testLoad();
        SQLDatabase ppdb = this.project.getPlayPen().getDatabase();
        SQLTable table = new SQLTable(ppdb, true);
        table.setName("delicatessen");
        SQLIndex sQLIndex = index = new SQLIndex("tasty index", false, null, null, null);
        sQLIndex.getClass();
        SQLIndex.Column target = sQLIndex.new SQLIndex.Column("phogna bologna", false, true);
        ppdb.addChild(table);
        table.getIndicesFolder().addChild(index);
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        propertiesToIgnore.add("SQLObjectListeners");
        propertiesToIgnore.add("undoEventListeners");
        propertiesToIgnore.add("magicEnabled");
        propertiesToIgnore.add("children");
        propertiesToIgnore.add("parent");
        propertiesToIgnore.add("class");
        Map<String, Object> oldDescription = TestSwingUIProject.setAllInterestingProperties(index, propertiesToIgnore);
        File tmp = File.createTempFile("test", ".architect");
        if (this.deleteOnExit) {
            tmp.deleteOnExit();
        } else {
            System.out.println("testSaveCoversAllIndexProperties: temp file is " + tmp.getAbsolutePath());
        }
        PrintWriter out = new PrintWriter(tmp, ENCODING);
        TestSwingUIProject.assertNotNull((Object)out);
        this.project.save(out, ENCODING);
        SwingUIProject project2 = new SwingUIProject("new test project");
        project2.load(new BufferedInputStream(new FileInputStream(tmp)));
        ppdb = project2.getPlayPen().getDatabase();
        index = (SQLIndex)ppdb.getTableByName("delicatessen").getIndicesFolder().getChild(0);
        Map<String, Object> newDescription = TestSwingUIProject.getAllInterestingProperties(index, propertiesToIgnore);
        TestSwingUIProject.assertMapsEqual(oldDescription, newDescription);
    }

    public void testNotModifiedWhenFreshlyLoaded() throws Exception {
        this.testLoad();
        TestSwingUIProject.assertFalse((String)"Freshly loaded project should not be marked dirty", (boolean)this.project.isModified());
    }

    public void testSaveCoversCompareDMSettings() throws Exception {
        this.testLoad();
        CompareDMSettings cds = this.project.getCompareDMSettings();
        File tmp = File.createTempFile("test", ".architect");
        TestSwingUIProject.assertFalse((boolean)cds.getSaveFlag());
        if (this.deleteOnExit) {
            tmp.deleteOnExit();
        }
        PrintWriter out = new PrintWriter(tmp, ENCODING);
        TestSwingUIProject.assertNotNull((Object)out);
        this.project.save(out, ENCODING);
        TestSwingUIProject.assertFalse((boolean)cds.getSaveFlag());
        TestSwingUIProject.assertEquals((String)"SQLServer 2000", (String)cds.getSqlScriptFormat());
        TestSwingUIProject.assertEquals((String)"ENGLISH", (String)cds.getOutputFormatAsString());
        TestSwingUIProject.assertEquals((String)"PROJECT", (String)cds.getSourceSettings().getDatastoreType().toString());
        TestSwingUIProject.assertEquals((String)"Arthur_test", (String)cds.getSourceSettings().getConnectName());
        TestSwingUIProject.assertEquals((String)"ARCHITECT_REGRESS", (String)cds.getSourceSettings().getSchema());
        TestSwingUIProject.assertEquals((String)"FILE", (String)cds.getTargetSettings().getDatastoreType().toString());
        TestSwingUIProject.assertEquals((String)"Testpath", (String)cds.getTargetSettings().getFilePath());
    }
}

