/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.DBTreeModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import junit.framework.TestCase;

public class TestDBTreeModel
extends TestCase {
    private DBTreeModel tm;

    protected void setUp() throws Exception {
        this.tm = new DBTreeModel();
        this.tm.setTestMode(true);
    }

    public void testRefireRelationshipMappingEvents() throws ArchitectException {
        SQLObject treeRoot = (SQLObject)this.tm.getRoot();
        SQLDatabase db = new SQLDatabase();
        db.setName("test database");
        SQLTable t = new SQLTable(db, true);
        t.setName("Table");
        SQLColumn c = new SQLColumn(null, "column", 2003, 1, 1);
        treeRoot.addChild(db);
        db.addChild(t);
        t.addColumn(c);
        c.setPrimaryKeySeq(0);
        SQLRelationship r = new SQLRelationship();
        r.setName("my relationship is cooler than your silly columnmnm");
        r.attachRelationship(t, t, true);
        LoggingSwingTreeModelListener l = new LoggingSwingTreeModelListener();
        this.tm.addTreeModelListener(l);
        r.removeChild(0);
        System.out.println(l);
        TestDBTreeModel.assertEquals((int)2, (int)l.getRemoveCount());
        TreePath expectPkPath = new TreePath(new Object[]{treeRoot, db, t, t.getExportedKeysFolder(), r});
        TreePath expectFkPath = new TreePath(new Object[]{treeRoot, db, t, t.getImportedKeysFolder(), r});
        HashSet<TreePath> actualPaths = new HashSet<TreePath>();
        for (TreeModelEvent tme : l.getEventLog()) {
            actualPaths.add(tme.getTreePath());
        }
        TestDBTreeModel.assertTrue((boolean)actualPaths.contains(expectFkPath));
        TestDBTreeModel.assertTrue((boolean)actualPaths.contains(expectPkPath));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoggingSwingTreeModelListener
    implements TreeModelListener {
        private int changeCount;
        private int insertCount;
        private int removeCount;
        private int structureChangeCount;
        private List<TreeModelEvent> eventLog = new ArrayList<TreeModelEvent>();

        private LoggingSwingTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            ++this.changeCount;
            this.eventLog.add(e);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            ++this.insertCount;
            this.eventLog.add(e);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            ++this.removeCount;
            this.eventLog.add(e);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            ++this.structureChangeCount;
            this.eventLog.add(e);
        }

        public int getChangeCount() {
            return this.changeCount;
        }

        public int getInsertCount() {
            return this.insertCount;
        }

        public int getRemoveCount() {
            return this.removeCount;
        }

        public int getStructureChangeCount() {
            return this.structureChangeCount;
        }

        public List<TreeModelEvent> getEventLog() {
            return this.eventLog;
        }

        public String toString() {
            return String.format("[insert: %d, remove: %d, change: %d, structure: %d, eventLog: %s]", this.insertCount, this.removeCount, this.changeCount, this.structureChangeCount, this.eventLog);
        }
    }
}

